/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.client;

import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.client.DasServer;
import edu.uiowa.physics.pw.das.client.Key;
import edu.uiowa.physics.pw.das.util.Crypt;
import edu.uiowa.physics.pw.das.util.DasDie;
import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class Authenticator
extends JPanel {
    JLabel feedbackLabel;
    JTextField tfUser;
    JPasswordField tfPass;
    DasServer dasServer;

    public Authenticator(DasServer dasServer) {
        this(dasServer, "");
    }

    public Authenticator(DasServer dasServer, String restrictedResourceLabel) {
        this.dasServer = dasServer;
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JLabel(dasServer.getName(), 2));
        this.add(new JLabel(dasServer.getLogo(), 2));
        if (!"".equals(restrictedResourceLabel)) {
            this.add(new JLabel("" + restrictedResourceLabel));
        }
        this.add(new JLabel("Username: ", 2));
        this.tfUser = new JTextField();
        DasProperties xxx = DasProperties.getInstance();
        if (!"".equals(DasProperties.getInstance().getProperty("username"))) {
            this.tfUser.setText(DasProperties.getInstance().getProperty("username"));
        }
        this.add(this.tfUser);
        this.add(new JLabel("Password: ", 2));
        this.tfPass = new JPasswordField();
        if (!"".equals(DasProperties.getInstance().getProperty("password"))) {
            this.tfPass.setText(DasProperties.getInstance().getProperty("password"));
        }
        this.add(this.tfPass);
        this.feedbackLabel = new JLabel("", 2);
        this.add(this.feedbackLabel);
    }

    public Key authenticate() {
        Key result = null;
        int okayCancel = 0;
        while (okayCancel == 0 && result == null) {
            okayCancel = JOptionPane.showConfirmDialog(null, this, "Authenticator", 2, -1);
            if (okayCancel != 0) continue;
            char[] ipass = this.tfPass.getPassword();
            String pass = String.valueOf(this.tfPass.getPassword());
            if (pass.equals(DasProperties.getInstance().getProperty("password"))) {
                pass = "sendPropertyPassword";
            }
            String username = this.tfUser.getText().trim();
            try {
                result = this.dasServer.authenticate(username, pass);
                if (result == null) {
                    this.feedbackLabel.setText("Login incorrect");
                    this.feedbackLabel.setForeground(Color.red);
                }
            }
            catch (Exception e) {
                this.feedbackLabel.setText("Failed connect to server");
            }
            DasProperties.getInstance().setProperty("username", username);
            if (!pass.equals("sendPropertyPassword")) {
                String cryptPass = Crypt.crypt(pass);
                DasProperties.getInstance().setProperty("password", cryptPass);
            }
            DasProperties.getInstance().writePersistentProperties();
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            Authenticator a = new Authenticator(DasServer.create(new URL("http://www-pw.physics.uiowa.edu/das-test/das2ServerEEW")));
            DasDie.println(a.authenticate());
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
    }
}

