/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.beans;

import java.beans.BeanDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

public abstract class AccessLevelBeanInfo
extends SimpleBeanInfo {
    private Property[] properties;
    private Class beanClass;
    private static AccessLevel accessLevel;
    private static Object lockObject;

    public static AccessLevel getAccessLevel() {
        return accessLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAccessLevel(AccessLevel level) {
        Object object = lockObject;
        synchronized (object) {
            accessLevel = level;
        }
    }

    public static Object getLock() {
        return lockObject;
    }

    protected AccessLevelBeanInfo(Property[] properties, Class beanClass) {
        this.properties = properties;
        this.beanClass = beanClass;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        Object object = lockObject;
        synchronized (object) {
            try {
                int count = 0;
                for (int index = 0; index < this.properties.length; ++index) {
                    if (accessLevel.compareTo(this.properties[index].getLevel()) > 0) continue;
                    ++count;
                }
                PropertyDescriptor[] descriptors = new PropertyDescriptor[count];
                int propertyIndex = 0;
                for (int index = 0; index < this.properties.length; ++index) {
                    if (accessLevel.compareTo(this.properties[index].getLevel()) > 0) continue;
                    descriptors[propertyIndex] = this.properties[index].getPropertyDescriptor(this.beanClass);
                    ++propertyIndex;
                }
                return descriptors;
            }
            catch (IntrospectionException ie) {
                throw new IllegalStateException(ie.getMessage());
            }
        }
    }

    public BeanDescriptor getBeanDescriptor() {
        return new BeanDescriptor(this.beanClass);
    }

    static {
        lockObject = new Object();
        String level = System.getProperty("edu.uiowa.physics.das.beans.AccessLevelBeanInfo.AccessLevel");
        accessLevel = level == null ? AccessLevel.ALL : (level.equals("ALL") ? AccessLevel.ALL : (level.equals("DASML") ? AccessLevel.DASML : (level.equals("END_USER") ? AccessLevel.END_USER : AccessLevel.ALL)));
    }

    protected static class Property {
        private final String name;
        private final AccessLevel level;
        private final String getter;
        private final String setter;
        private final String igetter;
        private final String isetter;
        private final Class editor;
        private final boolean indexed;

        public Property(String name, AccessLevel level, String getter, String setter, Class editor) {
            this.name = name;
            this.level = level;
            this.getter = getter;
            this.setter = setter;
            this.igetter = null;
            this.isetter = null;
            this.editor = editor;
            this.indexed = false;
        }

        public Property(String name, AccessLevel level, String getter, String setter, String igetter, String isetter, Class editor) {
            this.name = name;
            this.level = level;
            this.getter = getter;
            this.setter = setter;
            this.igetter = igetter;
            this.isetter = isetter;
            this.editor = editor;
            this.indexed = true;
        }

        public AccessLevel getLevel() {
            return this.level;
        }

        public PropertyDescriptor getPropertyDescriptor(Class beanClass) throws IntrospectionException {
            PropertyDescriptor pd = this.indexed ? new IndexedPropertyDescriptor(this.name, beanClass, this.getter, this.setter, this.igetter, this.isetter) : new PropertyDescriptor(this.name, beanClass, this.getter, this.setter);
            if (this.editor != null) {
                pd.setPropertyEditorClass(this.editor);
            }
            return pd;
        }
    }

    public static class AccessLevel
    implements Comparable {
        public static final AccessLevel ALL = new AccessLevel("ALL", 0);
        public static final AccessLevel DASML = new AccessLevel("DASML", 1000);
        public static final AccessLevel END_USER = new AccessLevel("END_USER", 0x7FFF0000);
        private String str;
        private int order;

        private AccessLevel(String str, int order) {
            this.str = str;
            this.order = order;
        }

        public int compareTo(Object o) {
            return this.order - ((AccessLevel)o).order;
        }

        public String toString() {
            return this.str;
        }
    }
}

