/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das;

import edu.uiowa.physics.pw.das.DasException;

public class DasPropertyException
extends DasException {
    public static final MessageType NOT_DEFINED = new MessageType("The property <pty-name> is undefined for <obj-name>.");
    public static final MessageType READ_ONLY = new MessageType("The property <pty-name> of <obj-name> is read-only.");
    public static final MessageType TYPE_MISMATCH = new MessageType("Type mismatch: <pty-name> of <obj-name> cannot be set to <value>");
    public static final MessageType NOT_INDEXED = new MessageType("The property <pty-name> of <obj-name> is not an indexed property");
    private String propertyName;
    private String objectName;
    private String value;
    private MessageType type;

    public DasPropertyException(MessageType type, String propertyName, String objectName, String value) {
        this.type = type;
        this.propertyName = propertyName;
        this.objectName = objectName;
        this.value = value;
    }

    public DasPropertyException(MessageType type, String propertyName, String objectName) {
        this(type, propertyName, objectName, null);
    }

    public DasPropertyException(MessageType type) {
        this(type, null, null);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String name) {
        this.objectName = name;
    }

    public MessageType getType() {
        return this.type;
    }

    public void setMessageType(MessageType type) {
        this.type = type;
    }

    public String getMessage() {
        String message = this.type.toString();
        String objStr = this.objectName == null ? "<unknown>" : this.objectName;
        String ptyStr = this.propertyName == null ? "<unknown>" : this.propertyName;
        String valueStr = this.value == null ? "<unknown>" : this.value;
        return message.replaceAll("<obj-name>", objStr).replaceAll("<pty-name>", ptyStr).replaceAll("<value>", valueStr);
    }

    public static final class MessageType {
        private final String message;

        private MessageType(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }
}

