/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.awt;

import edu.uiowa.physics.pw.das.util.awt.GraphicsOutput;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.Document;

public class SvgGraphicsOutput
implements GraphicsOutput {
    private Writer writer;
    private Document document;
    private SVGGraphics2D graphics;
    private int width;
    private int height;

    public Graphics getGraphics() {
        return this.getGraphics2D();
    }

    public Graphics2D getGraphics2D() {
        if (this.graphics != null) {
            return this.graphics;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
            this.graphics = new SVGGraphics2D(this.document);
            this.graphics.setSVGCanvasSize(new Dimension(this.width, this.height));
            return this.graphics;
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    public void finish() throws IOException {
        this.graphics.stream(this.writer, false);
        this.writer.close();
    }

    public void setOutputStream(OutputStream out) {
        try {
            this.writer = new OutputStreamWriter(out, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void start() {
    }
}

