/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public class GrannyTextRenderer {
    public static final int LEFT_ALIGNMENT = 0;
    public static final int CENTER_ALIGNMENT = 1;
    public static final int RIGHT_ALIGNMENT = 2;
    private Rectangle bounds = null;
    private ArrayList lineBounds;
    private String str;
    private String[] tokens;
    private int alignment = 0;

    public Rectangle getBounds() {
        this.maybeInitBounds();
        return new Rectangle(this.bounds);
    }

    private void maybeInitBounds() {
        if (this.bounds == null) {
            this.bounds = new Rectangle((Rectangle)this.lineBounds.get(0));
            for (int i = 1; i < this.lineBounds.size(); ++i) {
                this.bounds.add((Rectangle)this.lineBounds.get(i));
            }
        }
    }

    public double getWidth() {
        this.maybeInitBounds();
        return this.bounds.getWidth();
    }

    public double getLineOneWidth() {
        return this.getLineWidth(1);
    }

    public double getLineWidth(int lineNumber) {
        return ((Rectangle)this.lineBounds.get(lineNumber - 1)).getWidth();
    }

    public double getHeight() {
        this.maybeInitBounds();
        return this.bounds.getHeight();
    }

    public double getAscent() {
        return -1.0 * ((Rectangle)this.lineBounds.get(0)).getY();
    }

    public double getDescent() {
        this.maybeInitBounds();
        return this.bounds.getHeight() + this.bounds.getY();
    }

    public void setString(Component c, String str) {
        this.bounds = null;
        this.lineBounds = new ArrayList();
        this.str = str;
        this.tokens = GrannyTextRenderer.buildTokenArray(str);
        this.draw(null, 0.0f, 0.0f, c, false);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int a) {
        if (a != 0 && a != 1 && a != 2) {
            throw new IllegalArgumentException();
        }
        this.alignment = a;
    }

    public void draw(Graphics ig, float ix, float iy) {
        this.draw(ig, ix, iy, null, true);
    }

    private void draw(Graphics ig, float ix, float iy, Component c, boolean draw) {
        Graphics2D g = null;
        Rectangle bounds = null;
        if (draw) {
            g = (Graphics2D)ig.create();
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHints(hints);
        }
        boolean NONE = false;
        boolean SUB_U = true;
        int SUB_D = 2;
        int SUB_L = 3;
        int EXP = 4;
        int IND = 5;
        int LOWCAPS = 10;
        int SUB_A = 11;
        int SUB_B = 12;
        Font baseFont = draw ? g.getFont() : c.getFont();
        int lineNum = 1;
        class TextPosition {
            public int sub;
            public int ei;
            public float x;
            public float y;

            public TextPosition(int sub, int ei, float x, float y) {
                this.sub = sub;
                this.ei = ei;
                this.x = x;
                this.y = y;
            }

            public TextPosition(TextPosition p) {
                this.copy(p);
            }

            public void copy(TextPosition p) {
                this.sub = p.sub;
                this.ei = p.ei;
                this.x = p.x;
                this.y = p.y;
            }
        }
        TextPosition current = new TextPosition(0, 0, ix, iy);
        if (draw) {
            if (this.alignment == 1) {
                current.x = (float)((double)current.x + (this.getWidth() - this.getLineOneWidth()) / 2.0);
            } else if (this.alignment == 2) {
                current.x = (float)((double)current.x + (this.getWidth() - this.getLineOneWidth()));
            }
        }
        if (!draw) {
            bounds = new Rectangle((int)ix, (int)iy, 0, 0);
        }
        Stack<TextPosition> saveStack = new Stack<TextPosition>();
        block27: for (int i = 0; i < this.tokens.length; ++i) {
            if (this.tokens[i].charAt(0) == '!') {
                switch (this.tokens[i].charAt(1)) {
                    case 'A': 
                    case 'a': {
                        current.sub = 11;
                        current.ei = 0;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        current.sub = 12;
                        current.ei = 0;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        ++lineNum;
                        current.sub = 0;
                        current.ei = 0;
                        current.x = ix;
                        current.y += baseFont.getSize2D();
                        if (draw) {
                            g.setFont(baseFont);
                            if (this.alignment == 1) {
                                current.x = (float)((double)current.x + (this.getWidth() - this.getLineWidth(lineNum)) / 2.0);
                            } else if (this.alignment == 2) {
                                current.x = (float)((double)current.x + (this.getWidth() - this.getLineWidth(lineNum)));
                            }
                        }
                        saveStack.clear();
                        if (draw) continue block27;
                        this.lineBounds.add(bounds);
                        bounds = new Rectangle((int)current.x, (int)current.y, 0, 0);
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        current.sub = 1;
                        current.ei = 0;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        current.sub = 2;
                        current.ei = 0;
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        current.sub = 3;
                        current.ei = 0;
                        break;
                    }
                    case 'K': 
                    case 'k': {
                        current.ei = 10;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        current.ei = 4;
                        break;
                    }
                    case 'I': 
                    case 'i': {
                        current.ei = 5;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        saveStack.push(new TextPosition(current));
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        if (saveStack.peek() == null) {
                            return;
                        }
                        current.copy((TextPosition)saveStack.pop());
                        break;
                    }
                    case 'N': 
                    case 'n': {
                        current.sub = 0;
                        current.ei = 0;
                        break;
                    }
                    case '!': {
                        break;
                    }
                }
                continue;
            }
            Font font = baseFont;
            float size = baseFont.getSize2D();
            float y = current.y;
            switch (current.sub) {
                case 1: {
                    font = baseFont.deriveFont(size * 0.62f);
                    y -= 0.38f * size;
                    size *= 0.62f;
                    break;
                }
                case 2: {
                    font = baseFont.deriveFont(size * 0.62f);
                    y += 0.31f * size;
                    size *= 0.62f;
                    break;
                }
                case 3: {
                    font = baseFont.deriveFont(size * 0.62f);
                    y += 0.62f * size;
                    size *= 0.62f;
                    break;
                }
                case 11: {
                    y = current.y - size / 2.0f;
                    break;
                }
                case 12: {
                    y = current.y + size / 2.0f;
                    break;
                }
            }
            switch (current.ei) {
                case 4: {
                    font = font.deriveFont(size * 0.44f);
                    y -= 0.56f * size;
                    break;
                }
                case 5: {
                    font = font.deriveFont(size * 0.44f);
                    y += 0.22f * size;
                    break;
                }
                case 10: {
                    font = font.deriveFont(size * 0.8f);
                    break;
                }
            }
            if (draw) {
                g.setFont(font);
                g.drawString(this.tokens[i], current.x, y);
                current.x += (float)g.getFontMetrics(font).stringWidth(this.tokens[i]);
                continue;
            }
            FontMetrics fm = c.getFontMetrics(font);
            bounds.add(current.x, y + (float)fm.getDescent());
            bounds.add(current.x + (float)fm.stringWidth(this.tokens[i]), y - (float)fm.getAscent());
            current.x += (float)c.getFontMetrics(font).stringWidth(this.tokens[i]);
        }
        if (!draw) {
            this.lineBounds.add(bounds);
        }
    }

    private static String[] buildTokenArray(String str) {
        Vector<String> vector = new Vector<String>();
        int end = 0;
        boolean index = false;
        while (end < str.length()) {
            int begin = end;
            if (str.charAt(begin) == '!') {
                end = begin + 2;
            } else {
                end = str.indexOf(33, begin);
                if (end == -1) {
                    end = str.length();
                }
            }
            vector.add(str.substring(begin, end));
        }
        String[] list = new String[vector.size()];
        vector.copyInto(list);
        return list;
    }

    public String toString() {
        this.maybeInitBounds();
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append(": ").append(this.str).append(", ");
        buffer.append(this.bounds).append(", ").append(this.lineBounds).append(", ");
        return buffer.toString();
    }

    public void drawBounds(Graphics g, int ix, int iy) {
        g.setColor(Color.BLUE);
        g.drawRect(this.bounds.x + ix, this.bounds.y + iy, this.bounds.width, this.bounds.height);
        g.setColor(Color.GREEN);
        Iterator i = this.lineBounds.iterator();
        while (i.hasNext()) {
            Rectangle rc = (Rectangle)i.next();
            g.drawRect(rc.x + ix, rc.y + iy, rc.width, rc.height);
        }
    }
}

