/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.DasDie;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class DasDate
implements Serializable,
Comparable,
Cloneable {
    protected int jd;
    protected double seconds;
    private static final String DELIMITERS = " \t/-:,_;";
    private static final String PDSDELIMITERS = " \t/-T:,_;";
    public static final int DATE = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DAY = 3;
    public static final int HOUR = 4;
    public static final int MINUTE = 5;
    public static final int SECOND = 6;
    public static final int WEEK = 97;
    public static final int QUARTER = 98;
    private static final String[] months = new String[]{"january", "febuary", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};
    private static final String[] mons = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final int[][] day_offset = new int[][]{{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365}, {0, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366}};
    private static final int[][] days_in_month = new int[][]{{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 0}, {0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 0}};

    private DasDate() {
    }

    public DasDate(double[] d) {
        int year = (int)d[1];
        int month = (int)d[2];
        int day = (int)d[3];
        this.jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029;
        int hour = (int)d[4];
        int minute = (int)d[5];
        this.seconds = d[6] + (double)((float)hour * 3600.0f) + (double)((float)minute * 60.0f);
    }

    public DasDate(String s) throws IllegalArgumentException {
        Number[] d = DasDate.parseTime(s);
        if (d == null) {
            throw new IllegalArgumentException("Could not parse date string: \"" + s + "\"");
        }
        int year = d[1].intValue();
        int month = d[2].intValue();
        int day = d[3].intValue();
        int hour = d[4].intValue();
        this.jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029;
        int minute = d[5].intValue();
        this.seconds = d[6].floatValue() + (float)hour * 3600.0f + (float)minute * 60.0f;
    }

    public static DasDate valueOf(Date javaDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DasDate result = new DasDate(df.format(javaDate));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Number[] parseTime(String s) {
        int leap;
        int i;
        int len;
        int n;
        int end_of_date;
        String[] tok = new String[10];
        boolean[] want = new boolean[7];
        Arrays.fill(want, false);
        Number[] result = new Number[7];
        String delimiters = DELIMITERS;
        int c = s.indexOf(90);
        if (c != -1) {
            s = s.substring(0, c);
        }
        if ((end_of_date = s.indexOf(84)) != -1) {
            c = end_of_date - 1;
            if (Character.isDigit(s.charAt(c))) {
                delimiters = PDSDELIMITERS;
            } else {
                end_of_date = -1;
            }
        }
        if (end_of_date == -1) {
            n = 0;
            len = s.length();
            for (i = 0; i < len; ++i) {
                c = delimiters.substring(2).indexOf(s.charAt(i));
                if (c != -1) {
                    ++n;
                }
                if (n != 3) continue;
                end_of_date = i;
                break;
            }
        }
        GregorianCalendar curdate = new GregorianCalendar();
        curdate.setTime(new Date());
        int year = curdate.get(1);
        int month = 0;
        int day_month = 0;
        int day_year = 0;
        int hour = 0;
        int minute = 0;
        double second = 0.0;
        StringTokenizer st = new StringTokenizer(s, delimiters);
        if (!st.hasMoreTokens()) {
            return null;
        }
        for (n = 0; n < 10 && st.hasMoreTokens(); ++n) {
            tok[n] = st.nextToken();
        }
        want[3] = true;
        want[2] = true;
        want[1] = true;
        want[0] = true;
        int hold = 0;
        int tokIndex = -1;
        for (i = 0; i < n; ++i) {
            double value;
            tokIndex = s.indexOf(tok[i], tokIndex + 1);
            if (end_of_date != -1 && want[0] && tokIndex > end_of_date) {
                want[0] = false;
                want[6] = true;
                want[5] = true;
                want[4] = true;
            }
            len = tok[i].length();
            try {
                value = Double.parseDouble(tok[i]);
            }
            catch (NumberFormatException e) {
                if (len < 3 || !want[0]) {
                    return null;
                }
                for (int j = 0; j < 12; ++j) {
                    if (!tok[i].equalsIgnoreCase(months[j]) && !tok[i].equalsIgnoreCase(mons[j])) continue;
                    month = j + 1;
                    want[2] = false;
                    if (hold <= 0) break;
                    if (day_month > 0) {
                        return null;
                    }
                    day_month = hold;
                    hold = 0;
                    want[3] = false;
                    break;
                }
                if (!want[2]) continue;
                return null;
            }
            if (Math.IEEEremainder(value, 1.0) != 0.0) {
                if (!want[6]) return null;
                second = value;
                break;
            }
            int number = (int)value;
            if (number < 0) {
                return null;
            }
            if (want[0]) {
                if (number == 0) {
                    return null;
                }
                if (number > 31) {
                    if (want[1]) {
                        year = number;
                        if (year < 1000) {
                            year += 1900;
                        }
                        want[1] = false;
                    } else {
                        if (!want[2]) return null;
                        want[2] = false;
                        month = 0;
                        day_year = number;
                        want[3] = false;
                    }
                } else if (number > 12) {
                    if (!want[3]) return null;
                    if (hold > 0) {
                        month = hold;
                        want[2] = false;
                    }
                    if (len == 3) {
                        if (month > 0) {
                            return null;
                        }
                        day_year = number;
                        day_month = 0;
                        want[2] = false;
                    } else {
                        day_month = number;
                    }
                    want[3] = false;
                } else if (!want[2]) {
                    if (month > 0) {
                        day_month = number;
                        day_year = 0;
                    } else {
                        day_year = number;
                        day_month = 0;
                    }
                    want[3] = false;
                } else if (!want[3]) {
                    if (day_year > 0) {
                        return null;
                    }
                    month = number;
                    want[2] = false;
                } else if (!want[1]) {
                    if (len == 3) {
                        if (month > 0) {
                            return null;
                        }
                        day_year = number;
                        day_month = 0;
                        want[3] = false;
                    } else {
                        if (day_year > 0) {
                            return null;
                        }
                        month = number;
                        if (hold > 0) {
                            day_month = hold;
                            want[3] = false;
                        }
                    }
                    want[2] = false;
                } else if (hold > 0) {
                    month = hold;
                    hold = 0;
                    want[2] = false;
                    day_month = number;
                    want[3] = false;
                } else {
                    hold = number;
                }
                if (want[1] || want[2] || want[3]) continue;
                want[0] = false;
                want[6] = true;
                want[5] = true;
                want[4] = true;
                continue;
            }
            if (want[4]) {
                if (len == 4) {
                    hold = number / 100;
                    if (hold > 23) {
                        return null;
                    }
                    hour = hold;
                    hold = number % 100;
                    if (hold > 59) {
                        return null;
                    }
                    minute = hold;
                    want[5] = false;
                } else {
                    if (number > 23) {
                        return null;
                    }
                    hour = number;
                }
                want[4] = false;
                continue;
            }
            if (want[5]) {
                if (number > 59) {
                    return null;
                }
                minute = number;
                want[5] = false;
                continue;
            }
            if (!want[6]) return null;
            if (number > 61) {
                return null;
            }
            second = number;
            want[6] = false;
        }
        if (month > 12) {
            return null;
        }
        if (month > 0 && day_month <= 0) {
            day_month = 1;
        }
        int n2 = (year & 3) > 0 ? 0 : (year % 100 > 0 ? 1 : (leap = year % 400 > 0 ? 0 : 1));
        if (month > 0 && day_month > 0 && day_year == 0) {
            if (day_month > days_in_month[leap][month]) {
                return null;
            }
            day_year = day_offset[leap][month] + day_month;
        } else {
            if (day_year <= 0 || month != 0 || day_month != 0) return null;
            if (day_year > 365 + leap) {
                return null;
            }
            for (i = 2; i < 14 && day_year > day_offset[leap][i]; ++i) {
            }
            month = --i;
            day_month = day_year - day_offset[leap][i];
        }
        result[1] = new Integer(year);
        result[2] = new Integer(month);
        result[3] = new Integer(day_month);
        result[0] = new Integer(day_year);
        result[4] = new Integer(hour);
        result[5] = new Integer(minute);
        result[6] = new Double(second);
        return result;
    }

    public String toString() {
        int jalpha = (int)(((double)(this.jd - 1867216) - 0.25) / 36524.25);
        int j1 = this.jd + 1 + jalpha - jalpha / 4;
        int j2 = j1 + 1524;
        int j3 = 6680 + (int)(((double)(j2 - 2439870) - 122.1) / 365.25);
        int j4 = 365 * j3 + j3 / 4;
        int j5 = (int)((double)(j2 - j4) / 30.6001);
        int day = j2 - j4 - (int)(30.6001 * (double)j5);
        int month = j5 - 1;
        month = (month - 1) % 12 + 1;
        int year = j3 - 4715;
        int hour = (int)(this.seconds / 3600.0);
        int minute = (int)((this.seconds - (double)hour * 3600.0) / 60.0);
        double justSeconds = this.seconds - (double)hour * 3600.0 - (double)minute * 60.0;
        return (year -= (year -= month > 2 ? 1 : 0) <= 0 ? 1 : 0) + "-" + month + "-" + day + "T" + this.getTimeAsString();
    }

    public DasDate previous(int step) {
        double[] d7 = this.toArray();
        if (step <= 2) {
            DasDie.die("operation not defined yet...see DasDate.borrow");
        }
        int idx = step;
        if (d7[step + 1] == 0.0) {
            int n = step;
            d7[n] = d7[n] - 1.0;
        }
        for (int i = step + 1; i < d7.length; ++i) {
            d7[i] = 0.0;
        }
        d7 = DasDate.borrow(d7);
        return new DasDate(d7);
    }

    public DasDate next(int step) {
        double[] array = this.toArray();
        switch (step) {
            case 3: {
                array[3] = array[3] + 1.0;
            }
            case 2: {
                array[2] = array[2] + 1.0;
                array[3] = 1.0;
                break;
            }
            case 98: {
                array[2] = ((int)(array[2] - 1.0) + 3) / 3 * 3 + 1;
                array[3] = 1.0;
                break;
            }
            case 1: {
                array[1] = array[1] + 1.0;
                array[2] = 1.0;
                array[3] = 1.0;
                break;
            }
        }
        array[4] = 0.0;
        array[5] = 0.0;
        array[6] = 0.0;
        if (array[2] > 12.0) {
            array[1] = array[1] + 1.0;
            array[2] = array[2] - 12.0;
        }
        DasDate result = new DasDate(array);
        return result;
    }

    public DasDate add(double seconds) {
        return DasDate.add(this, seconds);
    }

    public static DasDate add(DasDate d, double seconds) {
        DasDate result = new DasDate();
        result.seconds = d.seconds + (double)((float)seconds);
        int days = (int)Math.floor(result.seconds / 86400.0);
        result.jd = d.jd + days;
        result.seconds -= (double)(days * 86400);
        return result;
    }

    public double subtract(DasDate d) {
        return DasDate.subtract(this, d);
    }

    public static double subtract(DasDate d1, DasDate d2) {
        return (double)(d1.jd - d2.jd) * 86400.0 + (d1.seconds - d2.seconds);
    }

    public int compareTo(Object o) {
        DasDate d = (DasDate)o;
        if (this.jd < d.jd) {
            return -1;
        }
        if (this.jd > d.jd) {
            return 1;
        }
        if (this.seconds < d.seconds) {
            return -1;
        }
        if (this.seconds > d.seconds) {
            return 1;
        }
        return 0;
    }

    public boolean lt(Object o) {
        return this.compareTo(o) == -1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DasDate)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        DasDate d = (DasDate)o;
        return this.jd == d.jd && this.seconds == d.seconds;
    }

    public static double timeLengthFromString(String stime) {
        double result = 0.0;
        if (stime.length() < 2) {
            return result;
        }
        if (stime.substring(stime.length() - 2).equals("ms")) {
            stime = stime.substring(0, stime.length() - 2) + "M";
        }
        StringTokenizer tok = new StringTokenizer(stime, "dhmsM", true);
        while (tok.hasMoreTokens()) {
            String v = tok.nextToken();
            String u = tok.nextToken();
            if (u.equals("d")) {
                result += (double)(86400 * Integer.parseInt(v));
                continue;
            }
            if (u.equals("h")) {
                result += (double)(3600 * Integer.parseInt(v));
                continue;
            }
            if (u.equals("m")) {
                result += (double)(60 * Integer.parseInt(v));
                continue;
            }
            if (u.equals("s")) {
                result += (double)Integer.parseInt(v);
                continue;
            }
            if (!u.equals("M")) continue;
            result += 0.001 * (double)Integer.parseInt(v);
        }
        return result;
    }

    public static String timeLengthToString(double seconds) {
        int days = (int)(seconds / 86400.0);
        int hours = (int)((seconds -= (double)(days * 86400)) / 3600.0);
        int minutes = (int)((seconds -= (double)(hours * 3600)) / 60.0);
        int iseconds = (int)(seconds -= (double)(minutes * 60));
        int millis = (int)Math.round((seconds -= (double)iseconds) * 1000.0);
        int[] d5 = new int[]{days, hours, minutes, iseconds, millis};
        String[] s5 = new String[]{"d", "h", "m", "s", "ms"};
        int istart = -1;
        int iend = -1;
        for (int i = 0; i < 5; ++i) {
            if (d5[i] <= 0) continue;
            if (istart == -1) {
                istart = i;
                continue;
            }
            iend = i;
        }
        if (istart == -1) {
            istart = 4;
            iend = 4;
        }
        if (iend == -1) {
            iend = istart;
        }
        String result = "";
        for (int i = istart; i <= iend; ++i) {
            result = result + d5[i] + s5[i];
        }
        return result;
    }

    public String getTimeAsString() {
        return this.getTimeAsString(-991);
    }

    public String getTimeAsString(int cntext) {
        String result;
        int iseconds = (int)(this.seconds + 0.5);
        int hour = iseconds / 3600;
        String shour = (double)hour < 10.0 ? "0" + hour : "" + hour;
        int minute = (iseconds - hour * 3600) / 60;
        String sminute = (double)minute < 10.0 ? "0" + minute : "" + minute;
        int second = iseconds % 60;
        String ssecond = (double)second < 10.0 ? "0" + second : "" + second;
        int jalpha = (int)(((double)(this.jd - 1867216) - 0.25) / 36524.25);
        int j1 = this.jd + 1 + jalpha - jalpha / 4;
        int j2 = j1 + 1524;
        int j3 = 6680 + (int)(((double)(j2 - 2439870) - 122.1) / 365.25);
        int j4 = 365 * j3 + j3 / 4;
        int j5 = (int)((double)(j2 - j4) / 30.6001);
        int day = j2 - j4 - (int)(30.6001 * (double)j5);
        int month = j5 - 1;
        month = (month - 1) % 12 + 1;
        int year = j3 - 4715;
        String sdate = (year -= (year -= month > 2 ? 1 : 0) <= 0 ? 1 : 0) + "-" + month + "-" + day;
        if (cntext == -990) {
            ssecond = Integer.toString((int)this.seconds % 60);
            long milliSeconds = Math.round(this.seconds % 1.0 * 1000.0);
            result = shour + ":" + sminute + ":" + ssecond + "." + (milliSeconds < 100L ? "0" + (milliSeconds < 10L ? "0" : "") : "") + milliSeconds;
        } else {
            result = cntext == -991 || cntext == -992 ? shour + ":" + sminute + ":" + ssecond : (cntext == -993 ? shour + ":" + sminute : (cntext == -995 ? sdate : (hour == 0 ? sdate : sdate + '.' + iseconds * 10 / 86400)));
        }
        return result;
    }

    public double[] toArray() {
        int jalpha = (int)(((double)(this.jd - 1867216) - 0.25) / 36524.25);
        int j1 = this.jd + 1 + jalpha - jalpha / 4;
        int j2 = j1 + 1524;
        int j3 = 6680 + (int)(((double)(j2 - 2439870) - 122.1) / 365.25);
        int j4 = 365 * j3 + j3 / 4;
        int j5 = (int)((double)(j2 - j4) / 30.6001);
        int day = j2 - j4 - (int)(30.6001 * (double)j5);
        int month = j5 - 1;
        month = (month - 1) % 12 + 1;
        int year = j3 - 4715;
        int hour = (int)(this.seconds / 3600.0);
        int minute = (int)((this.seconds - (double)hour * 3600.0) / 60.0);
        double justSeconds = this.seconds - (double)hour * 3600.0 - (double)minute * 60.0;
        double[] result = new double[7];
        result[1] = year -= (year -= month > 2 ? 1 : 0) <= 0 ? 1 : 0;
        result[2] = month;
        result[3] = day;
        result[4] = hour;
        result[5] = minute;
        result[6] = justSeconds;
        return result;
    }

    public int getJulianDay() {
        return this.jd;
    }

    public void setJulianDay(int JulianDay) {
        this.jd = JulianDay;
    }

    public double getSecondsSinceMidnight() {
        return this.seconds;
    }

    public void setSecondsSinceMidnight(double secondsSinceMidnight) {
        this.seconds = secondsSinceMidnight;
    }

    public double[] toArray(int context2) {
        double[] d7 = this.toArray();
        switch (context2) {
            case -990: {
                d7[6] = (double)Math.round(d7[6] * 1000.0) / 1000.0;
                break;
            }
            case -991: {
                d7[6] = Math.round(d7[6]);
                break;
            }
            case -992: {
                d7[5] = d7[5] + (double)Math.round(d7[6] / 60.0);
                d7[6] = 0.0;
                break;
            }
            case -993: {
                d7[4] = d7[4] + (double)Math.round(d7[5] / 60.0 + d7[6] / 3600.0);
                d7[5] = 0.0;
                d7[6] = 0.0;
                break;
            }
            case -994: {
                d7[3] = d7[3] + (double)Math.round(d7[4] / 24.0 + d7[5] / 1440.0 + d7[6] / 86400.0);
                d7[5] = 0.0;
                d7[6] = 0.0;
                d7[4] = 0.0;
            }
        }
        d7 = DasDate.carry(d7);
        return d7;
    }

    public static double[] carry(double[] d7) {
        int daysThisMonth;
        double[] result = new double[d7.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = d7[i];
        }
        if (result[6] >= 60.0) {
            result[6] = result[6] - 60.0;
            result[5] = result[5] + 1.0;
        }
        if (result[5] >= 60.0) {
            result[5] = result[5] - 60.0;
            result[4] = result[4] + 1.0;
        }
        if (result[4] >= 24.0) {
            result[4] = result[4] - 24.0;
            result[3] = result[3] + 1.0;
        }
        if (result[3] > (double)(daysThisMonth = days_in_month[(int)result[1] % 4 == 0 ? 1 : 0][(int)result[2]])) {
            result[3] = result[3] - (double)daysThisMonth;
            result[2] = result[2] + 1.0;
        }
        if (result[2] > 12.0) {
            result[2] = result[2] - 12.0;
            result[1] = result[1] + 1.0;
        }
        return result;
    }

    public static double[] borrow(double[] d7) {
        double[] result = new double[d7.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = d7[i];
        }
        if (result[6] < 0.0) {
            result[6] = result[6] + 60.0;
            result[5] = result[5] - 1.0;
        }
        if (result[5] < 0.0) {
            result[5] = result[5] + 60.0;
            result[4] = result[4] - 1.0;
        }
        if (result[4] < 0.0) {
            result[4] = result[4] + 24.0;
            result[3] = result[3] - 1.0;
        }
        if (result[3] < 0.0 || result[2] < 1.0) {
            DasDie.die("Borrow operation not defined for months<1 or days<0");
        }
        if (result[3] == 0.0) {
            int daysLastMonth = result[2] > 1.0 ? days_in_month[(int)result[1] % 4 == 0 ? 1 : 0][(int)result[2] - 1] : 31;
            result[3] = result[3] + (double)daysLastMonth;
            result[2] = result[2] - 1.0;
        }
        if (result[2] == 0.0) {
            result[2] = result[2] + 12.0;
            result[1] = result[1] - 1.0;
        }
        return result;
    }

    public String getTimeAsHersheyString(int cntext) {
        String result;
        double[] d7 = this.toArray(cntext);
        DecimalFormat nf = new DecimalFormat();
        nf.applyPattern("00");
        int day = (int)d7[3];
        String month = mons[(int)d7[2] - 1];
        int year = (int)d7[1];
        String sdate = "" + day + " " + month + " " + year;
        int hour = (int)d7[4];
        int minute = (int)d7[5];
        double second = d7[6];
        String shour = nf.format(hour);
        String sminute = nf.format(minute);
        if (cntext == -990) {
            DecimalFormat nf3 = new DecimalFormat();
            nf3.applyPattern("00.000");
            result = shour + ":" + sminute + ":" + "!K" + nf3.format(second) + "!N";
        } else {
            result = cntext == -991 ? shour + ":" + sminute + ":" + nf.format(second) : (cntext == -992 || cntext == -993 ? (hour == 0 && minute == 0 && second == 0.0 ? shour + ":" + sminute + "!C" + sdate : shour + ":" + sminute) : (cntext == -994 ? sdate : sdate));
        }
        return result;
    }

    public DasDate subtract(double seconds) {
        return DasDate.add(this, -1.0 * seconds);
    }

    public static DasDate create(Datum datum) {
        DasDate result = new DasDate();
        Datum datumT2000 = datum.convertTo(Units.t2000);
        result.jd = 2451545 + (int)Math.floor(datumT2000.doubleValue(datumT2000.getUnits()) / 86400.0);
        result.seconds = datumT2000.doubleValue(datumT2000.getUnits()) - 86400.0 * Math.floor(datumT2000.doubleValue(datumT2000.getUnits()) / 86400.0);
        return result;
    }

    public static class context {
        public static final int MILLISECONDS = -990;
        public static final int SECONDS = -991;
        public static final int MINUTES = -992;
        public static final int HOURS = -993;
        public static final int DAYS = -994;
        public static final int DATE = -995;

        public static int getContextFromSeconds(double seconds) {
            int context2 = seconds < 1.0 ? -990 : (seconds < 60.0 ? -991 : (seconds < 3600.0 ? -992 : (seconds < 86400.0 ? -993 : (seconds <= 864000.0 ? -994 : -995))));
            return context2;
        }
    }
}

