/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.system;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.util.LinkedList;
import java.util.WeakHashMap;

public final class RequestProcessor {
    private static final BlockingRequestQueue queue = new BlockingRequestQueue();
    private static final WeakHashMap runnableQueueMap = new WeakHashMap();
    private static final Runner runner = new Runner();
    private static int maxThreadCount = 5;
    private static int threadCount = 0;
    private static final Object THREAD_COUNT_LOCK = new Object();
    private static int threadOrdinal = 0;

    private RequestProcessor() {
    }

    private static void newThread() {
        String name = "RequestProcessor[" + threadOrdinal++ + "]";
        new Thread((Runnable)runner, name).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeLater(Runnable run) {
        DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG).info("invokeLater " + run);
        Object object = THREAD_COUNT_LOCK;
        synchronized (object) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        queue.add(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeLater(Runnable run, Object lock) {
        DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG).info("invokeLater " + run + " " + lock);
        Object object = THREAD_COUNT_LOCK;
        synchronized (object) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        object = runnableQueueMap;
        synchronized (object) {
            RunnableQueue rq = (RunnableQueue)runnableQueueMap.get(lock);
            if (rq == null) {
                rq = new RunnableQueue();
                runnableQueueMap.put(lock, rq);
            }
            rq.add(run, false);
            queue.add(rq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAfter(Runnable run, Object lock) {
        DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG).info("invokeAfter " + run + " " + lock);
        Object object = THREAD_COUNT_LOCK;
        synchronized (object) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        object = runnableQueueMap;
        synchronized (object) {
            RunnableQueue rq = (RunnableQueue)runnableQueueMap.get(lock);
            if (rq == null) {
                rq = new RunnableQueue();
                runnableQueueMap.put(lock, rq);
            }
            rq.add(run, true);
            queue.add(rq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitFor(Object lock) throws InterruptedException {
        WaitTask wt;
        WaitTask waitTask = wt = new WaitTask();
        synchronized (waitTask) {
            RequestProcessor.invokeLater(wt, lock);
            wt.wait();
            return;
        }
    }

    private static class BlockingRequestQueue {
        private LinkedList list = new LinkedList();

        BlockingRequestQueue() {
        }

        synchronized void add(Runnable r) {
            this.list.add(r);
            this.notify();
        }

        synchronized Runnable remove() {
            while (this.list.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return (Runnable)this.list.removeFirst();
        }
    }

    private static class RequestEntry {
        Runnable run;
        boolean async;

        private RequestEntry() {
        }
    }

    private static class RunnableQueue
    implements Runnable {
        private LinkedList list = new LinkedList();
        private int readCount = 0;
        private Object writer;

        private RunnableQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RunnableQueue runnableQueue;
            Runnable run = null;
            RequestEntry entry = null;
            while (run == null) {
                runnableQueue = this;
                synchronized (runnableQueue) {
                    entry = (RequestEntry)this.list.removeFirst();
                    if (entry.async && this.readCount == 0 && this.writer == null) {
                        this.writer = entry;
                        run = entry.run;
                    } else if (!entry.async && this.writer == null) {
                        ++this.readCount;
                        run = entry.run;
                    } else {
                        this.list.addFirst(entry);
                    }
                }
            }
            run.run();
            runnableQueue = this;
            synchronized (runnableQueue) {
                if (entry.async) {
                    this.writer = null;
                } else {
                    --this.readCount;
                }
                this.notifyAll();
            }
        }

        synchronized void add(Runnable run, boolean async) {
            RequestEntry entry = new RequestEntry();
            entry.run = run;
            entry.async = async;
            this.list.add(entry);
        }
    }

    private static class WaitTask
    implements Runnable {
        private WaitTask() {
        }

        public synchronized void run() {
            this.notifyAll();
        }
    }

    private static class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object = THREAD_COUNT_LOCK;
            synchronized (object) {
                threadCount++;
            }
            try {
                while (true) {
                    try {
                        while (true) {
                            Runnable run = queue.remove();
                            DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG).fine("running " + run);
                            if (run != null) {
                                run.run();
                                DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG).fine("completed " + run);
                            }
                            Object object2 = THREAD_COUNT_LOCK;
                            synchronized (object2) {
                                if (threadCount > maxThreadCount) {
                                    return;
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG).info("uncaught exception " + t);
                        DasExceptionHandler.handleUncaught(t);
                        Thread.interrupted();
                        continue;
                    }
                    break;
                }
            }
            finally {
                object = THREAD_COUNT_LOCK;
                synchronized (object) {
                    threadCount--;
                }
            }
        }
    }
}

