/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.DataTransferType;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import java.nio.ByteBuffer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StreamXDescriptor
implements SkeletonDescriptor,
Cloneable {
    private Datum base;
    private Units baseUnits = Units.us2000;
    private Units units = Units.seconds;
    private DataTransferType transferType = DataTransferType.SUN_REAL4;

    public StreamXDescriptor() {
    }

    public StreamXDescriptor(Element element) {
        if (element.getTagName().equals("x")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) {
        String typeStr = element.getAttribute("type");
        DataTransferType type = DataTransferType.getByName(typeStr);
        if (type == null) {
            throw new RuntimeException("Illegal transfer type: " + typeStr);
        }
        this.transferType = type;
        String unitsString = element.getAttribute("units");
        this.units = Units.getByName(unitsString);
        String baseString = element.getAttribute("base");
        if (baseString != null && !baseString.equals("") && this.baseUnits instanceof TimeLocationUnits) {
            this.base = TimeUtil.createValid(baseString);
        }
    }

    private void processLegacyElement(Element element) {
        String typeStr = element.getAttribute("type");
        DataTransferType type = DataTransferType.getByName(typeStr);
        if (type == null) {
            throw new RuntimeException("Illegal transfer type: " + typeStr);
        }
        this.transferType = type;
    }

    public Datum getBase() {
        return this.base;
    }

    public void setBase(Datum base) {
        this.base = base;
    }

    public int getSizeBytes() {
        return this.transferType.getSizeBytes();
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public void setDataTransferType(DataTransferType transferType) {
        this.transferType = transferType;
    }

    public DataTransferType getDataTransferType() {
        return this.transferType;
    }

    public Datum readDatum(ByteBuffer input) {
        return Datum.create(this.transferType.read(input), this.units);
    }

    public DatumVector read(ByteBuffer input) {
        return DatumVector.newDatumVector(new double[]{this.transferType.read(input)}, this.units);
    }

    public void writeDatum(Datum datum, ByteBuffer output) {
        this.transferType.write(datum.doubleValue(this.units), output);
    }

    public void write(DatumVector input, ByteBuffer output) {
        this.transferType.write(input.doubleValue(0, this.units), output);
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("x");
        if (this.base != null) {
            element.setAttribute("base", this.base.toString());
        }
        element.setAttribute("units", this.units.toString());
        element.setAttribute("type", this.transferType.toString());
        return element;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }
}

