/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.stream.DasStreamFormatException;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamXDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.IDLParser;
import edu.uiowa.physics.pw.das.util.StreamTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StreamDescriptor
implements SkeletonDescriptor,
Cloneable {
    private Map properties = new HashMap();
    private StreamXDescriptor xDescriptor;
    private ArrayList yDescriptors = new ArrayList();
    private String compression;

    public StreamDescriptor(Element element) throws StreamException {
        if (element.getTagName().equals("stream")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) throws StreamException {
        this.compression = element.getAttribute("compression");
        NodeList list = element.getElementsByTagName("properties");
        if (list.getLength() != 0) {
            Element propertiesElement = (Element)list.item(0);
            Map m = StreamTool.processPropertiesElement(propertiesElement);
            this.properties.putAll(m);
        }
    }

    private void processLegacyElement(Element element) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            SkeletonDescriptor d;
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String name = child.getTagName();
            if (name.equals("X")) {
                this.xDescriptor = new StreamXDescriptor(child);
                continue;
            }
            if (name.equals("YScan")) {
                d = new StreamYScanDescriptor(child);
                this.yDescriptors.add(d);
                continue;
            }
            if (!name.equals("MultiY")) continue;
            d = new StreamMultiYDescriptor(child);
            this.yDescriptors.add(d);
        }
    }

    public StreamDescriptor() {
    }

    public StreamXDescriptor getXDescriptor() {
        return this.xDescriptor;
    }

    public void setXDescriptor(StreamXDescriptor x) {
        this.xDescriptor = x;
    }

    public void addYScan(StreamYScanDescriptor y) {
        this.yDescriptors.add(y);
    }

    public void addYMulti(StreamMultiYDescriptor y) {
        this.yDescriptors.add(y);
    }

    public List getYDescriptors() {
        return Collections.unmodifiableList(this.yDescriptors);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public static Document parseHeader(Reader header) throws DasIOException, DasStreamFormatException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(header);
            Document document = builder.parse(source);
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        catch (SAXException ex) {
            throw new DasIOException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new DasIOException(ex.getMessage());
        }
    }

    public int getSizeBytes() {
        return -1;
    }

    public DatumVector read(ByteBuffer input) {
        return null;
    }

    public void write(DatumVector input, ByteBuffer output) {
    }

    public static StreamDescriptor createLegacyDescriptor(BufferedReader in) throws IOException {
        IDLParser parser = new IDLParser();
        int lineNumber = 1;
        Pattern labelPattern = Pattern.compile("\\s*label\\((\\d+)\\)\\s*");
        StreamDescriptor result = new StreamDescriptor();
        result.properties.put("legacy", "true");
        String line = in.readLine();
        while (line != null) {
            int index = line.trim().indexOf(59);
            if (index == 0) {
                ++lineNumber;
            } else {
                if (index != -1) {
                    line = line.substring(0, index);
                }
                index = line.indexOf(61);
                String key = line.substring(0, index).trim();
                String value = line.substring(index + 1).trim();
                if (key.equals("description")) {
                    String description = value.substring(1, value.length() - 1);
                    result.properties.put(key, description);
                } else if (key.equals("groupAccess")) {
                    result.properties.put(key, value.substring(1, value.length() - 1));
                } else if (key.equals("form")) {
                    result.properties.put(key, value);
                } else if (key.equals("reader")) {
                    String reader = value.substring(1, value.length() - 1);
                    result.properties.put(key, reader);
                } else if (key.equals("x_parameter")) {
                    String x_parameter = value.substring(1, value.length() - 1);
                    result.properties.put(key, x_parameter);
                } else if (key.equals("x_unit")) {
                    String x_unit = value.substring(1, value.length() - 1);
                    result.properties.put(key, x_unit);
                } else if (key.equals("y_parameter")) {
                    String y_parameter = value.substring(1, value.length() - 1);
                    result.properties.put(key, y_parameter);
                } else if (key.equals("y_unit")) {
                    String y_unit = value.substring(1, value.length() - 1);
                    result.properties.put(key, y_unit);
                } else if (key.equals("z_parameter")) {
                    String z_parameter = value.substring(1, value.length() - 1);
                    result.properties.put(key, z_parameter);
                } else if (key.equals("z_unit")) {
                    String z_unit = value.substring(1, value.length() - 1);
                    result.properties.put(key, z_unit);
                } else if (key.equals("x_sample_width")) {
                    double x_sample_width = parser.parseIDLScalar(value);
                    if (x_sample_width == Double.NaN) {
                        throw new IOException("Could not parse \"" + value + "\" at line " + lineNumber);
                    }
                    result.properties.put(key, new Double(x_sample_width));
                } else if (key.equals("y_fill")) {
                    double y_fill = parser.parseIDLScalar(value);
                    if (y_fill == Double.NaN) {
                        throw new IOException("Could not parse \"" + value + "\" at line " + lineNumber);
                    }
                    result.properties.put(key, new Double(y_fill));
                } else if (key.equals("z_fill")) {
                    double z_fill = (float)parser.parseIDLScalar(value);
                    if (z_fill == Double.NaN) {
                        throw new IOException("Could not parse \"" + value + "\" at line " + lineNumber);
                    }
                    result.properties.put(key, new Float(z_fill));
                } else if (key.equals("y_coordinate")) {
                    double[] array = parser.parseIDLArray(value);
                    if (array == null) {
                        throw new IOException("Could not parse \"" + value + "\" at line " + lineNumber);
                    }
                    result.properties.put(key, array);
                } else if (key.equals("ny")) {
                    int ny;
                    try {
                        ny = Integer.parseInt(value);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IOException("Could not parse \"" + value + "\" at line " + lineNumber);
                    }
                    result.properties.put(key, new Integer(ny));
                } else if (key.equals("items")) {
                    int items;
                    try {
                        items = Integer.parseInt(value);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IOException("Could not parse \"" + value + "\" at line " + lineNumber);
                    }
                    result.properties.put(key, new Integer(items));
                } else {
                    Matcher matcher = labelPattern.matcher(key);
                    if (matcher.matches()) {
                        int i = Integer.parseInt(matcher.group(1));
                        value = value.substring(1, value.length() - 1);
                        if (i == 0) {
                            result.properties.put("label", value);
                        } else {
                            String[] labels = StreamDescriptor.ensureCapacity((String[])result.properties.get("plane-list"), i);
                            labels[i - 1] = value;
                            result.properties.put("plane-list", labels);
                            result.properties.put(value + ".label", value);
                        }
                    } else if (value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'') {
                        result.properties.put(key, value.substring(1, value.length() - 1));
                    } else if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        result.properties.put(key, value.substring(1, value.length() - 1));
                    } else {
                        result.properties.put(key, value);
                    }
                }
                ++lineNumber;
            }
            line = in.readLine();
        }
        String[] planeList = (String[])result.properties.get("plane-list");
        if (planeList != null) {
            result.properties.put("plane-list", Collections.unmodifiableList(Arrays.asList(planeList)));
        }
        result.properties.put("legacy", "true");
        return result;
    }

    public static String createHeader(Document document) throws DasIOException {
        StringWriter writer = new StringWriter();
        OutputFormat format = new OutputFormat();
        format.setOmitXMLDeclaration(true);
        format.setEncoding("UTF-8");
        XMLSerializer serializer = new XMLSerializer(writer, format);
        try {
            serializer.serialize(document);
        }
        catch (IOException ex) {
            throw new DasIOException(ex.getMessage());
        }
        String result = writer.toString();
        return result;
    }

    private static String[] ensureCapacity(String[] array, int capacity) {
        if (array == null) {
            return new String[capacity];
        }
        if (array.length >= capacity) {
            return array;
        }
        String[] temp = new String[capacity];
        System.arraycopy(array, 0, temp, 0, array.length);
        return temp;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("stream");
        if (this.compression != null && !this.compression.equals("")) {
            element.setAttribute("compression", this.compression);
        }
        if (!this.properties.isEmpty()) {
            Element propertiesElement = document.createElement("properties");
            Iterator i = this.properties.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                propertiesElement.setAttribute(key, value.toString());
            }
            element.appendChild(propertiesElement);
        }
        return element;
    }

    public Object clone() {
        try {
            StreamDescriptor clone = (StreamDescriptor)super.clone();
            clone.properties = new HashMap(this.properties);
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }
}

