/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.util.FixedWidthFormatter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DataTransferType {
    private static final int I_SUN_REAL4 = 0;
    private static final int I_SUN_REAL8 = 1;
    private static final int I_ASCII = 2;
    private static final Map map = new HashMap();
    public static final DataTransferType SUN_REAL4 = new DataTransferType("sun_real4", 0, 4, false);
    public static final DataTransferType SUN_REAL8 = new DataTransferType("sun_real8", 1, 8, false);
    private static final Pattern ASCII_PATTERN = Pattern.compile("ascii([1-9][0-9]?)");
    private final String name;
    private final int sizeBytes;
    private final boolean ascii;
    private final int id;
    private DecimalFormat doubleFormatter;
    private static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
    private static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;

    private DataTransferType(String name, int id, int sizeBytes, boolean ascii) {
        this.name = name;
        this.id = id;
        this.sizeBytes = sizeBytes;
        this.ascii = ascii;
        map.put(name, this);
        if (ascii) {
            this.doubleFormatter = new DecimalFormat(DataTransferType.getFormat(sizeBytes - 1));
        }
    }

    public String toString() {
        return this.name;
    }

    public int getSizeBytes() {
        return this.sizeBytes;
    }

    public static DataTransferType getByName(String name) {
        DataTransferType type = (DataTransferType)map.get(name);
        if (type == null) {
            Matcher m = ASCII_PATTERN.matcher(name);
            if (m.matches()) {
                int charCount = Integer.parseInt(m.group(1));
                type = new DataTransferType(name, 2, charCount, true);
                map.put(name, type);
            } else {
                throw new RuntimeException("Unsupported type: " + name);
            }
        }
        return type;
    }

    public boolean isAscii() {
        return this.ascii;
    }

    public double read(ByteBuffer buffer) {
        ByteOrder bo = buffer.order();
        try {
            double result;
            switch (this.id) {
                case 0: {
                    buffer.order(BIG_ENDIAN);
                    result = buffer.getFloat();
                    break;
                }
                case 1: {
                    buffer.order(BIG_ENDIAN);
                    result = buffer.getDouble();
                    break;
                }
                case 2: {
                    byte[] bytes = new byte[this.sizeBytes];
                    buffer.get(bytes);
                    String str = new String(bytes, "ASCII").trim();
                    result = Double.parseDouble(str);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid id: " + this.id);
                }
            }
            double d = result;
            return d;
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        finally {
            buffer.order(bo);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(double d, ByteBuffer buffer) {
        ByteOrder bo = buffer.order();
        try {
            switch (this.id) {
                case 0: {
                    buffer.order(BIG_ENDIAN);
                    buffer.putFloat((float)d);
                    return;
                }
                case 1: {
                    buffer.order(BIG_ENDIAN);
                    buffer.putDouble(d);
                    return;
                }
                case 2: {
                    String s = this.doubleFormatter.format(d) + " ";
                    if (this.sizeBytes < 10) {
                        s = FixedWidthFormatter.format(s, this.sizeBytes - 1);
                    }
                    byte[] bytes = s.getBytes("US-ASCII");
                    buffer.put(bytes);
                    return;
                }
                default: {
                    throw new IllegalStateException("Invalid id: " + this.id);
                }
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        finally {
            buffer.order(bo);
        }
    }

    private static String getFormat(int length) {
        if (length < 9) {
            return "0.#";
        }
        StringBuffer buffer = new StringBuffer(length);
        buffer.append("+0.");
        for (int i = 0; i < length - 7; ++i) {
            buffer.append('0');
        }
        buffer.append("E00;-#");
        return buffer.toString();
    }
}

