/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.math.fft;

import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsUtil;
import edu.uiowa.physics.pw.das.math.fft.ComplexArray;
import edu.uiowa.physics.pw.das.math.fft.GeneralFFT;

public class FFTUtil {
    public static VectorDataSet fftPower(GeneralFFT fft, VectorDataSet vds) {
        double[] yreal = new double[vds.getXLength()];
        Units yUnits = vds.getYUnits();
        double[] yimag = new double[vds.getXLength()];
        for (int i = 0; i < vds.getXLength(); ++i) {
            yreal[i] = vds.getDouble(i, yUnits);
        }
        ComplexArray.Double ca = ComplexArray.newArray(yreal);
        fft.transform(ca);
        DatumVector xtags = FFTUtil.getFrequencyDomainTags(DataSetUtil.getXTags(vds));
        Units xUnits = xtags.getUnits();
        VectorDataSetBuilder builder = new VectorDataSetBuilder(xtags.getUnits(), yUnits);
        for (int i = 0; i < xtags.getLength() / 2; ++i) {
            builder.insertY(xtags.get(i).doubleValue(xUnits), (double)(i == 0 ? 1 : 2) * ComplexArray.magnitude(ca, i));
        }
        return builder.toVectorDataSet();
    }

    public static ComplexArray.Double fft(GeneralFFT fft, VectorDataSet vds, Units units) {
        double[] yreal = new double[vds.getXLength()];
        Units yUnits = units;
        double[] yimag = new double[vds.getXLength()];
        for (int i = 0; i < vds.getXLength(); ++i) {
            yreal[i] = vds.getDouble(i, yUnits);
        }
        ComplexArray.Double ca = ComplexArray.newArray(yreal);
        fft.transform(ca);
        return ca;
    }

    static DatumVector getFrequencyDomainTags(DatumVector timeDomainTags) {
        int i;
        Units timeUnit = timeDomainTags.getUnits();
        double[] x = timeDomainTags.toDoubleArray(timeUnit);
        double[] result = new double[x.length];
        result[0] = 0.0;
        double T = x[1] - x[0];
        int n = x.length;
        int n21 = n / 2 + 1;
        for (i = 0; i < n21; ++i) {
            result[i] = (double)i / ((double)n * T);
        }
        for (i = 0; i < n21 - 2; ++i) {
            result[i + n21] = (double)(n21 - n + i) / ((double)n * T);
        }
        Units frequencyUnit = UnitsUtil.getInverseUnit(timeUnit);
        return DatumVector.newDatumVector(result, frequencyUnit);
    }
}

