/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.CancelledOperationException;
import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.components.DasProgressPanel;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dataset.ConstantDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataRequestThread;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateEvent;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener;
import edu.uiowa.physics.pw.das.dataset.NoDataInIntervalException;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRendererUpdateEvent;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.system.RequestProcessor;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InterruptedIOException;
import javax.swing.JFileChooser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Renderer
implements DataSetConsumer,
Editable,
DataSetUpdateListener {
    private DataSetDescriptor dsd;
    protected DataSet ds;
    private boolean fullResolution = false;
    DasPlot parent;
    private DasProgressPanel progressPanel;
    private DataRequestThread drt;
    protected Exception lastException;
    private boolean dumpDataSet;
    private boolean reloadDataSet;

    protected Renderer(DataSetDescriptor dsd) {
        this.dsd = dsd;
        if (dsd != null) {
            dsd.addDataSetUpdateListener(this);
        }
    }

    protected Renderer(DataSet ds) {
        this(ds == null ? (DataSetDescriptor)null : new ConstantDataSetDescriptor(ds));
    }

    protected Renderer() {
        this((DataSetDescriptor)null);
    }

    protected Renderer(DasPlot parent, DataSetDescriptor dsd) {
        this(dsd);
        this.parent = parent;
    }

    protected Renderer(DasPlot parent, DataSet ds) {
        this(ds == null ? (DataSetDescriptor)null : new ConstantDataSetDescriptor(ds));
        this.parent = parent;
    }

    public boolean isFullResolution() {
        return this.fullResolution;
    }

    public void setFullResolution(boolean b) {
        if (this.fullResolution == b) {
            return;
        }
        this.fullResolution = b;
    }

    public DasPlot getParent() {
        return this.parent;
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    public boolean isDumpDataSet() {
        return this.dumpDataSet;
    }

    public void setDumpDataSet(boolean dumpDataSet) {
        this.dumpDataSet = dumpDataSet;
        if (dumpDataSet) {
            try {
                if (this.ds == null) {
                    this.setDumpDataSet(false);
                    throw new DasException("data set is null");
                }
                System.out.println("Dumping data set");
                JFileChooser chooser = new JFileChooser();
                int xx = chooser.showSaveDialog(this.getParent());
                if (xx == 0) {
                    File file = chooser.getSelectedFile();
                    if (this.ds instanceof TableDataSet) {
                        TableUtil.dumpToAsciiStream((TableDataSet)this.ds, new FileOutputStream(file));
                    } else if (this.ds instanceof VectorDataSet) {
                        VectorUtil.dumpToAsciiStream((VectorDataSet)this.ds, new FileOutputStream(file));
                    } else {
                        throw new DasException("don't know how to serialize data set: " + this.ds);
                    }
                }
                this.setDumpDataSet(false);
            }
            catch (Exception e) {
                DasExceptionHandler.handle(e);
            }
            this.dumpDataSet = dumpDataSet;
        }
    }

    public void setReloadDataSet(boolean reloadDataSet) {
        if (reloadDataSet) {
            this.ds = null;
            this.dsd.reset();
            this.parent.markDirty();
            this.parent.update();
        }
        reloadDataSet = false;
    }

    public boolean isReloadDataSet() {
        return this.reloadDataSet;
    }

    public void setLastException(Exception e) {
        this.lastException = e;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void setDataSet(DataSet ds) {
        if (ds == null) {
            this.setDataSetDescriptor(null);
        } else {
            this.setDataSetDescriptor(new ConstantDataSetDescriptor(ds));
        }
    }

    public void setDataSetID(String id) throws DasException {
        if (id == null) {
            throw new NullPointerException("Null dataPath not allowed");
        }
        if (id.equals("")) {
            this.setDataSetDescriptor(null);
            return;
        }
        DataSetDescriptor dsd = DataSetDescriptor.create(id);
        this.setDataSetDescriptor(dsd);
    }

    public String getDataSetID() {
        if (this.dsd == null) {
            return "";
        }
        return this.dsd.getDataSetID();
    }

    public abstract void render(Graphics var1, DasAxis var2, DasAxis var3);

    public void renderException(Graphics g, DasAxis xAxis, DasAxis yAxis, Exception e) {
        String message;
        String s;
        int x = xAxis.getColumn().getDMiddle();
        int y = yAxis.getRow().getDMiddle();
        FontMetrics fm = g.getFontMetrics();
        if (e instanceof NoDataInIntervalException) {
            s = "no data in interval";
            message = e.getMessage();
        } else {
            s = e.getMessage();
            message = "";
            if (s == null || s.equals("")) {
                s = e.toString();
            }
        }
        if (!message.equals("")) {
            s = s + ":!c" + message;
        }
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        gtr.setString(this.parent, s);
        gtr.setAlignment(1);
        int width = (int)gtr.getWidth();
        Color color0 = g.getColor();
        g.setColor(Color.lightGray);
        gtr.draw(g, x - width / 2, y);
        g.setColor(color0);
    }

    protected void loadDataSet(final DasAxis xAxis, DasAxis yAxis) {
        if (this.parent == null || !this.parent.isDisplayable() || this.dsd == null) {
            if (this.dsd == null) {
                DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).fine("dsd is null, nothing to do");
            }
            return;
        }
        if (this.dsd instanceof ConstantDataSetDescriptor) {
            try {
                DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("get data from ConstantDataSetDescriptor");
                this.ds = this.dsd.getDataSet(null, null, null, null);
                this.updatePlotImage(xAxis, yAxis, this.progressPanel);
                return;
            }
            catch (DasException exception) {
                DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).warning("exception in ConstantDataSetDescriptor.getDataSet");
                if (exception instanceof DasException) {
                    this.lastException = exception;
                    this.ds = null;
                }
                DasExceptionHandler.handle(exception);
                return;
            }
        }
        this.lastException = null;
        Runnable request = new Runnable(){

            public void run() {
                Datum dataRange1 = xAxis.getDataMaximum().subtract(xAxis.getDataMinimum());
                double deviceRange = Math.floor((double)xAxis.getColumn().getDMaximum() + 0.5) - Math.floor((double)xAxis.getColumn().getDMinimum() + 0.5);
                Datum resolution = Renderer.this.fullResolution ? null : dataRange1.divide(deviceRange);
                if (deviceRange == 0.0) {
                    return;
                }
                if (Renderer.this.progressPanel == null) {
                    Renderer.this.progressPanel = DasProgressPanel.createComponentPanel(Renderer.this.parent, "Loading data set");
                } else {
                    Renderer.this.progressPanel.setLabel("Loading data set");
                }
                Renderer.this.progressPanel.cancel();
                DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("request data from dsd: " + xAxis.getDataMinimum() + " " + xAxis.getDataMaximum() + " " + resolution);
                Renderer.this.dsd.requestDataSet(xAxis.getDataMinimum(), xAxis.getDataMaximum(), resolution, Renderer.this.progressPanel);
            }

            public String toString() {
                return "loadDataSet " + xAxis.getDatumRange();
            }
        };
        try {
            DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("preview image");
            this.updatePlotImage(xAxis, yAxis, null);
        }
        catch (DasException de) {
            // empty catch block
        }
        DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("submit data request");
        RequestProcessor.invokeLater(request, this.getParent().getCanvas());
    }

    public abstract void updatePlotImage(DasAxis var1, DasAxis var2, DasProgressMonitor var3) throws DasException;

    protected void refreshImage() {
        if (this.getParent() != null) {
            this.getParent().markDirty();
            if (this instanceof SpectrogramRenderer) {
                this.update();
            }
            this.getParent().repaint();
        }
    }

    public void update() {
        DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("update");
        if (this.parent != null) {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            DasRendererUpdateEvent drue = new DasRendererUpdateEvent(this.parent, this);
            eventQueue.postEvent(drue);
        } else {
            DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("update but parent was null");
        }
    }

    protected void updateImmediately() {
        DasAxis xAxis = this.parent.getXAxis();
        DasAxis yAxis = this.parent.getYAxis();
        this.loadDataSet(xAxis, yAxis);
    }

    private boolean rendererHandlesException(Exception e) {
        boolean result = e instanceof InterruptedIOException || e instanceof NoDataInIntervalException || e instanceof CancelledOperationException;
        return result;
    }

    public void dataSetUpdated(DataSetUpdateEvent e) {
        block15: {
            DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("got dataset update:" + e);
            if (e.getException() != null && e.getDataSet() != null) {
                throw new IllegalStateException("both exception and data set");
            }
            if (e.getException() != null) {
                DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("got dataset update exception: " + e.getException());
                Exception exception = e.getException();
                if (!this.rendererHandlesException(exception)) {
                    DasExceptionHandler.handle(exception);
                }
                this.lastException = exception;
            } else if (e.getDataSet() == null) {
                DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("got dataset update notification (no dataset).");
                this.parent.markDirty();
                this.parent.update();
                this.parent.repaint();
                return;
            }
            try {
                block14: {
                    try {
                        this.ds = e.getDataSet();
                        DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("got dataset update w/dataset: " + this.ds);
                        if (this.progressPanel != null) {
                            this.progressPanel.setLabel("Rebinning data set");
                        }
                        DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).fine("update plot image");
                        this.updatePlotImage(this.parent.getXAxis(), this.parent.getYAxis(), this.progressPanel);
                        if (this.parent == null) break block14;
                        DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).fine("repaint");
                        this.parent.repaint();
                    }
                    catch (DasException de) {
                        DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).warning("exception: " + de);
                        this.ds = null;
                        this.lastException = de;
                        Object var4_6 = null;
                        if (this.progressPanel != null) {
                            DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).fine("progressPanel.finished()");
                            this.progressPanel.finished();
                        }
                        break block15;
                    }
                    catch (RuntimeException re) {
                        this.ds = null;
                        throw re;
                    }
                }
                Object var4_5 = null;
                if (this.progressPanel != null) {
                    DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).fine("progressPanel.finished()");
                    this.progressPanel.finished();
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                if (this.progressPanel != null) {
                    DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).fine("progressPanel.finished()");
                    this.progressPanel.finished();
                }
                throw throwable;
            }
        }
    }

    public void setDataSetDescriptor(DataSetDescriptor dsd) {
        if (this.dsd != null) {
            this.dsd.removeDataSetUpdateListener(this);
        }
        this.dsd = dsd;
        if (dsd != null) {
            dsd.addDataSetUpdateListener(this);
        }
        if (this.parent != null) {
            this.parent.markDirty();
            this.parent.update();
        }
        this.ds = null;
    }

    public DataSetDescriptor getDataSetDescriptor() {
        return this.dsd;
    }

    protected abstract void installRenderer();

    protected abstract void uninstallRenderer();

    protected abstract Element getDOMElement(Document var1);
}

