/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Psym;
import edu.uiowa.physics.pw.das.graph.PsymConnector;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Legend
extends DasCanvasComponent {
    ArrayList elements = new ArrayList();

    public void add(SymbolLineRenderer rend, String label) {
        LegendElement e = new LegendElement(rend, label);
        this.elements.add(e);
    }

    public void add(Psym psym, PsymConnector psymConnector, String label, Color color) {
        LegendElement e = new LegendElement(psym, psymConnector, color, label);
        this.elements.add(e);
    }

    public void resize() {
        this.setBounds(DasRow.toRectangle(this.getRow(), this.getColumn()));
    }

    public void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int border = 5;
        int x = 5;
        int y = 5;
        FontMetrics fm = g.getFontMetrics();
        Color color0 = g.getColor();
        int maxWidth = 0;
        for (int i = 0; i < this.elements.size(); ++i) {
            LegendElement e = (LegendElement)this.elements.get(i);
            Icon icon = e.getIcon();
            icon.paintIcon(this, g, x, y);
            g.drawString(e.label, x + 20, y + icon.getIconHeight());
            int w1 = fm.stringWidth(e.label) + x + 20;
            if (w1 > maxWidth) {
                maxWidth = w1;
            }
            y += fm.getHeight() > icon.getIconHeight() ? fm.getHeight() : icon.getIconHeight() + border;
        }
        g.setColor(Color.LIGHT_GRAY);
        g.draw(new Rectangle(0, 0, maxWidth + 10, y - 1));
        g.setColor(color0);
    }

    class LegendElement {
        Icon icon;
        Psym psym;
        PsymConnector psymConnector;
        Color color;
        String label;

        Icon getIcon() {
            return this.icon;
        }

        private Icon createIconFor(Psym psym, PsymConnector connector, Color color) {
            BufferedImage i = new BufferedImage(15, 10, 2);
            Graphics2D g = (Graphics2D)((Image)i).getGraphics();
            g.setRenderingHints(DasProperties.getRenderingHints());
            g.setColor(new Color(0, 0, 0, 0));
            g.fillRect(0, 0, 15, 10);
            g.setColor(color);
            Stroke stroke0 = g.getStroke();
            connector.drawLine(g, 2.0, 3.0, 13.0, 7.0, 1.5f);
            g.setStroke(stroke0);
            psym.draw(g, 7.0, 5.0, 3.0f);
            return new ImageIcon(i);
        }

        LegendElement(Psym psym, PsymConnector psymConnector, Color color, String label) {
            this.psym = psym;
            this.psymConnector = psymConnector;
            this.color = color;
            this.icon = this.createIconFor(psym, psymConnector, color);
            this.label = label;
        }

        LegendElement(SymbolLineRenderer rend, String label) {
            this(rend.getPsym(), rend.getPsymConnector(), rend.getColor(), label);
        }
    }
}

