/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateEvent;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Stack;
import javax.swing.event.EventListenerList;

public class DataRange
implements Cloneable {
    private DasAxis parent;
    private Units units;
    private double minimum;
    private double maximum;
    private boolean log;
    private EventListenerList listenerList = new EventListenerList();
    private Stack history;
    private Stack forwardHistory;
    private PropertyChangeSupport propertyChangeDelegate;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener;

    public DataRange(DasAxis parent, Datum min, Datum max, boolean log) {
        if (min.gt(max)) {
            throw new IllegalArgumentException("data min on axis is greater than data max");
        }
        if (!min.isValid()) {
            throw new IllegalArgumentException("data_minimum on axis is NaN");
        }
        if (!max.isValid()) {
            throw new IllegalArgumentException("data_maximum on axis is NaN");
        }
        if (min.getUnits() != max.getUnits()) {
            throw new IllegalArgumentException("units don't match on range");
        }
        this.parent = parent;
        this.units = min.getUnits();
        if (log) {
            this.minimum = DasMath.log10(min.doubleValue(this.units));
            this.maximum = DasMath.log10(max.doubleValue(this.units));
        } else {
            this.minimum = min.doubleValue(this.units);
            this.maximum = max.doubleValue(this.units);
        }
        this.log = log;
        this.history = new Stack();
        this.forwardHistory = new Stack();
        this.propertyChangeDelegate = new PropertyChangeSupport(this);
    }

    public boolean isLog() {
        return this.log;
    }

    public void resetRange(DatumRange range) {
        this.units = range.getUnits();
        this.minimum = range.min().doubleValue(this.units);
        this.maximum = range.max().doubleValue(this.units);
        this.fireUpdate();
    }

    public void setLog(boolean log) {
        if (this.log == log) {
            return;
        }
        boolean oldLog = this.log;
        if (log) {
            if (this.minimum <= 0.0 || this.maximum <= 0.0) {
                return;
            }
            this.minimum = DasMath.log10(this.minimum);
            this.maximum = DasMath.log10(this.maximum);
        } else {
            this.minimum = DasMath.exp10(this.minimum);
            this.maximum = DasMath.exp10(this.maximum);
        }
        this.clearHistory();
        this.log = log;
        this.firePropertyChange("log", oldLog, log);
        this.fireUpdate();
    }

    public DasAxis getCreator() {
        return this.parent;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units newUnits) {
        if (this.units.equals(newUnits)) {
            return;
        }
        this.minimum = this.units.convertDoubleTo(newUnits, this.minimum);
        this.maximum = this.units.convertDoubleTo(newUnits, this.maximum);
        this.units = newUnits;
        this.clearHistory();
    }

    public void setMinimum(double min) {
        this.setRange(min, this.maximum);
    }

    public void setMaximum(double max) {
        this.setRange(this.minimum, max);
    }

    private void reportHistory() {
        DasDie.println("history: " + this.history.size());
        for (int i = 0; i < this.history.size(); ++i) {
            DasDie.print("   " + ((Object[])this.history.get(i))[0] + " - ");
            DasDie.println("   " + ((Object[])this.history.get(i))[1]);
        }
        DasDie.println("forwardHistory: " + this.forwardHistory.size());
        DasDie.println("-------------");
    }

    protected void clearHistory() {
        this.history.removeAllElements();
        this.forwardHistory.removeAllElements();
    }

    public void setRange(double min, double max) {
        boolean pushStack = true;
        if (pushStack) {
            Datum[] h = new Datum[2];
            if (this.minimum != this.maximum) {
                h[0] = Datum.create(this.minimum, this.units);
                h[1] = Datum.create(this.maximum, this.units);
                this.history.push(h);
            }
            this.forwardHistory.removeAllElements();
        }
        double oldMin = this.minimum;
        double oldMax = this.maximum;
        this.minimum = min;
        this.maximum = max;
        this.fireUpdate();
        if (this.minimum != oldMin) {
            this.firePropertyChange("minimum", oldMin, this.minimum);
        }
        if (this.maximum != oldMax) {
            this.firePropertyChange("maximum", oldMax, this.maximum);
        }
    }

    public void setRangePrev() {
        double oldMin = this.minimum;
        double oldMax = this.maximum;
        this.reportHistory();
        if (!this.history.isEmpty()) {
            this.forwardHistory.push(new Datum[]{Datum.create(this.minimum, this.units), Datum.create(this.maximum, this.units)});
            Datum[] h = (Datum[])this.history.pop();
            if (h[0].getUnits() != this.units) {
                h[0] = h[0].convertTo(this.units);
                h[1] = h[1].convertTo(this.units);
            }
            this.minimum = h[0].doubleValue(this.units);
            this.maximum = h[1].doubleValue(this.units);
            this.fireUpdate();
        }
        if (this.minimum != oldMin) {
            this.firePropertyChange("minimum", oldMin, this.minimum);
        }
        if (this.maximum != oldMax) {
            this.firePropertyChange("maximum", oldMax, this.maximum);
        }
        this.reportHistory();
    }

    public void setRangeForward() {
        double oldMin = this.minimum;
        double oldMax = this.maximum;
        this.reportHistory();
        if (!this.forwardHistory.isEmpty()) {
            this.history.push(new Datum[]{Datum.create(this.minimum, this.units), Datum.create(this.maximum, this.units)});
            Datum[] h = (Datum[])this.forwardHistory.pop();
            if (h[0].getUnits() != this.units) {
                h[0] = h[0].convertTo(this.units);
                h[1] = h[1].convertTo(this.units);
            }
            this.minimum = h[0].doubleValue(this.units);
            this.maximum = h[1].doubleValue(this.units);
            this.fireUpdate();
        }
        this.reportHistory();
        if (this.minimum != oldMin) {
            this.firePropertyChange("minimum", oldMin, this.minimum);
        }
        if (this.maximum != oldMax) {
            this.firePropertyChange("maximum", oldMax, this.maximum);
        }
        this.reportHistory();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeDelegate.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeDelegate.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.firePropertyChange(propertyName, oldValue ? Boolean.TRUE : Boolean.FALSE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeDelegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addpwUpdateListener(DasUpdateListener l) {
        this.listenerList.add(class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener == null ? (class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener = DataRange.class$("edu.uiowa.physics.pw.das.graph.event.DasUpdateListener")) : class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener, l);
    }

    public void removepwUpdateListener(DasUpdateListener l) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener == null ? (class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener = DataRange.class$("edu.uiowa.physics.pw.das.graph.event.DasUpdateListener")) : class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener, l);
    }

    protected void fireUpdate() {
        Object[] listeners = this.listenerList.getListenerList();
        DasUpdateEvent e = new DasUpdateEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener == null ? DataRange.class$("edu.uiowa.physics.pw.das.graph.event.DasUpdateListener") : class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener)) continue;
            ((DasUpdateListener)listeners[i + 1]).update(e);
        }
    }

    public void popHistory() {
        if (!this.history.empty()) {
            this.history.pop();
        }
    }

    public DataRange getAnimationDataRange() {
        Datum min = Datum.create(this.getMinimum(), this.getUnits());
        Datum max = Datum.create(this.getMaximum(), this.getUnits());
        return new DataRange(this.parent, min, max, this.isLog()){

            protected void fireUpdate() {
            }

            public void setRange(double min, double max) {
                DataRange.this.minimum = min;
                DataRange.this.maximum = max;
            }

            public double getMinimum() {
                return DataRange.this.minimum;
            }

            public double getMaximum() {
                return DataRange.this.maximum;
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

