/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.dataset.ConstantDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DefaultVectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Psym;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import edu.uiowa.physics.pw.das.util.DasDie;
import java.util.Collections;

public class DasSymbolPlot
extends DasPlot {
    private SymbolLineRenderer renderer;

    public DasSymbolPlot(VectorDataSet data, DasAxis xAxis, DasAxis yAxis) {
        this(data == null ? null : new ConstantDataSetDescriptor(data), xAxis, yAxis);
    }

    public DasSymbolPlot(DataSetDescriptor dsd, DasAxis xAxis, DasAxis yAxis) {
        super(xAxis, yAxis);
        this.renderer = new SymbolLineRenderer(dsd);
        this.addRenderer(this.renderer);
    }

    public Psym getPsym() {
        return this.renderer.getPsym();
    }

    public void setPsym(Psym psym) {
        this.renderer.setPsym(psym);
    }

    public void addData(double[] x, double[] y) {
        Units units = Units.dimensionless;
        this.addData(new DefaultVectorDataSet(x, units, y, units, Collections.EMPTY_MAP));
    }

    public void addData(double[] y) {
        double[] x = new double[y.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = i;
        }
        this.addData(x, y);
    }

    public void addData(VectorDataSet Data) {
        this.renderer.setDataSet(Data);
    }

    public static DasSymbolPlot create(DasCanvas parent, DataSetDescriptor dsd) {
        DasRow row = new DasRow(parent, 0.05, 0.85);
        DasColumn column = new DasColumn(parent, 0.15, 0.9);
        DasDie.println("  dsd: " + dsd + " units: " + dsd.getXUnits());
        DasAxis xAxis = dsd.getXUnits() instanceof TimeLocationUnits ? new DasAxis(TimeUtil.createValid("2000/1/1"), TimeUtil.createValid("2000/1/2"), 2) : new DasAxis(Datum.create(0, dsd.getXUnits()), Datum.create(10, dsd.getXUnits()), 2);
        DasAxis yAxis = new DasAxis(Datum.create(0, Units.dimensionless), Datum.create(10, Units.dimensionless), 3);
        DasSymbolPlot result = new DasSymbolPlot(dsd, xAxis, yAxis);
        parent.add(result, row, column);
        return result;
    }

    public static DasSymbolPlot create(DasCanvas parent, VectorDataSet Data) {
        int nx;
        DasRow row = new DasRow(parent, 0.05, 0.85);
        DasColumn column = new DasColumn(parent, 0.15, 0.9);
        int ny = nx = Data.getXLength();
        double[] x = new double[nx];
        for (int i = 0; i < nx; ++i) {
            x[i] = Data.getXTagDouble(i, Data.getXUnits());
        }
        double y_fill = Double.NaN;
        double[] y = new double[ny];
        int iy = 0;
        for (int i = 0; i < ny; ++i) {
            double yValue = Data.getDouble(i, Data.getYUnits());
            if (Double.isNaN(yValue)) continue;
            y[iy++] = yValue;
        }
        DasSymbolPlot result = new DasSymbolPlot(Data, DasAxis.create(x, Data.getXUnits(), 2, false), DasAxis.create(y, Data.getYUnits(), 3, false));
        parent.add(result, row, column);
        return result;
    }

    public double getSymSize() {
        return this.renderer.getSymSize();
    }

    public void setSymSize(double symSize) {
        this.renderer.setSymSize(symSize);
    }
}

