/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.ConstantDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.DasZAxisPlot;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.text.ParseException;
import java.util.Collections;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DasSpectrogramPlot
extends DasPlot
implements DasZAxisPlot {
    private TableDataSet rebinData;
    private SpectrogramRenderer renderer;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasRow;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasColumn;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasAxis;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasColorBar;

    public static DasSpectrogramPlot create(DasCanvas parent, TableDataSet Data) {
        DasRow row = new DasRow(parent, 0.05, 0.85);
        DasColumn column = new DasColumn(parent, 0.15, 0.8);
        int nx = Data.getXLength();
        int ny = Data.getYLength(0);
        double[] x = new double[nx];
        for (int i = 0; i < nx; ++i) {
            x[i] = Data.getXTagDouble(i, Data.getXUnits());
        }
        double[] y = new double[ny];
        for (int j = 0; j < ny; ++j) {
            y[j] = Data.getYTagDouble(0, j, Data.getYUnits());
        }
        double z_fill = Double.NaN;
        double[] zl = new double[nx * ny];
        int iz = 0;
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                double zValue = Data.getDouble(i, j, Data.getZUnits());
                if (Double.isNaN(zValue)) continue;
                zl[iz++] = zValue;
            }
        }
        double[] z = new double[iz];
        System.arraycopy(zl, 0, z, 0, iz);
        DasColorBar colorBar = new DasColorBar(Datum.create(0, Data.getZUnits()), Datum.create(0, Data.getZUnits()), false);
        colorBar.setColumn(DasColorBar.getColorBarColumn(column));
        colorBar.setDataRange(z);
        DasAxis xAxis = new DasAxis(Datum.create(0, Data.getXUnits()), Datum.create(0, Data.getXUnits()), 2, false);
        xAxis.setDataRange(x);
        DasAxis yAxis = new DasAxis(Datum.create(0, Data.getYUnits()), Datum.create(0, Data.getYUnits()), 3, false);
        xAxis.setDataRange(x);
        DasSpectrogramPlot result = new DasSpectrogramPlot(Data, xAxis, yAxis, row, column, colorBar);
        return result;
    }

    public DasSpectrogramPlot() {
        this(null, null, null, null);
    }

    public DasSpectrogramPlot(TableDataSet data, DasAxis xAxis, DasAxis yAxis, DasRow row, DasColumn column, DasColorBar colorBar) {
        this(data == null ? null : new ConstantDataSetDescriptor(data), xAxis, yAxis, colorBar);
    }

    public DasSpectrogramPlot(DataSetDescriptor dataSetDescriptor, DasAxis xAxis, DasAxis yAxis, DasColorBar colorBar) {
        super(xAxis, yAxis);
        this.renderer = new SpectrogramRenderer(this, dataSetDescriptor, colorBar);
        this.addRenderer(this.renderer);
    }

    public TableDataSet getRebinData() {
        return this.rebinData;
    }

    public DasColorBar getColorBar() {
        return this.renderer.getColorBar();
    }

    public void setColorBar(DasColorBar colorBar) {
    }

    public void setDataSetID(String id) throws DasException {
        this.renderer.setDataSetID(id);
        this.markDirty();
        this.update();
    }

    public String getDataSetID() {
        return this.renderer.getDataSetID();
    }

    private static TableDataSet createEmptyDataSet() {
        double[] yTags;
        Units zUnits;
        Units yUnits = zUnits = Units.dimensionless;
        Units xUnits = zUnits;
        double[] xTags = yTags = new double[0];
        double[][] zValues = new double[][]{};
        DefaultTableDataSet ds = new DefaultTableDataSet(xTags, xUnits, yTags, yUnits, zValues, zUnits, Collections.EMPTY_MAP);
        return ds;
    }

    public SpectrogramRenderer getRenderer() {
        return this.renderer;
    }

    public void setZAxis(DasAxis zAxis) {
    }

    public DasAxis getZAxis() {
        return this.renderer.getColorBar();
    }

    protected void installComponent() {
        super.installComponent();
    }

    static DasSpectrogramPlot processSpectrogramElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        String name = element.getAttribute("name");
        DasRow row = (DasRow)form.checkValue(element.getAttribute("row"), class$edu$uiowa$physics$pw$das$graph$DasRow == null ? (class$edu$uiowa$physics$pw$das$graph$DasRow = DasSpectrogramPlot.class$("edu.uiowa.physics.pw.das.graph.DasRow")) : class$edu$uiowa$physics$pw$das$graph$DasRow, "<row>");
        DasColumn column = (DasColumn)form.checkValue(element.getAttribute("column"), class$edu$uiowa$physics$pw$das$graph$DasColumn == null ? (class$edu$uiowa$physics$pw$das$graph$DasColumn = DasSpectrogramPlot.class$("edu.uiowa.physics.pw.das.graph.DasColumn")) : class$edu$uiowa$physics$pw$das$graph$DasColumn, "<column>");
        DasAxis xAxis = null;
        DasAxis yAxis = null;
        DasColorBar colorbar = null;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            if (node.getNodeName().equals("xAxis")) {
                xAxis = DasSpectrogramPlot.processXAxisElement((Element)node, form);
                continue;
            }
            if (node.getNodeName().equals("yAxis")) {
                yAxis = DasSpectrogramPlot.processYAxisElement((Element)node, form);
                continue;
            }
            if (!node.getNodeName().equals("zAxis")) continue;
            colorbar = DasSpectrogramPlot.processZAxisElement((Element)node, form);
        }
        if (xAxis == null) {
            xAxis = (DasAxis)form.checkValue(element.getAttribute("xAxis"), class$edu$uiowa$physics$pw$das$graph$DasAxis == null ? (class$edu$uiowa$physics$pw$das$graph$DasAxis = DasSpectrogramPlot.class$("edu.uiowa.physics.pw.das.graph.DasAxis")) : class$edu$uiowa$physics$pw$das$graph$DasAxis, "<axis> or <timeaxis>");
        }
        if (yAxis == null) {
            yAxis = (DasAxis)form.checkValue(element.getAttribute("yAxis"), class$edu$uiowa$physics$pw$das$graph$DasAxis == null ? (class$edu$uiowa$physics$pw$das$graph$DasAxis = DasSpectrogramPlot.class$("edu.uiowa.physics.pw.das.graph.DasAxis")) : class$edu$uiowa$physics$pw$das$graph$DasAxis, "<axis> or <timeaxis>");
        }
        if (colorbar == null) {
            colorbar = (DasColorBar)form.checkValue(element.getAttribute("colorbar"), class$edu$uiowa$physics$pw$das$graph$DasColorBar == null ? (class$edu$uiowa$physics$pw$das$graph$DasColorBar = DasSpectrogramPlot.class$("edu.uiowa.physics.pw.das.graph.DasColorBar")) : class$edu$uiowa$physics$pw$das$graph$DasColorBar, "<colorbar>");
        }
        DasSpectrogramPlot plot = new DasSpectrogramPlot(null, xAxis, yAxis, colorbar);
        plot.setTitle(element.getAttribute("title"));
        try {
            plot.setDataSetID(element.getAttribute("dataPath"));
        }
        catch (DasException de) {
            DasExceptionHandler.handle(de);
        }
        try {
            plot.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle(dne);
        }
        return plot;
    }

    private static DasAxis processXAxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (node.getNodeName().equals("axis")) {
                e.setAttribute("orientation", "horizontal");
                return DasAxis.processAxisElement(e, form);
            }
            if (node.getNodeName().equals("timeaxis")) {
                e.setAttribute("orientation", "horizontal");
                return DasAxis.processTimeaxisElement(e, form);
            }
            if (!node.getNodeName().equals("attachedaxis")) continue;
            e.setAttribute("orientation", "horizontal");
            return DasAxis.processAttachedaxisElement(e, form);
        }
        return null;
    }

    private static DasAxis processYAxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (node.getNodeName().equals("axis")) {
                e.setAttribute("orientation", "vertical");
                return DasAxis.processAxisElement(e, form);
            }
            if (node.getNodeName().equals("timeaxis")) {
                e.setAttribute("orientation", "vertical");
                return DasAxis.processTimeaxisElement(e, form);
            }
            if (!node.getNodeName().equals("attachedaxis")) continue;
            e.setAttribute("orientation", "vertical");
            return DasAxis.processAttachedaxisElement(e, form);
        }
        return null;
    }

    private static DasColorBar processZAxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("colorbar")) continue;
            return DasColorBar.processColorbarElement((Element)node, form);
        }
        return null;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("spectrogram");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("title", this.getTitle());
        element.setAttribute("dataPath", this.getDataSetID());
        Element xAxisChild = document.createElement("xAxis");
        Element xAxisElement = this.getXAxis().getDOMElement(document);
        xAxisElement.removeAttribute("orientation");
        if (xAxisElement.getAttribute("row").equals(this.getRow().getDasName())) {
            xAxisElement.removeAttribute("row");
        }
        if (xAxisElement.getAttribute("column").equals(this.getColumn().getDasName())) {
            xAxisElement.removeAttribute("column");
        }
        xAxisChild.appendChild(xAxisElement);
        element.appendChild(xAxisChild);
        Element yAxisChild = document.createElement("yAxis");
        Element yAxisElement = this.getYAxis().getDOMElement(document);
        yAxisElement.removeAttribute("orientation");
        if (yAxisElement.getAttribute("row").equals(this.getRow().getDasName())) {
            yAxisElement.removeAttribute("row");
        }
        if (yAxisElement.getAttribute("column").equals(this.getColumn().getDasName())) {
            yAxisElement.removeAttribute("column");
        }
        yAxisChild.appendChild(yAxisElement);
        element.appendChild(yAxisChild);
        Element zAxisChild = document.createElement("zAxis");
        Element zAxisElement = this.getColorBar().getDOMElement(document);
        if (zAxisElement.getAttribute("row").equals(this.getRow().getDasName())) {
            zAxisElement.removeAttribute("row");
        }
        if (zAxisElement.getAttribute("column").equals(this.getColumn().getDasName())) {
            zAxisElement.removeAttribute("column");
        }
        zAxisChild.appendChild(zAxisElement);
        element.appendChild(zAxisChild);
        return element;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

