/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.graph.AttachedRow;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasDevicePosition;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;
import java.beans.PropertyChangeListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasRow
extends DasDevicePosition {
    public static final DasRow NULL = new NullDasRow();

    public DasRow(DasCanvas parent, double top, double bottom) {
        super(parent, top, bottom);
    }

    protected int getDeviceSize() {
        return this.parent.getHeight();
    }

    public DasRow createSubRow(double ptop, double pbottom) {
        double top = this.getMinimum();
        double bottom = this.getMaximum();
        double delta = top - bottom;
        return new DasRow(this.parent, bottom + ptop * delta, bottom + pbottom * delta);
    }

    public int getHeight() {
        return this.getDMaximum() - this.getDMinimum();
    }

    public static DasRow create(DasCanvas parent) {
        return new DasRow(parent, 0.1, 0.9);
    }

    public DasRow createAttachedRow(double ptop, double pbottom) {
        return new AttachedRow(this, ptop, pbottom);
    }

    static DasRow processRowElement(Element element, DasCanvas canvas, FormBase form) throws DasException {
        String name = element.getAttribute("name");
        double minimum = Double.parseDouble(element.getAttribute("minimum"));
        double maximum = Double.parseDouble(element.getAttribute("maximum"));
        DasRow row = new DasRow(canvas, minimum, maximum);
        row.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, row);
        return row;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("row");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("minimum", Double.toString(this.getMinimum()));
        element.setAttribute("maximum", Double.toString(this.getMaximum()));
        return element;
    }

    static class NullDasRow
    extends DasRow {
        public NullDasRow() {
            super(null, 0.0, 0.0);
        }

        public int getDMinimum() {
            throw new RuntimeException("null row, row was not set before layout");
        }

        public int getDMaximum() {
            throw new RuntimeException("null row, row was not set before layout");
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            throw new RuntimeException("NULL.addPropertyChangeListener");
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            throw new RuntimeException("NULL.removePropertyChangeListener");
        }

        public void addpwUpdateListener(DasUpdateListener l) {
            throw new RuntimeException("NULL.addpwUpdateListener");
        }

        public void removepwUpdateListener(DasUpdateListener l) {
            throw new RuntimeException("NULL.removepwUpdateListener");
        }

        protected void fireUpdate() {
            throw new RuntimeException("NULL.fireUpdate");
        }
    }
}

