/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.components.DasProgressPanel;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.DataRequestThread;
import edu.uiowa.physics.pw.das.dataset.DataRequestor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.CrossHairMouseModule;
import edu.uiowa.physics.pw.das.event.HorizontalRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.event.VerticalRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRendererUpdateEvent;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableRenderer;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.FileChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DasPlot
extends DasCanvasComponent
implements DataSetConsumer {
    protected DataSetDescriptor dataSetDescriptor;
    protected DataSet Data;
    private DasAxis xAxis;
    private DasAxis yAxis;
    protected String offsetTime = "";
    protected String plotTitle = "";
    protected double[] psym_x;
    protected double[] psym_y;
    protected Image plotImage;
    protected RebinListener rebinListener = new RebinListener();
    DnDSupport dndSupport;
    DataRequestThread drt;
    DasProgressPanel progressPanel;
    private List renderers = null;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasRow;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasColumn;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasAxis;

    public DasPlot(DasAxis xAxis, DasAxis yAxis) {
        this.setOpaque(false);
        this.renderers = new ArrayList();
        this.xAxis = xAxis;
        if (xAxis != null) {
            if (!xAxis.isHorizontal()) {
                throw new IllegalArgumentException("xAxis is not horizontal");
            }
            xAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            xAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            xAxis.addPropertyChangeListener("log", this.rebinListener);
        }
        this.yAxis = yAxis;
        if (yAxis != null) {
            if (yAxis.isHorizontal()) {
                throw new IllegalArgumentException("yAxis is not vertical");
            }
            yAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            yAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            yAxis.addPropertyChangeListener("log", this.rebinListener);
        }
        if (!"true".equals(System.getProperty("java.awt.headless"))) {
            HorizontalRangeSelectorMouseModule hrs = new HorizontalRangeSelectorMouseModule(this, xAxis);
            this.mouseAdapter.addMouseModule(hrs);
            hrs.addDataRangeSelectionListener(xAxis);
            VerticalRangeSelectorMouseModule vrs = new VerticalRangeSelectorMouseModule(this, yAxis);
            this.mouseAdapter.addMouseModule(vrs);
            vrs.addDataRangeSelectionListener(yAxis);
            CrossHairMouseModule x = new CrossHairMouseModule(this, xAxis, yAxis);
            this.mouseAdapter.addMouseModule(x);
            this.mouseAdapter.setSecondaryModule(x);
            this.mouseAdapter.setPrimaryModule(x);
            JMenuItem dumpMenuItem = new JMenuItem("Dump Data Set To File");
            dumpMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (DasPlot.this.renderers.isEmpty()) {
                        return;
                    }
                    Renderer renderer = (Renderer)DasPlot.this.renderers.get(0);
                    JFileChooser chooser = new JFileChooser();
                    int result = chooser.showSaveDialog(DasPlot.this);
                    if (result == 0) {
                        File selected = chooser.getSelectedFile();
                        try {
                            FileChannel out = new FileOutputStream(selected).getChannel();
                            DataSet ds = renderer.getDataSet();
                            if (ds instanceof TableDataSet) {
                                TableUtil.dumpToAsciiStream((TableDataSet)ds, out);
                            } else if (ds instanceof VectorDataSet) {
                                VectorUtil.dumpToAsciiStream((VectorDataSet)ds, out);
                            }
                        }
                        catch (IOException ioe) {
                            DasExceptionHandler.handle(ioe);
                        }
                    }
                }
            });
            this.mouseAdapter.addMenuItem(dumpMenuItem);
        }
    }

    public DataSet getDataSet() {
        return this.Data;
    }

    public DataSet getData() {
        return this.Data;
    }

    public void setXAxis(DasAxis xAxis) {
        DasAxis oldValue = this.xAxis;
        Container parent = this.getParent();
        if (this.xAxis != null) {
            DasProperties.getLogger().fine("setXAxis upsets the dmia");
            if (parent != null) {
                parent.remove(this.xAxis);
            }
            xAxis.removePropertyChangeListener("minimum", this.rebinListener);
            xAxis.removePropertyChangeListener("maximum", this.rebinListener);
            xAxis.removePropertyChangeListener("log", this.rebinListener);
        }
        this.xAxis = xAxis;
        if (xAxis != null) {
            if (!xAxis.isHorizontal()) {
                throw new IllegalArgumentException("xAxis is not horizontal");
            }
            if (parent != null) {
                parent.add(this.xAxis);
            }
            xAxis.addPropertyChangeListener("minimum", this.rebinListener);
            xAxis.addPropertyChangeListener("maximum", this.rebinListener);
            xAxis.addPropertyChangeListener("log", this.rebinListener);
        }
        if (xAxis != oldValue) {
            this.firePropertyChange("xAxis", oldValue, xAxis);
        }
    }

    public void setYAxis(DasAxis yAxis) {
        DasAxis oldValue = this.yAxis;
        Container parent = this.getParent();
        if (this.yAxis != null) {
            DasProperties.getLogger().fine("setYAxis upsets the dmia");
            if (parent != null) {
                parent.remove(this.yAxis);
            }
            yAxis.removePropertyChangeListener("minimum", this.rebinListener);
            yAxis.removePropertyChangeListener("maximum", this.rebinListener);
            yAxis.removePropertyChangeListener("log", this.rebinListener);
        }
        this.yAxis = yAxis;
        if (yAxis != null) {
            if (yAxis.isHorizontal()) {
                throw new IllegalArgumentException("yAxis is not vertical");
            }
            if (parent != null) {
                parent.add(this.yAxis);
            }
            yAxis.addPropertyChangeListener("minimum", this.rebinListener);
            yAxis.addPropertyChangeListener("maximum", this.rebinListener);
            yAxis.addPropertyChangeListener("log", this.rebinListener);
        }
        if (yAxis != oldValue) {
            this.firePropertyChange("yAxis", oldValue, yAxis);
        }
    }

    protected void drawInvalid() {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            return;
        }
        g.translate(-this.getX(), -this.getY());
        Rectangle r = DasRow.toRectangle(this.getRow(), this.getColumn());
        --r.width;
        --r.height;
        ++r.y;
        g.setColor(new Color(245, 245, 245, 220));
        g.fill(r);
        g.dispose();
    }

    protected void updateImmediately() {
        if (this.dataSetDescriptor != null) {
            this.loadDataSet();
        }
        for (int i = 0; i < this.renderers.size(); ++i) {
            Renderer rend = (Renderer)this.renderers.get(i);
            rend.update();
        }
    }

    protected void loadDataSet() {
        final Container parent = this.getParent();
        final Cursor cursor0 = null;
        if (parent != null) {
            parent.getCursor();
            parent.setCursor(new Cursor(3));
        }
        if (parent != null) {
            ((DasCanvas)parent).lockDisplay(this);
        }
        Datum dataRange1 = this.getXAxis().getDataMaximum().subtract(this.getXAxis().getDataMinimum());
        double dataRange = dataRange1.doubleValue(Units.seconds);
        double deviceRange = Math.floor((double)this.getColumn().getDMaximum() + 0.5) - Math.floor((double)this.getColumn().getDMinimum() + 0.5);
        double resolution = dataRange / deviceRange;
        if (this.progressPanel == null) {
            this.progressPanel = DasProgressPanel.createComponentPanel(this, "loading data set");
        }
        DataRequestor requestor = new DataRequestor(){

            public void exception(Exception exception) {
                if (!(exception instanceof InterruptedIOException)) {
                    DasExceptionHandler.handle(exception);
                    this.finished(null);
                }
            }

            public void finished(DataSet ds) {
                DasPlot.this.progressPanel.setVisible(false);
                if (parent != null) {
                    parent.setCursor(cursor0);
                }
                DasPlot.this.Data = ds;
                try {
                    DasPlot.this.updatePlotImage();
                }
                catch (DasException de) {
                    DasExceptionHandler.handle(de);
                }
                if (parent != null) {
                    ((DasCanvas)parent).freeDisplay(this);
                }
            }
        };
        if (this.drt == null) {
            this.drt = new DataRequestThread();
        }
        try {
            this.drt.request(this.dataSetDescriptor, this.xAxis.getDataMinimum(), this.xAxis.getDataMaximum(), Datum.create(resolution, Units.seconds), requestor, this.progressPanel);
            try {
                this.updatePlotImage();
            }
            catch (DasException de) {
                DasExceptionHandler.handle(de);
            }
        }
        catch (InterruptedException ie) {
            DasExceptionHandler.handle(ie);
        }
    }

    protected void updatePlotImage() throws DasException {
    }

    protected void paintComponent(Graphics graphics1) {
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        int xSize = this.getColumn().getDMaximum() - x;
        int ySize = this.getRow().getDMaximum() - y;
        Rectangle clip = graphics1.getClipBounds();
        if (clip.y + this.getY() >= y + ySize) {
            return;
        }
        Graphics2D graphics = (Graphics2D)graphics1;
        graphics.setRenderingHints(DasProperties.getRenderingHints());
        graphics.translate(-this.getX(), -this.getY());
        Graphics2D plotGraphics = (Graphics2D)graphics.create(x - 1, y - 1, xSize + 2, ySize + 2);
        plotGraphics.translate(-x + 1, -y + 1);
        this.drawContent(plotGraphics);
        for (int i = 0; i < this.renderers.size(); ++i) {
            Renderer rend = (Renderer)this.renderers.get(i);
            rend.render(plotGraphics, this.xAxis, this.yAxis);
        }
        graphics.setColor(this.getForeground());
        graphics.drawRect(x - 1, y - 1, xSize + 1, ySize + 1);
        if (this.plotTitle != null && this.plotTitle.length() != 0) {
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setAlignment(1);
            gtr.setString(this, this.plotTitle);
            int titleWidth = (int)gtr.getWidth();
            int titleX = x + (xSize - titleWidth) / 2;
            int titleY = y - (int)gtr.getDescent() - (int)gtr.getAscent() / 2;
            gtr.draw(graphics, titleX, titleY);
        }
    }

    protected void drawContent(Graphics2D g) {
        if (this.plotImage != null) {
            int x = this.getColumn().getDMinimum();
            int y = this.getRow().getDMinimum();
            g.drawImage(this.plotImage, x, y + 1, this);
        }
    }

    public void resize() {
        if (this.isDisplayable()) {
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString(this, this.getTitle());
            int titleHeight = (int)gtr.getHeight() + (int)gtr.getAscent() / 2;
            Rectangle bounds = new Rectangle();
            bounds.x = this.getColumn().getDMinimum() - 1;
            bounds.y = this.getRow().getDMinimum() - 1;
            bounds.width = this.getColumn().getDMaximum() - bounds.x + 1;
            bounds.height = this.getRow().getDMaximum() - bounds.y + 1;
            if (!this.getTitle().equals("")) {
                bounds.y -= titleHeight;
                bounds.height += titleHeight;
            }
            this.setBounds(bounds);
        }
    }

    public void setTitle(String t) {
        String oldValue = this.plotTitle;
        this.plotTitle = t;
        if (this.getCanvas() != null) {
            FontMetrics fm = this.getFontMetrics(this.getCanvas().getFont());
            int titleHeight = fm.getHeight() + fm.getHeight() / 2;
            this.resize();
            this.repaint(0, 0, this.getWidth(), titleHeight);
        }
        if (t != oldValue) {
            this.firePropertyChange("title", oldValue, t);
        }
    }

    public String getTitle() {
        return this.plotTitle;
    }

    public DasAxis getXAxis() {
        return this.xAxis;
    }

    public DasAxis getYAxis() {
        return this.yAxis;
    }

    public DataSetDescriptor getDataSetDescriptor() {
        return this.dataSetDescriptor;
    }

    public void setDataSetDescriptor(DataSetDescriptor dataSetDescriptor) {
        this.dataSetDescriptor = dataSetDescriptor;
        this.markDirty();
    }

    public void setData(DataSet ds) {
        this.Data = ds;
        this.markDirty();
    }

    protected void installComponent() {
        super.installComponent();
        if (this.xAxis != null) {
            this.getCanvas().add(this.xAxis, this.getRow(), this.getColumn());
        }
        if (this.yAxis != null) {
            this.getCanvas().add(this.yAxis, this.getRow(), this.getColumn());
        }
        Renderer[] r = this.getRenderers();
        for (int index = 0; index < r.length; ++index) {
            r[index].installRenderer();
        }
        if (!"true".equals(System.getProperty("java.awt.headless"))) {
            this.dndSupport = new PlotDnDSupport(this.getCanvas().dndSupport);
        }
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
        if (this.xAxis != null) {
            this.xAxis.getCanvas().remove(this.xAxis);
        }
        if (this.yAxis != null) {
            this.yAxis.getCanvas().remove(this.yAxis);
        }
        Renderer[] r = this.getRenderers();
        for (int index = 0; index < r.length; ++index) {
            r[index].uninstallRenderer();
        }
    }

    public void addRenderer(Renderer rend) {
        DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("addRenderer(" + rend + ")");
        if (rend.parent != null) {
            rend.parent.removeRenderer(rend);
        }
        this.renderers.add(rend);
        rend.parent = this;
        if (this.getCanvas() != null) {
            rend.installRenderer();
        }
        rend.update();
        this.markDirty();
        this.repaint();
    }

    public void removeRenderer(Renderer rend) {
        if (this.getCanvas() != null) {
            rend.uninstallRenderer();
        }
        this.renderers.remove(rend);
        rend.parent = null;
    }

    public static DasPlot createDummyPlot() {
        DasAxis xAxis = new DasAxis(Datum.create(-10), Datum.create(10), 2);
        DasAxis yAxis = new DasAxis(Datum.create(-10), Datum.create(10), 3);
        DasPlot result = new DasPlot(xAxis, yAxis);
        return result;
    }

    public Renderer getRenderer(int index) {
        return (Renderer)this.renderers.get(index);
    }

    public Renderer[] getRenderers() {
        return this.renderers.toArray(new Renderer[0]);
    }

    public static DasPlot processPlotElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        String name = element.getAttribute("name");
        DasRow row = (DasRow)form.checkValue(element.getAttribute("row"), class$edu$uiowa$physics$pw$das$graph$DasRow == null ? (class$edu$uiowa$physics$pw$das$graph$DasRow = DasPlot.class$("edu.uiowa.physics.pw.das.graph.DasRow")) : class$edu$uiowa$physics$pw$das$graph$DasRow, "<row>");
        DasColumn column = (DasColumn)form.checkValue(element.getAttribute("column"), class$edu$uiowa$physics$pw$das$graph$DasColumn == null ? (class$edu$uiowa$physics$pw$das$graph$DasColumn = DasPlot.class$("edu.uiowa.physics.pw.das.graph.DasColumn")) : class$edu$uiowa$physics$pw$das$graph$DasColumn, "<column>");
        DasAxis xAxis = null;
        DasAxis yAxis = null;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            if (node.getNodeName().equals("xAxis")) {
                xAxis = DasPlot.processXAxisElement((Element)node, row, column, form);
                continue;
            }
            if (!node.getNodeName().equals("yAxis")) continue;
            yAxis = DasPlot.processYAxisElement((Element)node, row, column, form);
        }
        if (xAxis == null) {
            xAxis = (DasAxis)form.checkValue(element.getAttribute("xAxis"), class$edu$uiowa$physics$pw$das$graph$DasAxis == null ? (class$edu$uiowa$physics$pw$das$graph$DasAxis = DasPlot.class$("edu.uiowa.physics.pw.das.graph.DasAxis")) : class$edu$uiowa$physics$pw$das$graph$DasAxis, "<axis> or <timeaxis>");
        }
        if (yAxis == null) {
            yAxis = (DasAxis)form.checkValue(element.getAttribute("yAxis"), class$edu$uiowa$physics$pw$das$graph$DasAxis == null ? (class$edu$uiowa$physics$pw$das$graph$DasAxis = DasPlot.class$("edu.uiowa.physics.pw.das.graph.DasAxis")) : class$edu$uiowa$physics$pw$das$graph$DasAxis, "<axis> or <timeaxis>");
        }
        DasPlot plot = new DasPlot(xAxis, yAxis);
        plot.setTitle(element.getAttribute("title"));
        plot.setDasName(name);
        plot.setRow(row);
        plot.setColumn(column);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, plot);
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("renderers")) continue;
            DasPlot.processRenderersElement((Element)node, plot, form);
        }
        return plot;
    }

    private static DasAxis processXAxisElement(Element element, DasRow row, DasColumn column, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (node.getNodeName().equals("axis")) {
                DasAxis axis = DasAxis.processAxisElement(e, form);
                if (!axis.isHorizontal()) {
                    axis.setOrientation(2);
                }
                return axis;
            }
            if (node.getNodeName().equals("timeaxis")) {
                DasAxis axis = DasAxis.processTimeaxisElement(e, form);
                if (!axis.isHorizontal()) {
                    axis.setOrientation(2);
                }
                return axis;
            }
            if (!node.getNodeName().equals("attachedaxis")) continue;
            DasAxis axis = DasAxis.processAttachedaxisElement(e, form);
            if (!axis.isHorizontal()) {
                axis.setOrientation(2);
            }
            return axis;
        }
        return null;
    }

    private static DasAxis processYAxisElement(Element element, DasRow row, DasColumn column, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (node.getNodeName().equals("axis")) {
                DasAxis axis = DasAxis.processAxisElement(e, form);
                if (axis.isHorizontal()) {
                    axis.setOrientation(3);
                }
                return axis;
            }
            if (node.getNodeName().equals("timeaxis")) {
                DasAxis axis = DasAxis.processTimeaxisElement(e, form);
                if (axis.isHorizontal()) {
                    axis.setOrientation(3);
                }
                return axis;
            }
            if (!node.getNodeName().equals("attachedaxis")) continue;
            DasAxis axis = DasAxis.processAttachedaxisElement(e, form);
            if (axis.isHorizontal()) {
                axis.setOrientation(3);
            }
            return axis;
        }
        return null;
    }

    private static void processRenderersElement(Element element, DasPlot parent, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node node = children.item(index);
            if (!(node instanceof Element)) continue;
            if (node.getNodeName().equals("spectrogram")) {
                parent.addRenderer(SpectrogramRenderer.processSpectrogramElement((Element)node, parent, form));
                continue;
            }
            if (!node.getNodeName().equals("lineplot")) continue;
            parent.addRenderer(SymbolLineRenderer.processLinePlotElement((Element)node, parent, form));
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("plot");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("title", this.getTitle());
        Element xAxisChild = document.createElement("xAxis");
        Element xAxisElement = this.getXAxis().getDOMElement(document);
        xAxisElement.removeAttribute("orientation");
        if (xAxisElement.getAttribute("row").equals(this.getRow().getDasName())) {
            xAxisElement.removeAttribute("row");
        }
        if (xAxisElement.getAttribute("column").equals(this.getColumn().getDasName())) {
            xAxisElement.removeAttribute("column");
        }
        xAxisChild.appendChild(xAxisElement);
        element.appendChild(xAxisChild);
        Element yAxisChild = document.createElement("yAxis");
        Element yAxisElement = this.getYAxis().getDOMElement(document);
        yAxisElement.removeAttribute("orientation");
        if (yAxisElement.getAttribute("row").equals(this.getRow().getDasName())) {
            yAxisElement.removeAttribute("row");
        }
        if (yAxisElement.getAttribute("column").equals(this.getColumn().getDasName())) {
            yAxisElement.removeAttribute("column");
        }
        yAxisChild.appendChild(yAxisElement);
        element.appendChild(yAxisChild);
        Renderer[] renderers = this.getRenderers();
        if (renderers.length > 0) {
            Element renderersChild = document.createElement("renderers");
            for (int index = 0; index < renderers.length; ++index) {
                renderersChild.appendChild(renderers[index].getDOMElement(document));
            }
            element.appendChild(renderersChild);
        }
        return element;
    }

    public static DasPlot createNamedPlot(String name) {
        DasAxis xAxis = DasAxis.createNamedAxis(null);
        xAxis.setOrientation(2);
        DasAxis yAxis = DasAxis.createNamedAxis(null);
        yAxis.setOrientation(3);
        DasPlot plot = new DasPlot(xAxis, yAxis);
        if (name == null) {
            name = "plot_" + Integer.toHexString(System.identityHashCode(plot));
        }
        try {
            plot.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle(dne);
        }
        return plot;
    }

    public DasProgressMonitor getDasProgressMonitor() {
        return this.progressPanel;
    }

    public Shape getActiveRegion() {
        return this.getBounds();
    }

    protected AWTEvent coalesceEvents(AWTEvent existingEvent, AWTEvent newEvent) {
        if (existingEvent instanceof DasRendererUpdateEvent && newEvent instanceof DasRendererUpdateEvent) {
            DasRendererUpdateEvent e1 = (DasRendererUpdateEvent)existingEvent;
            DasRendererUpdateEvent e2 = (DasRendererUpdateEvent)newEvent;
            if (e1.getRenderer() == e2.getRenderer()) {
                return existingEvent;
            }
            return null;
        }
        return super.coalesceEvents(existingEvent, newEvent);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof DasRendererUpdateEvent) {
            DasRendererUpdateEvent drue = (DasRendererUpdateEvent)e;
            drue.getRenderer().updateImmediately();
            this.repaint();
        } else {
            super.processEvent(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PlotDnDSupport
    extends DnDSupport {
        PlotDnDSupport(DnDSupport parent) {
            super(DasPlot.this, 3, parent);
        }

        public void drop(DropTargetDropEvent dtde) {
        }

        protected int canAccept(DataFlavor[] flavors, int x, int y, int action) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(TransferableRenderer.RENDERER_FLAVOR)) continue;
                return action;
            }
            return -1;
        }

        protected void done() {
        }

        protected boolean importData(Transferable t, int x, int y, int action) {
            boolean success = false;
            try {
                Renderer r = (Renderer)t.getTransferData(TransferableRenderer.RENDERER_FLAVOR);
                DasPlot.this.addRenderer(r);
                DasPlot.this.revalidate();
                success = true;
            }
            catch (UnsupportedFlavorException ufe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return success;
        }

        protected Transferable getTransferable(int x, int y, int action) {
            return null;
        }

        protected void exportDone(Transferable t, int action) {
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            DasPlot.this.markDirty();
            DasPlot.this.update();
        }
    }
}

