/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.DataRequestThread;
import edu.uiowa.physics.pw.das.dataset.DataRequestor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumUtil;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.DefaultDatumFormatterFactory;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.event.HorizontalRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener;
import edu.uiowa.physics.pw.das.event.VerticalRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasDevicePosition;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.DataRange;
import edu.uiowa.physics.pw.das.graph.TickVDescriptor;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasMath;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InterruptedIOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasAxis
extends DasCanvasComponent
implements DataRangeSelectionListener,
TimeRangeSelectionListener,
Cloneable {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int UP = 995;
    public static final int DOWN = 996;
    private static final String SCAN_PREVIOUS_LABEL = "<< scan";
    private static final String SCAN_NEXT_LABEL = "scan >>";
    protected DataRange dataRange;
    private int orientation;
    private int tickDirection = 1;
    protected String axisLabel = "";
    protected TickVDescriptor tickV;
    private boolean ticksVisible = true;
    private boolean tickLabelsVisible = true;
    private boolean oppositeAxisVisible;
    protected DatumFormatter datumFormatter = DefaultDatumFormatterFactory.getInstance().defaultFormatter();
    private MouseModule zoom = null;
    private PropertyChangeListener dataRangePropertyListener;
    protected JPanel primaryInputPanel;
    protected JPanel secondaryInputPanel;
    private ScanButton scanPrevious;
    private ScanButton scanNext;
    private boolean animated = "on".equals(DasProperties.getInstance().get("visualCues"));
    private Rectangle blLineRect;
    private Rectangle trLineRect;
    private Rectangle blTickRect;
    private Rectangle trTickRect;
    private Rectangle blLabelRect;
    private Rectangle trLabelRect;
    private Rectangle blTitleRect;
    private Rectangle trTitleRect;
    private EventListenerList timeRangeListenerList = null;
    private TimeRangeSelectionEvent lastProcessedEvent = null;
    private DataSetDescriptor dsd;
    private VectorDataSet[] tcaData = new VectorDataSet[0];
    private String dataset = "";
    private boolean drawTca;
    private DataRequestThread drt;
    private static final boolean DEBUG_GRAPHICS = false;
    private static final Color[] DEBUG_COLORS = null;
    private int debugColorIndex = 0;
    private static final Pattern pattern = Pattern.compile("\\([eEfF]\\d+.\\d+\\)");
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasRow;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasColumn;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasAxis;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener;

    public static DasAxis create(double[] data, Units units, int orientation, boolean isLog) {
        DasAxis result = new DasAxis(Datum.create(0, units), Datum.create(0, units), orientation, isLog);
        result.setDataRange(data);
        return result;
    }

    public DasAxis(Datum min, Datum max, int orientation) {
        this(min, max, orientation, false);
    }

    public DasAxis(Datum min, Datum max, int orientation, boolean log) {
        this(orientation);
        this.dataRange = new DataRange(this, min, max, log);
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
    }

    protected DasAxis(DataRange range, int orientation) {
        this(orientation);
        this.dataRange = range;
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
    }

    public DasAxis(DatumRange range, int orientation) {
        this(range.min(), range.max(), orientation);
    }

    private DasAxis(int orientation) {
        this.setOpaque(false);
        this.setOrientationInternal(orientation);
        this.installMouseModules();
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            JMenuItem backMenuItem = new JMenuItem("Back");
            backMenuItem.addActionListener(this.createActionListener());
            backMenuItem.setActionCommand("back");
            backMenuItem.setToolTipText("undo last operation");
            this.mouseAdapter.addMenuItem(backMenuItem);
        }
        this.dataRangePropertyListener = this.createDataRangePropertyListener();
        this.setLayout(new AxisLayoutManager());
        this.maybeInitializeInputPanels();
        this.maybeInitializeScanButtons();
        this.add(this.primaryInputPanel);
        this.add(this.secondaryInputPanel);
    }

    private void maybeInitializeInputPanels() {
        if (this.primaryInputPanel == null) {
            this.primaryInputPanel = new JPanel();
            this.primaryInputPanel.setOpaque(false);
        }
        if (this.secondaryInputPanel == null) {
            this.secondaryInputPanel = new JPanel();
            this.secondaryInputPanel.setOpaque(false);
        }
    }

    private void maybeInitializeScanButtons() {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.scanPrevious = new ScanButton(SCAN_PREVIOUS_LABEL);
            this.scanNext = new ScanButton(SCAN_NEXT_LABEL);
            ActionListener al = this.createScanActionListener();
            this.scanPrevious.addActionListener(al);
            this.scanNext.addActionListener(al);
            this.add(this.scanPrevious);
            this.add(this.scanNext);
        }
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.equals("back")) {
                    DasAxis.this.setDataRangePrev();
                }
            }
        };
    }

    private ActionListener createScanActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.equals(DasAxis.SCAN_PREVIOUS_LABEL)) {
                    DasAxis.this.scanPrevious();
                } else if (command.equals(DasAxis.SCAN_NEXT_LABEL)) {
                    DasAxis.this.scanNext();
                }
            }
        };
    }

    private PropertyChangeListener createDataRangePropertyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                Object oldValue = e.getOldValue();
                Object newValue = e.getNewValue();
                if (propertyName.equals("log")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("log", oldValue, newValue);
                } else if (propertyName.equals("minimum")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("dataMinimum", oldValue, newValue);
                } else if (propertyName.equals("maximum")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("dataMaximum", oldValue, newValue);
                }
                DasAxis.this.markDirty();
            }
        };
    }

    private void installMouseModules() {
        if (this.zoom instanceof HorizontalRangeSelectorMouseModule) {
            ((HorizontalRangeSelectorMouseModule)this.zoom).removeDataRangeSelectionListener(this);
            this.mouseAdapter.removeMouseModule(this.zoom);
        } else if (this.zoom instanceof VerticalRangeSelectorMouseModule) {
            ((VerticalRangeSelectorMouseModule)this.zoom).removeDataRangeSelectionListener(this);
            this.mouseAdapter.removeMouseModule(this.zoom);
        }
        if (this.isHorizontal()) {
            this.zoom = new HorizontalRangeSelectorMouseModule(this, this);
            ((HorizontalRangeSelectorMouseModule)this.zoom).addDataRangeSelectionListener(this);
            this.mouseAdapter.addMouseModule(this.zoom);
            this.mouseAdapter.setPrimaryModule(this.zoom);
        } else {
            this.zoom = new VerticalRangeSelectorMouseModule(this, this);
            ((VerticalRangeSelectorMouseModule)this.zoom).addDataRangeSelectionListener(this);
            this.mouseAdapter.addMouseModule(this.zoom);
            this.mouseAdapter.setPrimaryModule(this.zoom);
        }
    }

    public void setOrientation(int orientation) {
        boolean oldIsHorizontal = this.isHorizontal();
        this.setOrientationInternal(orientation);
        if (oldIsHorizontal != this.isHorizontal()) {
            this.installMouseModules();
        }
    }

    private void setOrientationInternal(int orientation) {
        this.orientation = orientation;
        if (orientation == 1) {
            this.setTickDirection(995);
        } else if (orientation == 2) {
            this.setTickDirection(996);
        } else if (orientation == 3) {
            this.setTickDirection(4);
        } else if (orientation == 4) {
            this.setTickDirection(3);
        } else {
            throw new IllegalArgumentException("Invalid value for orientation");
        }
    }

    public void setDatumRange(DatumRange dr) {
        this.setDataRange(dr.min(), dr.max());
    }

    public DatumRange getDatumRange() {
        return new DatumRange(this.getDataMinimum(), this.getDataMaximum());
    }

    public void setDataRange(Datum minimum, Datum maximum) {
        double max;
        double min;
        if (!maximum.gt(minimum)) {
            DasDie.println(DasDie.CRITICAL, "setDataRange where min => max ignored");
            return;
        }
        Units units = this.dataRange.getUnits();
        if (minimum.getUnits() != units) {
            minimum.convertTo(units);
            maximum.convertTo(units);
        }
        double min0 = this.dataRange.getMinimum();
        double max0 = this.dataRange.getMaximum();
        if (this.dataRange.isLog()) {
            min = DasMath.log10(minimum.doubleValue(this.getUnits()));
            max = DasMath.log10(maximum.doubleValue(this.getUnits()));
        } else {
            min = minimum.doubleValue(this.getUnits());
            max = maximum.doubleValue(this.getUnits());
        }
        this.animateChange(min0, max0, min, max);
        this.dataRange.setRange(min, max);
        this.update();
        this.createAndFireRangeSelectionEvent();
    }

    public void clearHistory() {
        this.dataRange.clearHistory();
    }

    private void createAndFireRangeSelectionEvent() {
        if (this.getUnits() instanceof TimeLocationUnits) {
            TimeRangeSelectionEvent e = new TimeRangeSelectionEvent(this, new DatumRange(this.getDataMinimum(), this.getDataMaximum()));
            this.fireTimeRangeSelectionListenerTimeRangeSelected(e);
        }
    }

    public void setDataRange(double[] data) {
        double min = data[0];
        double max = data[0];
        for (int i = 1; i < data.length; ++i) {
            min = min < data[i] ? min : data[i];
            max = max > data[i] ? max : data[i];
        }
        double range = max - min;
        if (this.isLog()) {
            this.setDataRange(Datum.create(min, this.getUnits()), Datum.create(max, this.getUnits()));
        } else {
            Datum minDatum = Datum.create(min - range * 0.05, this.getUnits());
            Datum maxDatum = Datum.create(max + range * 0.05, this.getUnits());
            this.setDataRange(minDatum, maxDatum);
        }
    }

    public void setDataRangePrev() {
        double min0 = this.dataRange.getMinimum();
        double max0 = this.dataRange.getMaximum();
        this.dataRange.setRangePrev();
        double min1 = this.dataRange.getMinimum();
        double max1 = this.dataRange.getMaximum();
        this.animateChange(min0, max0, min1, max1);
        this.update();
        this.createAndFireRangeSelectionEvent();
    }

    public void setDataRangeForward() {
        double min0 = this.dataRange.getMinimum();
        double max0 = this.dataRange.getMaximum();
        this.dataRange.setRangeForward();
        double min1 = this.dataRange.getMinimum();
        double max1 = this.dataRange.getMaximum();
        this.animateChange(min0, max0, min1, max1);
        this.update();
        this.createAndFireRangeSelectionEvent();
    }

    public void setDataRangeZoomOut() {
        double t1 = this.dataRange.getMinimum();
        double t2 = this.dataRange.getMaximum();
        double delta = t2 - t1;
        double min = t1 - delta / 2.0;
        double max = t2 + delta / 2.0;
        this.animateChange(t1, t2, min, max);
        this.dataRange.setRange(min, max);
    }

    public DataRange getDataRange() {
        return this.dataRange;
    }

    protected void deviceRangeChanged() {
    }

    public Datum getDataMinimum() {
        double dd = this.dataRange.isLog() ? DasMath.exp10(this.dataRange.getMinimum()) : this.dataRange.getMinimum();
        Datum result = Datum.create(dd, this.dataRange.getUnits());
        return result;
    }

    public Datum getDataMaximum() {
        double dd = this.dataRange.isLog() ? DasMath.exp10(this.dataRange.getMaximum()) : this.dataRange.getMaximum();
        Datum result = Datum.create(dd, this.dataRange.getUnits());
        return result;
    }

    public DatumRange getRange() {
        return new DatumRange(this.getDataMinimum(), this.getDataMaximum());
    }

    public double getDataMaximum(Units units) {
        return this.getDataMaximum().doubleValue(units);
    }

    public double getDataMinimum(Units units) {
        return this.getDataMinimum().doubleValue(units);
    }

    public void setDataMaximum(Datum max) {
        double dd = max.doubleValue(this.getUnits());
        this.dataRange.setMaximum(this.dataRange.isLog() ? DasMath.log10(dd) : dd);
        this.update();
    }

    public void setDataMinimum(Datum min) {
        double dd = min.doubleValue(this.getUnits());
        this.dataRange.setMinimum(this.dataRange.isLog() ? DasMath.log10(dd) : dd);
        this.update();
    }

    public boolean isLog() {
        return this.dataRange.isLog();
    }

    public void setLog(boolean log) {
        boolean oldLog = this.isLog();
        this.dataRange.setLog(log);
        this.update();
        if (log != oldLog) {
            this.firePropertyChange("log", oldLog, log);
        }
    }

    public Units getUnits() {
        return this.dataRange.getUnits();
    }

    public void setUnits(Units newUnits) {
        this.dataRange.setUnits(newUnits);
    }

    public void resetRange(DatumRange range) {
        this.dataRange.resetRange(range);
        this.update();
    }

    public void setOppositeAxisVisible(boolean visible) {
        if (visible == this.oppositeAxisVisible) {
            return;
        }
        boolean oldValue = this.oppositeAxisVisible;
        this.oppositeAxisVisible = visible;
        this.revalidate();
        this.repaint();
        this.firePropertyChange("oppositeAxisVisible", oldValue, visible);
    }

    public boolean isOppositeAxisVisible() {
        return this.oppositeAxisVisible;
    }

    public void setLabel(String t) {
        if (t == null) {
            throw new NullPointerException("axis label cannot be null");
        }
        String oldValue = this.axisLabel;
        this.axisLabel = t;
        this.update();
        this.firePropertyChange("label", oldValue, t);
    }

    public String getLabel() {
        return this.axisLabel;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public boolean getDrawTca() {
        return this.drawTca;
    }

    public void setDrawTca(boolean b) {
        boolean oldValue = this.drawTca;
        if (b && this.getOrientation() != 2) {
            throw new IllegalArgumentException("Vertical time axes cannot have annotations");
        }
        if (this.drawTca == b) {
            return;
        }
        this.drawTca = b;
        this.markDirty();
        this.update();
        this.firePropertyChange("showTca", oldValue, b);
    }

    public String getDataPath() {
        return this.dataset;
    }

    public void setDataPath(String dataset) {
        if (dataset == null) {
            throw new NullPointerException("null dataPath string not allowed");
        }
        String oldValue = this.dataset;
        if (dataset.equals(this.dataset)) {
            return;
        }
        this.dataset = dataset;
        if (dataset.equals("")) {
            this.dsd = null;
        } else {
            try {
                this.dsd = DataSetDescriptor.create(dataset);
            }
            catch (DasException de) {
                DasExceptionHandler.handle(de);
            }
        }
        this.markDirty();
        this.update();
        this.firePropertyChange("dataPath", oldValue, dataset);
    }

    private void updateDataSet() {
        Datum iinterval;
        Datum data_maximum;
        Datum data_minimum;
        if (!this.drawTca || this.dataset.equals("") || this.dsd == null) {
            return;
        }
        double[] tickV = this.getTickV().tickV;
        if (tickV.length == 1) {
            data_minimum = Datum.create(tickV[0], this.getTickV().units);
            data_maximum = Datum.create(tickV[0], this.getTickV().units);
            iinterval = data_maximum.subtract(data_minimum);
        } else {
            data_minimum = Datum.create(tickV[0], this.getTickV().units);
            data_maximum = Datum.create(tickV[tickV.length - 1], this.getTickV().units);
            iinterval = data_maximum.subtract(data_minimum).divide(tickV.length - 1);
        }
        data_maximum = data_maximum.add(iinterval);
        Datum interval = iinterval;
        this.tcaData = null;
        DataRequestor requestor = new DataRequestor(){

            public void currentByteCount(int byteCount) {
            }

            public void totalByteCount(int byteCount) {
            }

            public void exception(Exception exception) {
                if (!(exception instanceof InterruptedIOException)) {
                    if (exception instanceof DasException) {
                        DasExceptionHandler.handle(exception);
                        this.finished(null);
                    } else {
                        Object[] message = new Object[]{"Error reading data set", new JEditorPane("text/html", exception.getMessage())};
                        ((JEditorPane)message[1]).setEditable(false);
                        DasExceptionHandler.handle(exception);
                        this.finished(null);
                    }
                }
            }

            public void finished(DataSet dsFinished) {
                if (dsFinished != null) {
                    VectorDataSet ds = (VectorDataSet)dsFinished;
                    List itemList = (List)ds.getProperty("plane-list");
                    VectorDataSet[] newData = new VectorDataSet[itemList.size()];
                    newData[0] = ds;
                    for (int i = 1; i < itemList.size(); ++i) {
                        newData[i] = (VectorDataSet)ds.getPlanarView((String)itemList.get(i));
                    }
                    DasAxis.access$302(DasAxis.this, newData);
                    DasAxis.this.update();
                }
            }
        };
        if (this.drt == null) {
            this.drt = new DataRequestThread();
        }
        try {
            this.drt.request(this.dsd, data_minimum, data_maximum.add(Datum.create(1.0, Units.seconds)), interval, requestor, null);
        }
        catch (InterruptedException ie) {
            DasExceptionHandler.handle(ie);
        }
    }

    public final int getDevicePosition() {
        if (this.orientation == 2) {
            return this.getRow().getDMaximum();
        }
        if (this.orientation == 1) {
            return this.getRow().getDMinimum();
        }
        if (this.orientation == 3) {
            return this.getColumn().getDMinimum();
        }
        return this.getColumn().getDMaximum();
    }

    public int getDLength() {
        if (this.isHorizontal()) {
            return this.getColumn().getWidth();
        }
        return this.getRow().getHeight();
    }

    public DasAxis getMasterAxis() {
        return this.dataRange.getCreator();
    }

    public void attachTo(DasAxis axis) {
        DataRange oldRange = this.dataRange;
        this.dataRange = axis.dataRange;
        oldRange.removePropertyChangeListener("log", this.dataRangePropertyListener);
        oldRange.removePropertyChangeListener("minimum", this.dataRangePropertyListener);
        oldRange.removePropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
        if (oldRange.isLog() != this.dataRange.isLog()) {
            this.firePropertyChange("log", oldRange.isLog(), this.dataRange.isLog());
        }
        this.firePropertyChange("minimum", oldRange.getMinimum(), this.dataRange.getMinimum());
        this.firePropertyChange("maximum", oldRange.getMaximum(), this.dataRange.getMaximum());
    }

    public void detach() {
        DataRange newRange;
        this.dataRange.removePropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange = newRange = new DataRange(this, Datum.create(this.dataRange.getMinimum(), this.dataRange.getUnits()), Datum.create(this.dataRange.getMaximum(), this.dataRange.getUnits()), this.dataRange.isLog());
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
    }

    public boolean isAttached() {
        return this != this.getMasterAxis();
    }

    public TickVDescriptor getTickV() {
        if (this.tickV == null) {
            this.updateTickV();
        }
        return this.tickV;
    }

    private void updateTickVLog() {
        double min = this.getDataMinimum().doubleValue(this.getUnits());
        double max = this.getDataMaximum().doubleValue(this.getUnits());
        double dMinTick = DasMath.roundNFractionalDigits(DasMath.log10(min), 4);
        int minTick = (int)Math.ceil(dMinTick);
        double dMaxTick = DasMath.roundNFractionalDigits(DasMath.log10(max), 4);
        int maxTick = (int)Math.floor(dMaxTick);
        GrannyTextRenderer idlt = new GrannyTextRenderer();
        idlt.setString(this, "10!U-10");
        int nTicksMax = this.isHorizontal() ? (int)Math.floor((double)this.getColumn().getWidth() / idlt.getWidth()) : (int)Math.floor((double)this.getRow().getHeight() / (idlt.getHeight() * 2.0));
        nTicksMax = nTicksMax < 7 ? nTicksMax : 7;
        this.tickV = TickVDescriptor.bestTickVLogNew(this.getDataMinimum(), this.getDataMaximum(), 3, nTicksMax);
        this.datumFormatter = this.tickV.getFormatter();
    }

    private void updateTickVLinear() {
        int nTicksMax;
        if (this.isHorizontal()) {
            int tickSizePixels = (int)((double)this.getFontMetrics(this.getTickLabelFont()).stringWidth("0.0000") * 1.5);
            int axisSize = this.getColumn().getWidth();
            nTicksMax = axisSize / tickSizePixels;
        } else {
            int tickSizePixels = this.getFontMetrics(this.getTickLabelFont()).getHeight() * 2;
            int axisSize = this.getRow().getHeight();
            nTicksMax = axisSize / tickSizePixels;
        }
        nTicksMax = nTicksMax < 7 ? nTicksMax : 7;
        this.tickV = TickVDescriptor.bestTickVLinear(this.getDataMinimum(), this.getDataMaximum(), 3, nTicksMax);
        this.datumFormatter = this.tickV.getFormatter();
    }

    private void updateTickVTime() {
        int nTicksMax;
        if (this.isHorizontal()) {
            String item;
            FontMetrics fm;
            int width;
            String item2;
            FontMetrics fm2;
            int width2;
            this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 3, 6);
            Datum atick = this.tickV.getMajorTicks().get(0);
            String granny = this.tickV.getFormatter().grannyFormat(atick);
            GrannyTextRenderer idlt = new GrannyTextRenderer();
            idlt.setString(this, granny);
            int tickSizePixels = (int)idlt.getWidth();
            if (this.drawTca && (width2 = (fm2 = this.getFontMetrics(this.getTickLabelFont())).stringWidth(item2 = DasAxis.format(99999.99, "(f8.2)"))) > tickSizePixels) {
                tickSizePixels = width2;
            }
            int axisSize = this.getColumn().getWidth();
            nTicksMax = axisSize / tickSizePixels;
            this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 3, nTicksMax);
            this.datumFormatter = this.tickV.getFormatter();
            atick = this.tickV.getMajorTicks().get(0);
            granny = this.tickV.getFormatter().grannyFormat(atick);
            idlt.setString(this, granny);
            tickSizePixels = (int)idlt.getWidth();
            if (this.drawTca && (width = (fm = this.getFontMetrics(this.getTickLabelFont())).stringWidth(item = DasAxis.format(99999.99, "(f8.2)"))) > tickSizePixels) {
                tickSizePixels = width;
            }
            nTicksMax = axisSize / tickSizePixels;
        } else {
            int tickSizePixels = this.getFontMetrics(this.getTickLabelFont()).getHeight();
            int axisSize = this.getRow().getHeight();
            nTicksMax = axisSize / tickSizePixels;
        }
        nTicksMax = nTicksMax > 1 ? nTicksMax : 2;
        nTicksMax = nTicksMax < 10 ? nTicksMax : 10;
        this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 3, nTicksMax);
        this.datumFormatter = this.tickV.getFormatter();
        this.updateDataSet();
    }

    public void updateTickV() {
        if (this.getUnits() instanceof TimeLocationUnits) {
            this.updateTickVTime();
        } else if (this.dataRange.isLog()) {
            this.updateTickVLog();
        } else {
            this.updateTickVLinear();
        }
    }

    private double pixelSizeData() {
        Units units = this.getUnits();
        return (this.getDataMaximum().doubleValue(units) - this.getDataMinimum().doubleValue(units)) / (double)this.getDLength();
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.translate(-this.getX(), -this.getY());
        if (this.isHorizontal()) {
            this.paintHorizontalAxis(g);
        } else {
            this.paintVerticalAxis(g);
        }
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            clip = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        if (this.drawTca && this.getOrientation() == 2 && this.tcaData != null && this.blLabelRect != null && this.blLabelRect.intersects(clip)) {
            int position = this.getRow().getDMaximum();
            int DMin = this.getColumn().getDMinimum();
            Font tickLabelFont = this.getTickLabelFont();
            FontMetrics tickLabelFontMetrics = this.getFontMetrics(tickLabelFont);
            int tickLength = tickLabelFont.getSize() * 2 / 3;
            int tick_label_gap = tickLabelFontMetrics.stringWidth(" ");
            int lineHeight = tickLabelFont.getSize() + this.getLineSpacing();
            int maxLabelWidth = this.getMaxLabelWidth(tickLabelFontMetrics);
            int baseLine = position + tickLength + tick_label_gap + tickLabelFont.getSize();
            int rightEdge = DMin - tickLabelFontMetrics.stringWidth("0000") - tick_label_gap;
            GrannyTextRenderer idlt = new GrannyTextRenderer();
            for (int i = 0; i < this.tcaData.length; ++i) {
                idlt.setString(this, (String)this.tcaData[i].getProperty("label"));
                int width = (int)Math.floor(idlt.getWidth() + 0.5);
                int leftEdge = rightEdge - width;
                idlt.draw(g, leftEdge, baseLine += lineHeight);
            }
        }
    }

    protected void paintHorizontalAxis(Graphics2D g) {
        int tickLength;
        int tickPosition;
        double tick1;
        int i;
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            clip = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        boolean bottomLine = (this.orientation == 2 || this.oppositeAxisVisible) && this.blLineRect != null && this.blLineRect.intersects(clip);
        boolean bottomTicks = (this.orientation == 2 || this.oppositeAxisVisible) && this.blTickRect != null && this.blTickRect.intersects(clip);
        boolean bottomTickLabels = this.orientation == 2 && this.tickLabelsVisible && this.blLabelRect != null && this.blLabelRect.intersects(clip);
        boolean bottomLabel = this.orientation == 2 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(clip);
        boolean topLine = (this.orientation == 1 || this.oppositeAxisVisible) && this.trLineRect != null && this.trLineRect.intersects(clip);
        boolean topTicks = (this.orientation == 1 || this.oppositeAxisVisible) && this.trTickRect != null && this.trTickRect.intersects(clip);
        boolean topTickLabels = this.orientation == 1 && this.tickLabelsVisible && this.trLabelRect != null && this.trLabelRect.intersects(clip);
        boolean topLabel = this.orientation == 1 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(clip);
        int topPosition = this.getRow().getDMinimum() - 1;
        int bottomPosition = this.getRow().getDMaximum();
        int DMax = this.getColumn().getDMaximum();
        int DMin = this.getColumn().getDMinimum();
        Font labelFont = this.getTickLabelFont();
        double dataMax = this.dataRange.getMaximum();
        double dataMin = this.dataRange.getMinimum();
        TickVDescriptor ticks = this.getTickV();
        double[] tickv = ticks.tickV;
        if (bottomLine) {
            g.drawLine(DMin, bottomPosition, DMax, bottomPosition);
        }
        if (topLine) {
            g.drawLine(DMin, topPosition, DMax, topPosition);
        }
        int tickLengthMajor = labelFont.getSize() * 2 / 3;
        int tickLengthMinor = tickLengthMajor / 2;
        for (i = 0; i < ticks.tickV.length; ++i) {
            tick1 = ticks.tickV[i];
            tickPosition = (int)Math.floor(this.transform(tick1, ticks.units) + 0.5);
            if (DMin > tickPosition || tickPosition > DMax) continue;
            tickLength = tickLengthMajor;
            if (bottomTicks) {
                g.drawLine(tickPosition, bottomPosition, tickPosition, bottomPosition + tickLength);
            }
            if (bottomTickLabels) {
                this.drawLabel(g, tick1, i, tickPosition, bottomPosition + tickLength);
            }
            if (topTicks) {
                g.drawLine(tickPosition, topPosition, tickPosition, topPosition - tickLength);
            }
            if (!topTickLabels) continue;
            this.drawLabel(g, tick1, i, tickPosition, topPosition - tickLength);
        }
        for (i = 0; i < ticks.minorTickV.length; ++i) {
            tick1 = ticks.minorTickV[i];
            tickPosition = (int)Math.floor(this.transform(tick1, ticks.units) + 0.5);
            if (DMin > tickPosition || tickPosition > DMax) continue;
            tickLength = tickLengthMinor;
            if (bottomTicks) {
                g.drawLine(tickPosition, bottomPosition, tickPosition, bottomPosition + tickLength);
            }
            if (!topTicks) continue;
            g.drawLine(tickPosition, topPosition, tickPosition, topPosition - tickLength);
        }
        if (!this.axisLabel.equals("")) {
            int baseline;
            int leftEdge;
            Graphics2D g2 = (Graphics2D)g.create();
            int titlePositionOffset = this.getTitlePositionOffset();
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString(this, this.axisLabel);
            int titleWidth = (int)gtr.getWidth();
            g2.setFont(this.getLabelFont());
            if (bottomLabel) {
                leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                baseline = bottomPosition + titlePositionOffset;
                gtr.draw(g2, leftEdge, baseline);
            }
            if (topLabel) {
                leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                baseline = topPosition - titlePositionOffset;
                gtr.draw(g2, leftEdge, baseline);
            }
            g2.dispose();
        }
    }

    protected void paintVerticalAxis(Graphics2D g) {
        int tickLength;
        int tickPosition;
        double tick1;
        int i;
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            clip = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        boolean leftLine = (this.orientation == 3 || this.oppositeAxisVisible) && this.blLineRect != null && this.blLineRect.intersects(clip);
        boolean leftTicks = (this.orientation == 3 || this.oppositeAxisVisible) && this.blTickRect != null && this.blTickRect.intersects(clip);
        boolean leftTickLabels = this.orientation == 3 && this.tickLabelsVisible && this.blLabelRect != null && this.blLabelRect.intersects(clip);
        boolean leftLabel = this.orientation == 3 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(clip);
        boolean rightLine = (this.orientation == 4 || this.oppositeAxisVisible) && this.trLineRect != null && this.trLineRect.intersects(clip);
        boolean rightTicks = (this.orientation == 4 || this.oppositeAxisVisible) && this.trTickRect != null && this.trTickRect.intersects(clip);
        boolean rightTickLabels = this.orientation == 4 && this.tickLabelsVisible && this.trLabelRect != null && this.trLabelRect.intersects(clip);
        boolean rightLabel = this.orientation == 4 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(clip);
        int leftPosition = this.getColumn().getDMinimum() - 1;
        int rightPosition = this.getColumn().getDMaximum();
        int DMax = this.getRow().getDMaximum();
        int DMin = this.getRow().getDMinimum();
        Font labelFont = this.getTickLabelFont();
        double dataMax = this.dataRange.getMaximum();
        double dataMin = this.dataRange.getMinimum();
        TickVDescriptor ticks = this.getTickV();
        double[] tickv = ticks.tickV;
        if (leftLine) {
            g.drawLine(leftPosition, DMin, leftPosition, DMax);
        }
        if (rightLine) {
            g.drawLine(rightPosition, DMin, rightPosition, DMax);
        }
        int tickLengthMajor = labelFont.getSize() * 2 / 3;
        int tickLengthMinor = tickLengthMajor / 2;
        for (i = 0; i < ticks.tickV.length; ++i) {
            tick1 = ticks.tickV[i];
            tickPosition = (int)Math.floor(this.transform(tick1, ticks.units) + 0.5);
            if (DMin > tickPosition || tickPosition > DMax) continue;
            tickLength = tickLengthMajor;
            if (leftTicks) {
                g.drawLine(leftPosition, tickPosition, leftPosition - tickLength, tickPosition);
            }
            if (leftTickLabels) {
                this.drawLabel(g, tick1, i, leftPosition - tickLength, tickPosition);
            }
            if (rightTicks) {
                g.drawLine(rightPosition, tickPosition, rightPosition + tickLength, tickPosition);
            }
            if (!rightTickLabels) continue;
            this.drawLabel(g, tick1, i, rightPosition + tickLength, tickPosition);
        }
        for (i = 0; i < ticks.minorTickV.length; ++i) {
            tickLength = tickLengthMinor;
            tick1 = ticks.minorTickV[i];
            tickPosition = (int)Math.floor(this.transform(tick1, ticks.units) + 0.5);
            if (DMin > tickPosition || tickPosition > DMax) continue;
            tickLength = tickLengthMinor;
            if (leftTicks) {
                g.drawLine(leftPosition, tickPosition, leftPosition - tickLength, tickPosition);
            }
            if (!rightTicks) continue;
            g.drawLine(rightPosition, tickPosition, rightPosition + tickLength, tickPosition);
        }
        if (!this.axisLabel.equals("")) {
            int baseline;
            int leftEdge;
            Graphics2D g2 = (Graphics2D)g.create();
            int titlePositionOffset = this.getTitlePositionOffset();
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString(this, this.axisLabel);
            int titleWidth = (int)gtr.getWidth();
            g2.setFont(this.getLabelFont());
            if (leftLabel) {
                g2.rotate(-1.5707963267948966);
                leftEdge = -DMax + (DMax - DMin - titleWidth) / 2;
                baseline = leftPosition - titlePositionOffset;
                gtr.draw(g2, leftEdge, baseline);
            }
            if (rightLabel) {
                g2.rotate(1.5707963267948966);
                leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                baseline = -rightPosition - titlePositionOffset;
                gtr.draw(g2, leftEdge, baseline);
            }
            g2.dispose();
        }
    }

    protected int getTitlePositionOffset() {
        Font tickLabelFont = this.getTickLabelFont();
        FontMetrics fm = this.getFontMetrics(tickLabelFont);
        Font labelFont = this.getLabelFont();
        int tickLength = tickLabelFont.getSize() * 2 / 3;
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        gtr.setString(this, this.axisLabel);
        int offset = this.orientation == 2 ? tickLabelFont.getSize() + tickLength + fm.stringWidth(" ") + labelFont.getSize() + labelFont.getSize() / 2 : (this.orientation == 1 ? tickLength + fm.stringWidth(" ") + labelFont.getSize() + labelFont.getSize() / 2 + (int)gtr.getDescent() : (this.orientation == 3 ? tickLength + this.getMaxLabelWidth(fm) + fm.stringWidth(" ") + labelFont.getSize() / 2 + (int)gtr.getDescent() : tickLength + this.getMaxLabelWidth(fm) + fm.stringWidth(" ") + labelFont.getSize() / 2 + (int)gtr.getDescent()));
        if (this.getOrientation() == 2) {
            if (this.drawTca && this.tcaData != null) {
                offset += this.tcaData.length * (tickLabelFont.getSize() + this.getLineSpacing());
            }
            offset += tickLabelFont.getSize() + this.getLineSpacing();
        }
        return offset;
    }

    public int getLineSpacing() {
        return this.getTickLabelFont().getSize() / 4;
    }

    protected void drawLabel(Graphics g, double value, int index, int x, int y) {
        if (!this.tickLabelsVisible) {
            return;
        }
        String label = this.tickFormatter(value);
        g.setFont(this.getTickLabelFont());
        GrannyTextRenderer idlt = new GrannyTextRenderer();
        idlt.setString(this, label);
        int width = (int)idlt.getWidth();
        int height = (int)idlt.getHeight();
        int ascent = (int)idlt.getAscent();
        int tick_label_gap = this.getFontMetrics(this.getTickLabelFont()).stringWidth(" ");
        if (this.orientation == 2) {
            x -= width / 2;
            y += this.getTickLabelFont().getSize() + tick_label_gap;
        } else if (this.orientation == 1) {
            x -= width / 2;
            y = (int)((double)y - ((double)tick_label_gap + idlt.getDescent()));
        } else if (this.orientation == 3) {
            x -= width + tick_label_gap;
            y += ascent - height / 2;
        } else {
            x += tick_label_gap;
            y += ascent - height / 2;
        }
        Color c = g.getColor();
        idlt.draw(g, x, y);
        if (this.orientation == 2 && this.drawTca && this.tcaData != null) {
            this.drawTCAItems(g, index, x, y, width);
        }
    }

    private void drawTCAItems(Graphics g, int index, int x, int y, int width) {
        int height = this.getTickLabelFont().getSize();
        int tick_label_gap = this.getFontMetrics(this.getTickLabelFont()).stringWidth(" ");
        int baseLine = y;
        int leftEdge = x;
        int rightEdge = leftEdge + width;
        Font tickLabelFont = this.getTickLabelFont();
        FontMetrics fm = this.getFontMetrics(tickLabelFont);
        int lineHeight = tickLabelFont.getSize() + this.getLineSpacing();
        for (int i = 0; i < this.tcaData.length; ++i) {
            String item = DasAxis.format(this.tcaData[i].getDouble(index, this.tcaData[i].getYUnits()), "(f8.2)");
            width = fm.stringWidth(item);
            leftEdge = rightEdge - width;
            g.drawString(item, leftEdge, baseLine += lineHeight);
        }
    }

    public Font getTickLabelFont() {
        return this.getFont();
    }

    public void setTickLabelFont(Font tickLabelFont) {
    }

    public Font getLabelFont() {
        return this.getFont();
    }

    public void setLabelFont(Font labelFont) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Assertion failure");
        }
    }

    private void setTickDirection(int direction) {
        if (direction == 995 || direction == 4) {
            this.tickDirection = -1;
        } else if (direction == 996 || direction == 3) {
            this.tickDirection = 1;
        } else {
            throw new IllegalArgumentException("Invalid tick direction");
        }
    }

    protected int getMaxLabelWidth(FontMetrics fm) {
        TickVDescriptor ticks = this.getTickV();
        double[] tickv = ticks.tickV;
        int size = Integer.MIN_VALUE;
        for (int i = 0; i < tickv.length; ++i) {
            String label = this.tickFormatter(tickv[i]);
            GrannyTextRenderer idlt = new GrannyTextRenderer();
            idlt.setString(this, label);
            int labelSize = (int)Math.round(idlt.getWidth());
            if (labelSize <= size) continue;
            size = labelSize;
        }
        return size;
    }

    public void resize() {
        this.setBounds(this.getAxisBounds());
        this.invalidate();
        this.validate();
    }

    protected Rectangle getAxisBounds() {
        Rectangle bounds = this.isHorizontal() ? this.getHorizontalAxisBounds() : this.getVerticalAxisBounds();
        if (this.getOrientation() == 2 && this.areTickLabelsVisible()) {
            if (this.drawTca && this.tcaData != null) {
                int DMin = this.getColumn().getDMinimum();
                int DMax = this.getColumn().getDMaximum();
                Font tickLabelFont = this.getTickLabelFont();
                int tick_label_gap = this.getFontMetrics(tickLabelFont).stringWidth(" ");
                int tcaHeight = (tickLabelFont.getSize() + this.getLineSpacing()) * this.tcaData.length;
                int maxLabelWidth = this.getMaxLabelWidth(this.getFontMetrics(tickLabelFont));
                bounds.height += tcaHeight;
                this.blLabelRect.height += tcaHeight;
                if (this.blTitleRect != null) {
                    this.blTitleRect.y += tcaHeight;
                }
                GrannyTextRenderer idlt = new GrannyTextRenderer();
                idlt.setString(this, "SCET");
                int tcaLabelWidth = (int)Math.floor(idlt.getWidth() + 0.5);
                for (int i = 0; i < this.tcaData.length; ++i) {
                    idlt.setString(this, (String)this.tcaData[i].getProperty("label"));
                    int width = (int)Math.floor(idlt.getWidth() + 0.5);
                    tcaLabelWidth = Math.max(tcaLabelWidth, width);
                }
                if (tcaLabelWidth > 0) {
                    int tcaLabelSpace = DMin - tcaLabelWidth - tick_label_gap;
                    int minX = Math.min(tcaLabelSpace - maxLabelWidth / 2, bounds.x);
                    int maxX = bounds.x + bounds.width;
                    bounds.x = minX;
                    bounds.width = maxX - minX;
                    this.blLabelRect.x = minX;
                    this.blLabelRect.width = maxX - minX;
                }
            }
            bounds.height += this.getTickLabelFont().getSize() + this.getLineSpacing();
            if (this.getTickDirection() == -1) {
                bounds.y -= this.getTickLabelFont().getSize() + this.getLineSpacing();
            }
        }
        return bounds;
    }

    private Rectangle getHorizontalAxisBounds() {
        int height;
        int width;
        int y;
        int x;
        int height2;
        int width2;
        int y2;
        int x2;
        int height3;
        int width3;
        int y3;
        int x3;
        int topPosition = this.getRow().getDMinimum() - 1;
        int bottomPosition = this.getRow().getDMaximum();
        DasColumn range = this.getColumn();
        int DMax = range.getDMaximum();
        int DMin = range.getDMinimum();
        boolean bottomTicks = this.orientation == 2 || this.oppositeAxisVisible;
        boolean bottomTickLabels = this.orientation == 2 && this.tickLabelsVisible;
        boolean bottomLabel = this.orientation == 2 && !this.axisLabel.equals("");
        boolean topTicks = this.orientation == 1 || this.oppositeAxisVisible;
        boolean topTickLabels = this.orientation == 1 && this.tickLabelsVisible;
        boolean topLabel = this.orientation == 1 && !this.axisLabel.equals("");
        Font tickLabelFont = this.getTickLabelFont();
        int tickSize = tickLabelFont.getSize() * 2 / 3;
        if (bottomTicks) {
            if (this.blLineRect == null) {
                this.blLineRect = new Rectangle();
            }
            this.blLineRect.setBounds(DMin, bottomPosition, DMax - DMin + 1, 1);
        }
        if (topTicks) {
            if (this.trLineRect == null) {
                this.trLineRect = new Rectangle();
            }
            this.trLineRect.setBounds(DMin, topPosition, DMax - DMin + 1, 1);
        }
        if (bottomTicks) {
            x3 = DMin;
            y3 = bottomPosition + 1;
            width3 = DMax - DMin;
            height3 = tickSize;
            this.blTickRect = DasAxis.setRectangleBounds(this.blTickRect, x3, y3, width3 + 1, height3);
        }
        if (topTicks) {
            x3 = DMin;
            y3 = topPosition - tickSize;
            width3 = DMax - DMin;
            height3 = tickSize;
            this.trTickRect = DasAxis.setRectangleBounds(this.trTickRect, x3, y3, width3 + 1, height3);
        }
        int maxLabelWidth = this.getMaxLabelWidth(this.getFontMetrics(tickLabelFont));
        int tick_label_gap = this.getFontMetrics(tickLabelFont).stringWidth(" ");
        if (bottomTickLabels) {
            x2 = DMin - maxLabelWidth / 2;
            y2 = this.blTickRect.y + this.blTickRect.height;
            width2 = DMax - DMin + maxLabelWidth;
            height2 = tickLabelFont.getSize() * 3 / 2 + tick_label_gap;
            this.blLabelRect = DasAxis.setRectangleBounds(this.blLabelRect, x2, y2, width2, height2);
        }
        if (topTickLabels) {
            x2 = DMin - maxLabelWidth / 2;
            y2 = topPosition - (tickLabelFont.getSize() * 3 / 2 + tick_label_gap + 1);
            width2 = DMax - DMin + maxLabelWidth;
            height2 = tickLabelFont.getSize() * 3 / 2 + tick_label_gap;
            this.trLabelRect = DasAxis.setRectangleBounds(this.trLabelRect, x2, y2, width2, height2);
        }
        Font labelFont = this.getLabelFont();
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        gtr.setString(this, this.getLabel());
        int labelSpacing = (int)gtr.getHeight() + labelFont.getSize() / 2;
        if (bottomLabel) {
            x = DMin;
            y = this.blLabelRect.y + this.blLabelRect.height;
            width = DMax - DMin;
            height = labelSpacing;
            this.blTitleRect = DasAxis.setRectangleBounds(this.blTitleRect, x, y, width, height);
        }
        if (topLabel) {
            x = DMin;
            y = this.trLabelRect.y - labelSpacing;
            width = DMax - DMin;
            height = labelSpacing;
            this.trTitleRect = DasAxis.setRectangleBounds(this.trTitleRect, x, y, width, height);
        }
        Rectangle bounds = new Rectangle(this.orientation == 2 ? this.blLineRect : this.trLineRect);
        if (bottomTicks) {
            bounds.add(this.blLineRect);
            bounds.add(this.blTickRect);
        }
        if (bottomTickLabels) {
            bounds.add(this.blLabelRect);
        }
        if (bottomLabel) {
            bounds.add(this.blTitleRect);
        }
        if (topTicks) {
            bounds.add(this.trLineRect);
            bounds.add(this.trTickRect);
        }
        if (topTickLabels) {
            bounds.add(this.trLabelRect);
        }
        if (topLabel) {
            bounds.add(this.trTitleRect);
        }
        if (this.scanPrevious != null && this.scanNext != null) {
            Dimension prevSize = this.scanPrevious.getPreferredSize();
            Dimension nextSize = this.scanPrevious.getPreferredSize();
            int minX = Math.min(DMin - prevSize.width, bounds.x);
            int maxX = Math.max(DMax + nextSize.width, bounds.x + bounds.width);
            bounds.x = minX;
            bounds.width = maxX - minX;
        }
        return bounds;
    }

    private Rectangle getVerticalAxisBounds() {
        int height;
        int width;
        int y;
        int x;
        int height2;
        int width2;
        int y2;
        int x2;
        int height3;
        int width3;
        int y3;
        int x3;
        boolean leftTicks = this.orientation == 3 || this.oppositeAxisVisible;
        boolean leftTickLabels = this.orientation == 3 && this.tickLabelsVisible;
        boolean leftLabel = this.orientation == 3 && !this.axisLabel.equals("");
        boolean rightTicks = this.orientation == 4 || this.oppositeAxisVisible;
        boolean rightTickLabels = this.orientation == 4 && this.tickLabelsVisible;
        boolean rightLabel = this.orientation == 4 && !this.axisLabel.equals("");
        int leftPosition = this.getColumn().getDMinimum() - 1;
        int rightPosition = this.getColumn().getDMaximum();
        int DMax = this.getRow().getDMaximum();
        int DMin = this.getRow().getDMinimum();
        Font tickLabelFont = this.getTickLabelFont();
        int tickSize = tickLabelFont.getSize() * 2 / 3;
        if (leftTicks) {
            if (this.blLineRect == null) {
                this.blLineRect = new Rectangle();
            }
            this.blLineRect.setBounds(leftPosition, DMin, 1, DMax - DMin + 1);
        }
        if (rightTicks) {
            if (this.trLineRect == null) {
                this.trLineRect = new Rectangle();
            }
            this.trLineRect.setBounds(rightPosition, DMin, 1, DMax - DMin + 1);
        }
        if (leftTicks) {
            x3 = leftPosition - tickSize;
            y3 = DMin;
            width3 = tickSize;
            height3 = DMax - DMin;
            this.blTickRect = DasAxis.setRectangleBounds(this.blTickRect, x3, y3, width3, height3 + 1);
        }
        if (rightTicks) {
            x3 = rightPosition + 1;
            y3 = DMin;
            width3 = tickSize;
            height3 = DMax - DMin;
            this.trTickRect = DasAxis.setRectangleBounds(this.trTickRect, x3, y3, width3, height3 + 1);
        }
        int maxLabelWidth = this.getMaxLabelWidth(this.getFontMetrics(tickLabelFont));
        int tick_label_gap = this.getFontMetrics(tickLabelFont).stringWidth(" ");
        if (leftTickLabels) {
            x2 = this.blTickRect.x - (maxLabelWidth + tick_label_gap);
            y2 = DMin - tickLabelFont.getSize();
            width2 = maxLabelWidth + tick_label_gap;
            height2 = DMax - DMin + tickLabelFont.getSize() * 2;
            this.blLabelRect = DasAxis.setRectangleBounds(this.blLabelRect, x2, y2, width2, height2);
        }
        if (rightTickLabels) {
            x2 = this.trTickRect.x + this.trTickRect.width;
            y2 = DMin - tickLabelFont.getSize();
            width2 = maxLabelWidth + tick_label_gap;
            height2 = DMax - DMin + tickLabelFont.getSize() * 2;
            this.trLabelRect = DasAxis.setRectangleBounds(this.trLabelRect, x2, y2, width2, height2);
        }
        Font labelFont = this.getLabelFont();
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        gtr.setString(this, this.getLabel());
        int labelSpacing = (int)gtr.getHeight() + labelFont.getSize() / 2;
        if (leftLabel) {
            x = this.blLabelRect.x - labelSpacing;
            y = DMin;
            width = labelSpacing;
            height = DMax - DMin;
            this.blTitleRect = DasAxis.setRectangleBounds(this.blTitleRect, x, y, width, height);
        }
        if (rightLabel) {
            x = this.trLabelRect.x + this.trLabelRect.width;
            y = DMin;
            width = labelSpacing;
            height = DMax - DMin;
            this.trTitleRect = DasAxis.setRectangleBounds(this.trTitleRect, x, y, width, height);
        }
        Rectangle bounds = new Rectangle(this.orientation == 3 ? this.blLineRect : this.trLineRect);
        if (leftTicks) {
            bounds.add(this.blLineRect);
            bounds.add(this.blTickRect);
        }
        if (leftTickLabels) {
            bounds.add(this.blLabelRect);
        }
        if (leftLabel) {
            bounds.add(this.blTitleRect);
        }
        if (rightTicks) {
            bounds.add(this.trLineRect);
            bounds.add(this.trTickRect);
        }
        if (rightTickLabels) {
            bounds.add(this.trLabelRect);
        }
        if (rightLabel) {
            bounds.add(this.trTitleRect);
        }
        return bounds;
    }

    private static Rectangle setRectangleBounds(Rectangle rc, int x, int y, int width, int height) {
        if (rc == null) {
            return new Rectangle(x, y, width, height);
        }
        rc.setBounds(x, y, width, height);
        return rc;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isHorizontal() {
        return this.orientation == 2 || this.orientation == 1;
    }

    public int getTickDirection() {
        return this.tickDirection;
    }

    public DatumFormatter getDatumFormatter() {
        return this.datumFormatter;
    }

    public double transform(Datum datum) {
        return this.transform(datum.doubleValue(this.getUnits()), this.getUnits());
    }

    double transform(double data, Units units) {
        if (this.isHorizontal()) {
            DasColumn range = this.getColumn();
            return this.transform(data, units, range.getDMinimum(), range.getDMaximum());
        }
        DasRow range = this.getRow();
        return this.transform(data, units, range.getDMaximum(), range.getDMinimum());
    }

    double transform(double data, Units units, int dmin, int dmax) {
        double maximum;
        double data_range;
        double minimum;
        double result;
        if (units != this.dataRange.getUnits()) {
            data = units.convertDoubleTo(this.dataRange.getUnits(), data);
        }
        double device_range = dmax - dmin;
        if (this.dataRange.isLog()) {
            data = DasMath.log10(data);
        }
        if ((result = device_range * (data - (minimum = this.dataRange.getMinimum())) / (data_range = (maximum = this.dataRange.getMaximum()) - minimum) + (double)dmin) > 10000.0) {
            result = 10000.0;
        }
        if (result < -10000.0) {
            result = -10000.0;
        }
        return result;
    }

    public Datum invTransform(double idata) {
        DasDevicePosition range = this.isHorizontal() ? this.getColumn() : this.getRow();
        double alpha = (idata - (double)range.getDMinimum()) / (double)this.getDLength();
        if (!this.isHorizontal()) {
            alpha = 1.0 - alpha;
        }
        double minimum = this.dataRange.getMinimum();
        double maximum = this.dataRange.getMaximum();
        double data_range = maximum - minimum;
        double data = data_range * alpha + minimum;
        DatumFormatter formatter = this.dataRange.isLog() ? DatumUtil.limitLogResolutionFormatter(this.getDataMinimum(), this.getDataMaximum(), this.getDLength()) : DatumUtil.limitResolutionFormatter(this.getDataMinimum(), this.getDataMaximum(), this.getDLength());
        if (this.dataRange.isLog()) {
            data = DasMath.exp10(data);
        }
        Datum result = Datum.create(data, this.dataRange.getUnits(), formatter);
        return result;
    }

    protected String tickFormatter(double tickv) {
        return this.datumFormatter.grannyFormat(Datum.create(tickv, this.getUnits()));
    }

    public void DataRangeSelected(DataRangeSelectionEvent e) {
        this.setDataRange(e.getMinimum(), e.getMaximum());
    }

    private Datum findTickLog(Datum xDatum, double direction, boolean minor) {
        double result;
        double x = xDatum.doubleValue(this.tickV.units);
        if (direction > 0.0) {
            result = this.tickV.tickV[this.tickV.tickV.length - 1] * 10.0;
            for (int i = this.tickV.tickV.length - 1; i >= 0; --i) {
                if (!(x < this.tickV.tickV[i])) continue;
                result = this.tickV.tickV[i];
            }
        } else if (direction < 0.0) {
            result = this.tickV.tickV[0] / 10.0;
            for (int i = 0; i < this.tickV.tickV.length; ++i) {
                if (!(x > this.tickV.tickV[i])) continue;
                result = this.tickV.tickV[i];
            }
        } else {
            result = -999.0;
            double closestDistance = Double.MAX_VALUE;
            for (int i = 0; i < this.tickV.tickV.length; ++i) {
                double dist = Math.abs(Math.log(x) - Math.log(this.tickV.tickV[i]));
                if (!(dist < closestDistance)) continue;
                result = this.tickV.tickV[i];
                closestDistance = dist;
            }
        }
        return Datum.create(result, xDatum.getUnits());
    }

    public Datum findTick(Datum xDatum, double direction, boolean minor) {
        int i;
        if (this.tickV == null) {
            return xDatum;
        }
        double[] ticks = new double[this.tickV.tickV.length + this.tickV.minorTickV.length];
        for (i = 0; i < this.tickV.tickV.length; ++i) {
            ticks[i] = this.tickV.tickV[i];
        }
        for (i = 0; i < this.tickV.minorTickV.length; ++i) {
            ticks[i + this.tickV.tickV.length] = this.tickV.minorTickV[i];
        }
        int iclose = 0;
        double close = Double.MAX_VALUE;
        double x = xDatum.doubleValue(this.tickV.units);
        for (int i2 = 0; i2 < ticks.length; ++i2) {
            if (direction < 0.0 && ticks[i2] < x && x - ticks[i2] < close) {
                iclose = i2;
                close = x - ticks[i2];
            } else if (direction > 0.0 && x < ticks[i2] && ticks[i2] - x < close) {
                iclose = i2;
                close = ticks[i2] - x;
            }
            if (direction != 0.0 || !(Math.abs(ticks[i2] - x) < close)) continue;
            iclose = i2;
            close = Math.abs(ticks[i2] - x);
        }
        return Datum.create(ticks[iclose], this.tickV.units);
    }

    private void animateChange(double min0, double max0, double min1, double max1) {
        if (this.animated) {
            DataRange tempRange;
            boolean drawTca0 = this.getDrawTca();
            this.setDrawTca(false);
            long t0 = System.currentTimeMillis();
            DataRange dataRange0 = this.dataRange;
            this.dataRange = tempRange = this.dataRange.getAnimationDataRange();
            double transitionTime = 300.0;
            double alpha = (double)(System.currentTimeMillis() - t0) / transitionTime;
            while (alpha < 1.0) {
                alpha = (double)(System.currentTimeMillis() - t0) / transitionTime;
                double t = -3.0 + 6.0 * alpha;
                double a1 = (DasMath.tanh(t) + 1.0) / 2.0;
                double a0 = 1.0 - a1;
                tempRange.setRange(min0 * a0 + min1 * a1, max0 * a0 + max1 * a1);
                this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            }
            this.setDrawTca(drawTca0);
            this.dataRange = dataRange0;
        }
    }

    protected void updateImmediately() {
        super.updateImmediately();
        this.updateTickV();
    }

    public boolean areTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean b) {
        if (this.tickLabelsVisible == b) {
            return;
        }
        boolean oldValue = this.ticksVisible;
        this.tickLabelsVisible = b;
        this.update();
        this.firePropertyChange("tickLabelsVisible", oldValue, b);
    }

    protected void installComponent() {
        super.installComponent();
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
    }

    static DasAxis processAxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        String columnString;
        Datum dataMaximum;
        Datum dataMinimum;
        String max;
        String min;
        String name = element.getAttribute("name");
        boolean log = element.getAttribute("log").equals("true");
        if ("TIME".equals(element.getAttribute("units"))) {
            min = element.getAttribute("dataMinimum");
            max = element.getAttribute("dataMaximum");
            dataMinimum = min == null || min.equals("") ? TimeUtil.create("1979-02-26") : TimeUtil.create(min);
            dataMaximum = max == null || max.equals("") ? TimeUtil.create("1979-02-27") : TimeUtil.create(max);
        } else {
            min = element.getAttribute("dataMinimum");
            max = element.getAttribute("dataMaximum");
            dataMinimum = min == null || min.equals("") ? Datum.create(1.0) : Datum.create(Double.parseDouble(min));
            dataMaximum = max == null || max.equals("") ? Datum.create(10.0) : Datum.create(Double.parseDouble(max));
        }
        int orientation = DasAxis.parseOrientationString(element.getAttribute("orientation"));
        DasAxis axis = new DasAxis(dataMinimum, dataMaximum, orientation, log);
        String rowString = element.getAttribute("row");
        if (!rowString.equals("")) {
            DasRow row = (DasRow)form.checkValue(rowString, class$edu$uiowa$physics$pw$das$graph$DasRow == null ? (class$edu$uiowa$physics$pw$das$graph$DasRow = DasAxis.class$("edu.uiowa.physics.pw.das.graph.DasRow")) : class$edu$uiowa$physics$pw$das$graph$DasRow, "<row>");
            axis.setRow(row);
        }
        if (!(columnString = element.getAttribute("column")).equals("")) {
            DasColumn column = (DasColumn)form.checkValue(columnString, class$edu$uiowa$physics$pw$das$graph$DasColumn == null ? (class$edu$uiowa$physics$pw$das$graph$DasColumn = DasAxis.class$("edu.uiowa.physics.pw.das.graph.DasColumn")) : class$edu$uiowa$physics$pw$das$graph$DasColumn, "<column>");
            axis.setColumn(column);
        }
        axis.setLabel(element.getAttribute("label"));
        axis.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        axis.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        axis.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, axis);
        return axis;
    }

    protected static String orientationToString(int i) {
        switch (i) {
            case 1: {
                return "top";
            }
            case 2: {
                return "bottom";
            }
            case 3: {
                return "left";
            }
            case 4: {
                return "right";
            }
        }
        throw new IllegalStateException("invalid orienation: " + i);
    }

    protected static int parseOrientationString(String orientationString) {
        if (orientationString.equals("horizontal")) {
            return 2;
        }
        if (orientationString.equals("vertical")) {
            return 3;
        }
        if (orientationString.equals("left")) {
            return 3;
        }
        if (orientationString.equals("right")) {
            return 4;
        }
        if (orientationString.equals("top")) {
            return 1;
        }
        if (orientationString.equals("bottom")) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientationString);
    }

    public Element getDOMElement(Document document) {
        Element element = this.isAttached() ? document.createElement("attachedaxis") : document.createElement("axis");
        if (this.isAttached()) {
            element.setAttribute("ref", this.getMasterAxis().getDasName());
        } else {
            String minimumStr = this.getDataMinimum().toString();
            element.setAttribute("dataMinimum", minimumStr);
            String maximumStr = this.getDataMaximum().toString();
            element.setAttribute("dataMaximum", maximumStr);
        }
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("label", this.getLabel());
        element.setAttribute("log", Boolean.toString(this.isLog()));
        element.setAttribute("tickLabelsVisible", Boolean.toString(this.areTickLabelsVisible()));
        element.setAttribute("oppositeAxisVisible", Boolean.toString(this.isOppositeAxisVisible()));
        element.setAttribute("animated", Boolean.toString(this.isAnimated()));
        element.setAttribute("orientation", DasAxis.orientationToString(this.getOrientation()));
        return element;
    }

    public DasAxis createAttachedAxis() {
        return new DasAxis(this.dataRange, this.getOrientation());
    }

    public DasAxis createAttachedAxis(int orientation) {
        return new DasAxis(this.dataRange, orientation);
    }

    static DasAxis processAttachedaxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException {
        String columnString;
        String name = element.getAttribute("name");
        DasAxis ref = (DasAxis)form.checkValue(element.getAttribute("ref"), class$edu$uiowa$physics$pw$das$graph$DasAxis == null ? (class$edu$uiowa$physics$pw$das$graph$DasAxis = DasAxis.class$("edu.uiowa.physics.pw.das.graph.DasAxis")) : class$edu$uiowa$physics$pw$das$graph$DasAxis, "<attachedaxis>");
        int orientation = element.getAttribute("orientation").equals("horizontal") ? 2 : 3;
        DasAxis axis = ref.createAttachedAxis(orientation);
        String rowString = element.getAttribute("row");
        if (!rowString.equals("")) {
            DasRow row = (DasRow)form.checkValue(rowString, class$edu$uiowa$physics$pw$das$graph$DasRow == null ? (class$edu$uiowa$physics$pw$das$graph$DasRow = DasAxis.class$("edu.uiowa.physics.pw.das.graph.DasRow")) : class$edu$uiowa$physics$pw$das$graph$DasRow, "<row>");
            axis.setRow(row);
        }
        if (!(columnString = element.getAttribute("column")).equals("")) {
            DasColumn column = (DasColumn)form.checkValue(columnString, class$edu$uiowa$physics$pw$das$graph$DasColumn == null ? (class$edu$uiowa$physics$pw$das$graph$DasColumn = DasAxis.class$("edu.uiowa.physics.pw.das.graph.DasColumn")) : class$edu$uiowa$physics$pw$das$graph$DasColumn, "<column>");
            axis.setColumn(column);
        }
        axis.setDataPath(element.getAttribute("dataPath"));
        axis.setDrawTca(element.getAttribute("showTca").equals("true"));
        axis.setLabel(element.getAttribute("label"));
        axis.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        axis.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        axis.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, axis);
        return axis;
    }

    public static DasAxis createNamedAxis(String name) {
        DasAxis axis = new DasAxis(Datum.create(1.0, Units.dimensionless), Datum.create(10.0, Units.dimensionless), 2);
        if (name == null) {
            name = "axis_" + Integer.toHexString(System.identityHashCode(axis));
        }
        try {
            axis.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle(dne);
        }
        return axis;
    }

    public void scanPrevious() {
        Datum delta = this.getDataMaximum().subtract(this.getDataMinimum()).multiply(1.0);
        Datum tmin = this.getDataMinimum().subtract(delta);
        Datum tmax = this.getDataMaximum().subtract(delta);
        this.setDataRange(tmin, tmax);
    }

    public void scanNext() {
        Datum delta = this.getDataMaximum().subtract(this.getDataMinimum()).multiply(1.0);
        Datum tmin = this.getDataMinimum().add(delta);
        Datum tmax = this.getDataMaximum().add(delta);
        this.setDataRange(tmin, tmax);
    }

    public Shape getActiveRegion() {
        Rectangle primaryBounds = this.primaryInputPanel.getBounds();
        primaryBounds.translate(this.getX(), this.getY());
        if (this.oppositeAxisVisible) {
            Rectangle secondaryBounds = this.secondaryInputPanel.getBounds();
            secondaryBounds.translate(this.getX(), this.getY());
            GeneralPath path = new GeneralPath(primaryBounds);
            path.setWindingRule(0);
            path.append(secondaryBounds, false);
            return path;
        }
        return primaryBounds;
    }

    public void addMouseListener(MouseListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseListener(l);
        this.secondaryInputPanel.addMouseListener(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseListener(l);
        this.secondaryInputPanel.removeMouseListener(l);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseMotionListener(l);
        this.secondaryInputPanel.addMouseMotionListener(l);
    }

    public void removeMouseMotionListener(MouseMotionListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseMotionListener(l);
        this.secondaryInputPanel.removeMouseMotionListener(l);
    }

    public void timeRangeSelected(TimeRangeSelectionEvent e) {
        if (e.getSource() != this && !e.equals(this.lastProcessedEvent)) {
            this.setDatumRange(e.getRange());
            this.lastProcessedEvent = e;
            this.fireTimeRangeSelectionListenerTimeRangeSelected(e);
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        if (this.timeRangeListenerList == null) {
            this.timeRangeListenerList = new EventListenerList();
        }
        this.timeRangeListenerList.add(class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener = DasAxis.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener, listener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        this.timeRangeListenerList.remove(class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener = DasAxis.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener, listener);
    }

    private void fireTimeRangeSelectionListenerTimeRangeSelected(TimeRangeSelectionEvent event) {
        if (this.timeRangeListenerList == null) {
            return;
        }
        Object[] listeners = this.timeRangeListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? DasAxis.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener") : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener)) continue;
            DasDie.println("fire event: " + this.getClass().getName() + "-->" + listeners[i + 1].getClass().getName() + " " + event);
            ((TimeRangeSelectionListener)listeners[i + 1]).timeRangeSelected(event);
        }
    }

    static DasAxis processTimeaxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        String columnString;
        String name = element.getAttribute("name");
        Datum timeMinimum = TimeUtil.create(element.getAttribute("timeMinimum"));
        Datum timeMaximum = TimeUtil.create(element.getAttribute("timeMaximum"));
        int orientation = DasAxis.parseOrientationString(element.getAttribute("orientation"));
        DasAxis timeaxis = new DasAxis(timeMinimum, timeMaximum, orientation);
        String rowString = element.getAttribute("row");
        if (!rowString.equals("")) {
            DasRow row = (DasRow)form.checkValue(rowString, class$edu$uiowa$physics$pw$das$graph$DasRow == null ? (class$edu$uiowa$physics$pw$das$graph$DasRow = DasAxis.class$("edu.uiowa.physics.pw.das.graph.DasRow")) : class$edu$uiowa$physics$pw$das$graph$DasRow, "<row>");
            timeaxis.setRow(row);
        }
        if (!(columnString = element.getAttribute("column")).equals("")) {
            DasColumn column = (DasColumn)form.checkValue(columnString, class$edu$uiowa$physics$pw$das$graph$DasColumn == null ? (class$edu$uiowa$physics$pw$das$graph$DasColumn = DasAxis.class$("edu.uiowa.physics.pw.das.graph.DasColumn")) : class$edu$uiowa$physics$pw$das$graph$DasColumn, "<column>");
            timeaxis.setColumn(column);
        }
        timeaxis.setDataPath(element.getAttribute("dataPath"));
        timeaxis.setDrawTca(element.getAttribute("showTca").equals("true"));
        timeaxis.setLabel(element.getAttribute("label"));
        timeaxis.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        timeaxis.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        timeaxis.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, timeaxis);
        return timeaxis;
    }

    private static String format(double d, String f) {
        String result;
        DecimalFormat form;
        int i;
        Matcher m = pattern.matcher(f);
        if (!m.matches()) {
            throw new IllegalArgumentException("\"" + f + "\" is not a valid format specifier");
        }
        int length = Integer.parseInt(f.substring(2, f.indexOf(46)));
        int fracLength = Integer.parseInt(f.substring(f.indexOf(46) + 1, f.indexOf(41)));
        char[] buf = new char[length];
        if (f.charAt(1) == 'f' || f.charAt(1) == 'F') {
            for (i = 0; i < length - fracLength - 2; ++i) {
                buf[i] = 35;
            }
            buf[i] = 48;
            buf[++i] = 46;
            ++i;
            while (i < length) {
                buf[i] = 48;
                ++i;
            }
            form = new DecimalFormat(new String(buf));
            result = form.format(d);
        } else {
            for (i = 0; i < length - fracLength - 6; ++i) {
                buf[i] = 35;
            }
            buf[i] = 48;
            buf[++i] = 46;
            ++i;
            while (i < length - 5) {
                buf[i] = 48;
                ++i;
            }
            buf[i] = 69;
            buf[i + 1] = d > -1.0 && d < 1.0 ? 45 : 43;
            buf[i + 2] = 48;
            buf[i + 3] = 48;
            form = new DecimalFormat(new String(buf));
            result = form.format(d);
        }
        if (result.length() > length) {
            Arrays.fill(buf, '*');
            return new String(buf);
        }
        while (result.length() < length) {
            result = " " + result;
        }
        return result;
    }

    static /* synthetic */ VectorDataSet[] access$302(DasAxis x0, VectorDataSet[] x1) {
        x0.tcaData = x1;
        return x1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ScanButton
    extends JButton {
        private boolean hover;
        private boolean pressed;

        public ScanButton(String text) {
            this.setOpaque(true);
            this.setContentAreaFilled(false);
            this.setText(text);
            this.setFocusable(false);
            this.setBorder(new CompoundBorder(new LineBorder(Color.BLACK), new EmptyBorder(2, 2, 2, 2)));
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ ScanButton this$0;
                {
                    this.this$0 = this$0;
                }

                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        this.this$0.setForeground(Color.LIGHT_GRAY);
                        ScanButton.access$1002(this.this$0, true);
                        this.this$0.repaint();
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        this.this$0.setForeground(Color.BLACK);
                        ScanButton.access$1002(this.this$0, false);
                        this.this$0.repaint();
                    }
                }

                public void mouseEntered(MouseEvent e) {
                    ScanButton.access$1102(this.this$0, true);
                    this.this$0.repaint();
                }

                public void mouseExited(MouseEvent e) {
                    ScanButton.access$1102(this.this$0, false);
                    this.this$0.repaint();
                }
            });
        }

        protected void paintComponent(Graphics g) {
            if (this.hover || this.pressed) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(Color.white);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                Object aaHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                Object aaOn = RenderingHints.VALUE_ANTIALIAS_ON;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaOn);
                super.paintComponent(g2);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
            }
        }

        protected void paintBorder(Graphics g) {
            if (this.hover || this.pressed) {
                super.paintBorder(g);
            }
        }

        static /* synthetic */ boolean access$1002(ScanButton x0, boolean x1) {
            x0.pressed = x1;
            return x0.pressed;
        }

        static /* synthetic */ boolean access$1102(ScanButton x0, boolean x1) {
            x0.hover = x1;
            return x0.hover;
        }
    }

    protected class AxisLayoutManager
    implements LayoutManager {
        protected AxisLayoutManager() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            if (DasAxis.this != parent) {
                throw new IllegalArgumentException();
            }
            if (DasAxis.this.isHorizontal()) {
                this.horizontalLayout();
            } else {
                this.verticalLayout();
            }
            if (DasAxis.this.drawTca && DasAxis.this.getOrientation() == 2 && DasAxis.this.tcaData != null) {
                Rectangle bounds = DasAxis.this.primaryInputPanel.getBounds();
                int tcaHeight = (DasAxis.this.getTickLabelFont().getSize() + DasAxis.this.getLineSpacing()) * DasAxis.this.tcaData.length;
                bounds.height += tcaHeight;
                DasAxis.this.primaryInputPanel.setBounds(bounds);
            }
        }

        protected void horizontalLayout() {
            int topPosition = DasAxis.this.getRow().getDMinimum() - 1;
            int bottomPosition = DasAxis.this.getRow().getDMaximum();
            int DMax = DasAxis.this.getColumn().getDMaximum();
            int DMin = DasAxis.this.getColumn().getDMinimum();
            boolean bottomTicks = DasAxis.this.orientation == 2 || DasAxis.this.oppositeAxisVisible;
            boolean bottomTickLabels = DasAxis.this.orientation == 2 && DasAxis.this.tickLabelsVisible;
            boolean topTicks = DasAxis.this.orientation == 1 || DasAxis.this.oppositeAxisVisible;
            boolean topTickLabels = DasAxis.this.orientation == 1 && DasAxis.this.tickLabelsVisible;
            Rectangle bottomBounds = null;
            Rectangle topBounds = null;
            Font tickLabelFont = DasAxis.this.getTickLabelFont();
            int tickSize = tickLabelFont.getSize() * 2 / 3;
            if (bottomTicks) {
                bottomBounds = new Rectangle(DMin, bottomPosition, DMax - DMin + 1, 1);
            }
            if (topTicks) {
                topBounds = new Rectangle(DMin, topPosition, DMax - DMin + 1, 1);
            }
            if (bottomTicks) {
                bottomBounds.height += tickSize;
            }
            if (topTicks) {
                topBounds.height += tickSize;
                topBounds.y -= tickSize;
            }
            int tick_label_gap = DasAxis.this.getFontMetrics(tickLabelFont).stringWidth(" ");
            if (bottomTickLabels) {
                bottomBounds.height += tickLabelFont.getSize() * 3 / 2 + tick_label_gap;
            }
            if (topTickLabels) {
                topBounds.y -= tickLabelFont.getSize() * 3 / 2 + tick_label_gap;
                topBounds.height += tickLabelFont.getSize() * 3 / 2 + tick_label_gap;
            }
            Rectangle primaryBounds = DasAxis.this.orientation == 2 ? bottomBounds : topBounds;
            Rectangle secondaryBounds = DasAxis.this.orientation == 2 ? topBounds : bottomBounds;
            primaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            if (DasAxis.this.oppositeAxisVisible) {
                secondaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            }
            DasAxis.this.primaryInputPanel.setBounds(primaryBounds);
            if (DasAxis.this.oppositeAxisVisible) {
                DasAxis.this.secondaryInputPanel.setBounds(secondaryBounds);
            } else {
                DasAxis.this.secondaryInputPanel.setBounds(-100, -100, 0, 0);
            }
            if (DasAxis.this.scanPrevious != null && DasAxis.this.scanNext != null) {
                Dimension preferred = DasAxis.this.scanPrevious.getPreferredSize();
                int x = DMin - preferred.width - DasAxis.this.getX();
                int y = (DasAxis.this.orientation == 2 ? bottomPosition : topPosition - preferred.height) - DasAxis.this.getY();
                DasAxis.this.scanPrevious.setBounds(x, y, preferred.width, preferred.height);
                preferred = DasAxis.this.scanNext.getPreferredSize();
                x = DMax - DasAxis.this.getX();
                DasAxis.this.scanNext.setBounds(x, y, preferred.width, preferred.height);
            }
        }

        protected void verticalLayout() {
            boolean leftTicks = DasAxis.this.orientation == 3 || DasAxis.this.oppositeAxisVisible;
            boolean leftTickLabels = DasAxis.this.orientation == 3 && DasAxis.this.tickLabelsVisible;
            boolean rightTicks = DasAxis.this.orientation == 4 || DasAxis.this.oppositeAxisVisible;
            boolean rightTickLabels = DasAxis.this.orientation == 4 && DasAxis.this.tickLabelsVisible;
            int leftPosition = DasAxis.this.getColumn().getDMinimum() - 1;
            int rightPosition = DasAxis.this.getColumn().getDMaximum();
            int DMax = DasAxis.this.getRow().getDMaximum();
            int DMin = DasAxis.this.getRow().getDMinimum();
            Rectangle leftBounds = null;
            Rectangle rightBounds = null;
            Font tickLabelFont = DasAxis.this.getTickLabelFont();
            int tickSize = tickLabelFont.getSize() * 2 / 3;
            if (leftTicks) {
                leftBounds = new Rectangle(leftPosition, DMin, 1, DMax - DMin + 1);
            }
            if (rightTicks) {
                rightBounds = new Rectangle(rightPosition, DMin, 1, DMax - DMin + 1);
            }
            if (leftTicks) {
                leftBounds.width += tickSize;
                leftBounds.x -= tickSize;
            }
            if (rightTicks) {
                rightBounds.width += tickSize;
            }
            int maxLabelWidth = DasAxis.this.getMaxLabelWidth(DasAxis.this.getFontMetrics(tickLabelFont));
            int tick_label_gap = DasAxis.this.getFontMetrics(tickLabelFont).stringWidth(" ");
            if (leftTickLabels) {
                leftBounds.x -= maxLabelWidth + tick_label_gap;
                leftBounds.width += maxLabelWidth + tick_label_gap;
            }
            if (rightTickLabels) {
                rightBounds.width += maxLabelWidth + tick_label_gap;
            }
            Rectangle primaryBounds = DasAxis.this.orientation == 3 ? leftBounds : rightBounds;
            Rectangle secondaryBounds = DasAxis.this.orientation == 3 ? rightBounds : leftBounds;
            primaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            if (DasAxis.this.oppositeAxisVisible) {
                secondaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            }
            DasAxis.this.primaryInputPanel.setBounds(primaryBounds);
            if (DasAxis.this.oppositeAxisVisible) {
                DasAxis.this.secondaryInputPanel.setBounds(secondaryBounds);
            } else {
                DasAxis.this.secondaryInputPanel.setBounds(-100, -100, 0, 0);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension();
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

