/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;

public class AttachedRow
extends DasRow {
    private DasRow row;

    public AttachedRow(DasRow row, double minimum, double maximum) {
        super(row.getParent(), minimum, maximum);
        this.row = row;
    }

    public int getDMaximum() {
        if (this.row == null) {
            return 0;
        }
        int delta = this.row.getHeight();
        return this.row.getDMinimum() + (int)((double)delta * this.getMaximum());
    }

    public int getDMinimum() {
        if (this.row == null) {
            return 0;
        }
        double delta = this.row.getHeight();
        return this.row.getDMinimum() + (int)(delta * this.getMinimum());
    }

    public int getHeight() {
        return (int)((double)this.row.getHeight() * (this.getMaximum() - this.getMinimum()));
    }

    public void addpwUpdateListener(DasUpdateListener l) {
        super.addpwUpdateListener(l);
        this.row.addpwUpdateListener(l);
    }

    public void removepwUpdateListener(DasUpdateListener l) {
        super.removepwUpdateListener(l);
        this.row.removepwUpdateListener(l);
    }

    public void setDMinimum(int value) {
        double delta = this.row.getHeight();
        this.setMinimum((double)(value - this.row.getDMinimum()) / delta);
    }

    public void setDMaximum(int value) {
        double delta = this.row.getHeight();
        this.setMaximum((double)(value - this.row.getDMinimum()) / delta);
    }

    public void setDPosition(int minimum, int maximum) {
        double delta = this.row.getHeight();
        this.setMinimum((double)(minimum - this.row.getDMinimum()) / delta);
        this.setMaximum((double)(maximum - this.row.getDMinimum()) / delta);
        this.fireUpdate();
    }
}

