/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;

public class AttachedColumn
extends DasColumn {
    private DasColumn column;

    public AttachedColumn(DasColumn column, double minimum, double maximum) {
        super(column.getParent(), minimum, maximum);
        this.column = column;
    }

    public int getDMaximum() {
        if (this.column == null) {
            return 0;
        }
        int delta = this.column.getWidth();
        return this.column.getDMinimum() + (int)((double)delta * this.getMaximum());
    }

    public int getDMinimum() {
        if (this.column == null) {
            return 0;
        }
        double delta = this.column.getWidth();
        return this.column.getDMinimum() + (int)(delta * this.getMinimum());
    }

    public void setDMinimum(int minimum) {
        double delta = this.column.getWidth();
        this.setMinimum((double)(minimum - this.column.getDMinimum()) / delta);
        this.fireUpdate();
    }

    public void setDMaximum(int maximum) {
        double delta = this.column.getWidth();
        this.setMaximum((double)(maximum - this.column.getDMinimum()) / delta);
        this.fireUpdate();
    }

    public void setDPosition(int minimum, int maximum) {
        double delta = this.column.getWidth();
        this.setMinimum((double)(minimum - this.column.getDMinimum()) / delta);
        this.setMaximum((double)(maximum - this.column.getDMinimum()) / delta);
        this.fireUpdate();
    }

    public int getWidth() {
        return (int)((double)this.column.getWidth() * (this.getMaximum() - this.getMinimum()));
    }

    public void addpwUpdateListener(DasUpdateListener l) {
        super.addpwUpdateListener(l);
        this.column.addpwUpdateListener(l);
    }

    public void removepwUpdateListener(DasUpdateListener l) {
        super.removepwUpdateListener(l);
        this.column.removepwUpdateListener(l);
    }
}

