/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.GesturesRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseRangeSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class VerticalRangeGesturesRenderer
implements DragRenderer {
    protected int xInitial;
    protected int yInitial;
    private GesturesRenderer gr;
    private Rectangle dirtyBounds;
    private DasCanvasComponent parent;

    public VerticalRangeGesturesRenderer(DasCanvasComponent parent) {
        this.gr = new GesturesRenderer(parent);
        this.parent = parent;
        this.dirtyBounds = new Rectangle();
    }

    public void renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        double dx = p2.x - p1.x;
        double dy = -1 * (p2.y - p1.y);
        double angle = Math.atan2(dy, dx) * 180.0 / Math.PI;
        double radius = Math.sqrt(dy * dy + dx * dx);
        if (radius < 20.0) {
            this.gr.renderDrag(g, p1, p2);
            this.dirtyBounds.setBounds(this.gr.getDirtyBounds());
        } else {
            int y2 = p2.y;
            int y1 = p1.y;
            if (y2 < y1) {
                int t = y2;
                y2 = y1;
                y1 = t;
            }
            int height = y2 - y1;
            int x = p2.x;
            Color color0 = g.getColor();
            g.setColor(new Color(255, 255, 255, 100));
            g.setStroke(new BasicStroke(3.0f, 1, 1));
            if (height > 6) {
                g.drawLine(x, y1 + 3, x, y2 - 3);
            }
            g.drawLine(x + 2, y1, x - 2, y1);
            g.drawLine(x + 2, y2, x - 2, y2);
            g.setStroke(new BasicStroke());
            g.setColor(color0);
            if (height > 6) {
                g.drawLine(x, y1 + 3, x, y2 - 3);
            }
            g.drawLine(x + 2, y1, x - 2, y1);
            g.drawLine(x + 2, y2, x - 2, y2);
            this.dirtyBounds.setLocation(x - 4, y1 - 2);
            this.dirtyBounds.add(x + 4, y2 + 2);
        }
    }

    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        double dx = p2.x - p1.x;
        double dy = -1 * (p2.y - p1.y);
        double radius = Math.sqrt(dy * dy + dx * dx);
        if (this.gr.isGesture(p1, p2)) {
            return this.gr.getMouseDragEvent(source, p1, p2, isModified);
        }
        return new MouseRangeSelectionEvent(source, p1.y, p2.y, isModified);
    }

    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    public boolean isXRangeSelection() {
        return false;
    }

    public boolean isYRangeSelection() {
        return true;
    }

    public boolean isPointSelection() {
        return false;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }
}

