/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.event.Gesture;
import edu.uiowa.physics.pw.das.event.HorizontalRangeGesturesRenderer;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MouseRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import javax.swing.event.EventListenerList;

public class TimeRangeSelectorMouseModule
extends MouseModule {
    DasAxis timeAxis;
    private EventListenerList listenerList = null;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener;

    public String getLabel() {
        return "X Time Zoom";
    }

    public TimeRangeSelectorMouseModule(DasCanvasComponent parent, DasAxis timeAxis) {
        this.parent = parent;
        this.dragRenderer = new HorizontalRangeGesturesRenderer(parent);
        this.timeAxis = timeAxis;
    }

    public static TimeRangeSelectorMouseModule create(DasPlot parent) {
        DasAxis axis = parent.getXAxis();
        TimeRangeSelectorMouseModule result = null;
        result = new TimeRangeSelectorMouseModule(parent, parent.getXAxis());
        return result;
    }

    public void mouseRangeSelected(MouseRangeSelectionEvent e0) {
        if (!e0.isGesture()) {
            Datum nnMax;
            MouseRangeSelectionEvent e = e0;
            Datum min = this.timeAxis.invTransform(e.getMinimum());
            Datum max = this.timeAxis.invTransform(e.getMaximum());
            Datum nnMin = this.timeAxis.findTick(min, 0.0, true);
            if (nnMin.equals(nnMax = this.timeAxis.findTick(max, 0.0, true))) {
                min = this.timeAxis.findTick(min, -1.0, true);
                max = this.timeAxis.findTick(max, 1.0, true);
            } else {
                min = nnMin;
                max = nnMax;
            }
            TimeRangeSelectionEvent te = new TimeRangeSelectionEvent(this.parent, new DatumRange(min, max));
            this.fireTimeRangeSelectionListenerTimeRangeSelected(te);
        } else if (e0.getGesture() == Gesture.BACK) {
            this.timeAxis.setDataRangePrev();
        } else if (e0.getGesture() == Gesture.ZOOMOUT) {
            this.timeAxis.setDataRangeZoomOut();
        } else if (e0.getGesture() == Gesture.FORWARD) {
            this.timeAxis.setDataRangeForward();
        } else if (e0.getGesture() == Gesture.SCANPREV) {
            DatumRange range0 = this.timeAxis.getRange();
            TimeRangeSelectionEvent te = new TimeRangeSelectionEvent(this.parent, range0.previous());
            this.fireTimeRangeSelectionListenerTimeRangeSelected(te);
        } else if (e0.getGesture() == Gesture.SCANNEXT) {
            DatumRange range0 = this.timeAxis.getRange();
            TimeRangeSelectionEvent te = new TimeRangeSelectionEvent(this.parent, range0.next());
            this.fireTimeRangeSelectionListenerTimeRangeSelected(te);
        } else {
            throw new RuntimeException("unrecognized gesture: " + e0.getGesture());
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener = TimeRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener, listener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener = TimeRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener, listener);
    }

    private void fireTimeRangeSelectionListenerTimeRangeSelected(TimeRangeSelectionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? TimeRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener") : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener)) continue;
            String msg = "fire event: " + this.getClass().getName() + "-->" + listeners[i + 1].getClass().getName() + " " + event;
            ((TimeRangeSelectionListener)listeners[i + 1]).timeRangeSelected(event);
            DasApplication.getDefaultApplication().getLogger(DasApplication.GUI_LOG).info(msg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

