/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.event.LabelDragRenderer;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class PointSlopeDragRenderer
extends LabelDragRenderer {
    DasAxis xaxis;
    DasAxis yaxis;
    NumberFormat nf;

    public PointSlopeDragRenderer(DasCanvasComponent parent, DasAxis xaxis, DasAxis yaxis) {
        super(parent);
        this.parent = parent;
        this.xaxis = xaxis;
        this.yaxis = yaxis;
        this.dirtyBounds = new Rectangle();
        this.gtr = new GrannyTextRenderer();
        this.nf = new DecimalFormat("0.00E0");
    }

    public void renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        g1.drawLine(p1.x, p1.y, p2.x, p2.y);
        g1.drawOval(p1.x - 1, p1.y - 1, 3, 3);
        this.dirtyBounds.setRect(p1.x - 2, p1.y - 2, 5.0, 5.0);
        this.dirtyBounds.add(p2.x - 2, p2.y - 2);
        this.dirtyBounds.add(p2.x + 2, p2.y + 2);
        Datum run = this.xaxis.invTransform(p2.x + this.parent.getX()).subtract(this.xaxis.invTransform(p1.x + this.parent.getX()));
        Datum rise = this.yaxis.invTransform(p2.y + this.parent.getY()).subtract(this.yaxis.invTransform(p1.y + this.parent.getY()));
        if (!p1.equals(p2)) {
            double slope = rise.doubleValue(rise.getUnits()) / run.doubleValue(run.getUnits());
            this.setLabel(this.nf.format(slope));
        } else {
            this.setLabel("");
        }
        this.dirtyBounds.add(this.paintLabel(g, p2));
    }
}

