/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.event.LabelDragRenderer;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.NumberFormat;

public class LengthDragRenderer
extends LabelDragRenderer {
    DasAxis xaxis;
    DasAxis yaxis;
    NumberFormat nf;

    public LengthDragRenderer(DasCanvasComponent parent, DasAxis xaxis, DasAxis yaxis) {
        super(parent);
        this.xaxis = xaxis;
        this.yaxis = yaxis;
        this.dirtyBounds = new Rectangle();
    }

    public void renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        g1.drawLine(p1.x, p1.y, p2.x, p2.y);
        g1.drawOval(p1.x - 1, p1.y - 1, 3, 3);
        this.dirtyBounds.setRect(p1.x - 2, p1.y - 2, 5.0, 5.0);
        this.dirtyBounds.add(p2.x - 2, p2.y - 2);
        this.dirtyBounds.add(p2.x + 2, p2.y + 2);
        Datum x0 = this.xaxis.invTransform(p2.x + this.parent.getX());
        Datum run = x0.subtract(this.xaxis.invTransform(p1.x + this.parent.getX()));
        Datum y0 = this.yaxis.invTransform(p2.y + this.parent.getY());
        Datum rise = y0.subtract(this.yaxis.invTransform(p1.y + this.parent.getY()));
        if (!p1.equals(p2)) {
            this.setLabel("\u0394x: " + x0.getFormatter().format(run) + " \u0394y: " + y0.getFormatter().format(rise));
        } else {
            this.setLabel("");
        }
        this.dirtyBounds.add(this.paintLabel(g, p2));
    }
}

