/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public abstract class LabelDragRenderer
implements DragRenderer {
    String label = "";
    GrannyTextRenderer gtr;
    DasCanvasComponent parent;
    Rectangle dirtyBounds;
    int maxLabelWidth;

    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    LabelDragRenderer(DasCanvasComponent parent) {
        this.parent = parent;
        this.gtr = new GrannyTextRenderer();
    }

    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        return null;
    }

    public boolean isPointSelection() {
        return true;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }

    public boolean isXRangeSelection() {
        return true;
    }

    public boolean isYRangeSelection() {
        return true;
    }

    void setLabel(String s) {
        this.label = s;
    }

    Rectangle paintLabel(Graphics g1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fm = g.getFontMetrics();
        Dimension d = this.parent.getSize();
        this.gtr.setString(this.parent, this.label);
        int dx = (int)this.gtr.getWidth() + 6;
        int dy = (int)this.gtr.getHeight();
        int xp = p2.x + 3;
        if (this.maxLabelWidth < dx) {
            this.maxLabelWidth = dx;
        }
        int yp = p2.y - 3 - dy;
        if (xp + this.maxLabelWidth > d.width - 3 && p2.x - 3 - dx > 0) {
            xp = p2.x - 3 - dx;
        }
        if (yp < 13) {
            yp = p2.y + 3;
        }
        Rectangle dirtyBounds = new Rectangle();
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 200));
        dirtyBounds.setRect(xp, yp, dx, dy);
        g.fill(dirtyBounds);
        g.setColor(new Color(20, 20, 20));
        this.gtr.draw(g, xp + 3, (float)((double)yp + this.gtr.getAscent()));
        g.setColor(color0);
        return dirtyBounds;
    }
}

