/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.util.DasDie;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class HorizontalSliceSelectionRenderer
implements DragRenderer {
    DasCanvasComponent parent;
    Rectangle dirtyBounds;
    Point crossHairLocation;

    public HorizontalSliceSelectionRenderer(DasCanvasComponent parent) {
        this.parent = parent;
        this.dirtyBounds = new Rectangle();
    }

    private void drawCrossHair(Graphics g0, Point p) {
        Graphics g = g0.create();
        g.setColor(new Color(0, 0, 0));
        g.setXORMode(Color.white);
        if (this.crossHairLocation != null && !this.crossHairLocation.equals(p)) {
            this.drawCrossHair(g, this.crossHairLocation);
        }
        Dimension d = this.parent.getSize();
        g.drawLine(0, p.y, (int)d.getWidth(), p.y);
        if (this.crossHairLocation != null) {
            if (this.crossHairLocation.equals(p)) {
                this.crossHairLocation = null;
            } else {
                DasDie.println("Sorry about the crosshair mess!");
                this.crossHairLocation = p;
            }
        } else {
            this.crossHairLocation = p;
        }
        g.dispose();
    }

    public void renderDrag(Graphics g, Point p1, Point p2) {
        if (this.crossHairLocation != null) {
            this.drawCrossHair(g, this.crossHairLocation);
        }
        this.drawCrossHair(g, p2);
    }

    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        return null;
    }

    public void clear(Graphics g) {
        if (this.crossHairLocation != null) {
            this.drawCrossHair(g, this.crossHairLocation);
        }
    }

    public boolean isXRangeSelection() {
        return false;
    }

    public boolean isYRangeSelection() {
        return false;
    }

    public boolean isPointSelection() {
        return true;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }
}

