/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;

public class HorizontalFrequencyDragRenderer
implements DragRenderer,
KeyListener {
    private Rectangle dirtyBounds;
    DasCanvasComponent parent;
    DasAxis axis;
    int ncycles;

    public HorizontalFrequencyDragRenderer(DasCanvasComponent parent, DasAxis axis) {
        this.parent = parent;
        parent.addKeyListener(this);
        this.axis = axis;
        this.dirtyBounds = new Rectangle();
        this.ncycles = 1;
    }

    public boolean isXRangeSelection() {
        return false;
    }

    public void renderLabel(Graphics g1, Point p1, Point p2, String report) {
        int dxMax = Integer.MIN_VALUE;
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fm = this.parent.getGraphics().getFontMetrics();
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 200));
        Dimension d = this.parent.getSize();
        int dx = fm.stringWidth(report) + 6;
        if (dxMax < dx) {
            dxMax = dx;
        }
        int dy = fm.getAscent() + fm.getDescent();
        int xp = p2.x + 3;
        int yp = p2.y - 3 - dy;
        if (xp + dxMax > d.width - 3 && p2.x - 3 - dx > 0) {
            xp = p2.x - 3 - dx;
        }
        if (yp < 13) {
            yp = p2.y + 3;
        }
        Rectangle bg = new Rectangle(xp, yp, dx, dy);
        g.fill(bg);
        g.setColor(new Color(20, 20, 20));
        g.drawString(report, xp + 3, yp + fm.getAscent());
        g.setColor(color0);
        this.dirtyBounds.add(bg);
    }

    public void renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        int x2 = p2.x;
        int x1 = p1.x;
        if (x2 < x1) {
            int t = x2;
            x2 = x1;
            x1 = t;
        }
        int width = x2 - x1;
        int y = p2.y;
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 100));
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        if (width > 6) {
            g.drawLine(x1 + 3, y, x2 - 3, y);
        }
        g.drawLine(x1, y + 2, x1, y - 2);
        g.drawLine(x2, y + 2, x2, y - 2);
        g.setStroke(new BasicStroke());
        g.setColor(color0);
        if (width > 6) {
            g.drawLine(x1 + 3, y, x2 - 3, y);
        }
        g.drawLine(x1, y + 2, x1, y - 2);
        g.drawLine(x2, y + 2, x2, y - 2);
        this.dirtyBounds.setRect(x1 - 2, y - 5, 4.0, 10.0);
        double rwidth = (double)width / (double)this.ncycles;
        if (width > 3 * this.ncycles) {
            double ii;
            for (ii = (double)x2 + rwidth; ii < (double)this.axis.getColumn().getWidth(); ii += rwidth) {
                g.drawLine((int)ii, y + 2, (int)ii, y - 2);
                this.dirtyBounds.add((int)ii + 2, y - 5);
            }
            for (ii = (double)x2 - rwidth; ii > 0.0; ii -= rwidth) {
                g.drawLine((int)ii, y + 2, (int)ii, y - 2);
                this.dirtyBounds.add((int)ii - 2, y - 5);
            }
        }
        Datum periodDatum = this.axis.invTransform(x2).subtract(this.axis.invTransform(x1));
        double period = periodDatum.doubleValue(periodDatum.getUnits());
        double freq = (double)this.ncycles / period;
        DecimalFormat df = new DecimalFormat("0.00");
        this.renderLabel(g1, p1, p2, "T:" + df.format(period) + " f:" + df.format(freq));
    }

    public boolean isPointSelection() {
        return false;
    }

    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }

    public boolean isYRangeSelection() {
        return false;
    }

    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        return null;
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        System.out.println(e);
        if (e.getKeyChar() == '1') {
            this.ncycles = 1;
        } else if (e.getKeyChar() == '2') {
            this.ncycles = 2;
        } else if (e.getKeyChar() == '3') {
            this.ncycles = 3;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

