/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.event.DasEvent;

public class DataRangeSelectionEvent
extends DasEvent {
    private DataSet ds = null;
    Datum min;
    Datum max;
    Datum reference;

    public DataRangeSelectionEvent(Object source, Datum min, Datum max) {
        super(source);
        if (min.gt(max)) {
            Datum t = min;
            min = max;
            max = t;
        }
        this.min = min;
        this.max = max;
        this.reference = null;
    }

    public Datum getMinimum() {
        return this.min;
    }

    public Datum getMaximum() {
        return this.max;
    }

    public DatumRange getDatumRange() {
        return new DatumRange(this.min, this.max);
    }

    public void setDataSet(DataSet ds) {
        this.ds = ds;
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    public void setReference(Datum reference) {
        this.reference = reference;
    }

    public Datum getReference() {
        return this.reference;
    }

    public String toString() {
        return "[DataRangeSelectionEvent min:" + this.min + " max:" + this.max + "]";
    }
}

