/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.event.CrossHairRenderer;
import edu.uiowa.physics.pw.das.event.DataPointSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionListener;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MousePointSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import javax.swing.event.EventListenerList;

public class CrossHairMouseModule
extends MouseModule {
    DasAxis xaxis;
    DasAxis yaxis;
    protected DataPointSelectionEvent de;
    DataSetConsumer dataSetConsumer;
    private EventListenerList listenerList = null;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener;

    private CrossHairMouseModule() {
    }

    public CrossHairMouseModule(DasPlot parent, DasAxis xaxis, DasAxis yaxis) {
        this(parent, parent, xaxis, yaxis);
    }

    public CrossHairMouseModule(DasPlot parent, DataSetConsumer dataSetConsumer, DasAxis xAxis, DasAxis yAxis) {
        super(parent, new CrossHairRenderer(parent, dataSetConsumer, xAxis, yAxis), "Crosshair Digitizer");
        this.dataSetConsumer = dataSetConsumer;
        this.xaxis = xAxis;
        this.yaxis = yAxis;
        this.de = new DataPointSelectionEvent(this, null, null);
    }

    public static CrossHairMouseModule create(DasPlot parent) {
        DasAxis xaxis = parent.getXAxis();
        DasAxis yaxis = parent.getYAxis();
        return new CrossHairMouseModule(parent, xaxis, yaxis);
    }

    protected DataPointSelectionEvent getDataPointSelectionEvent(MousePointSelectionEvent e) {
        this.de.setDataSet(this.dataSetConsumer.getDataSet());
        this.de.set(this.xaxis.invTransform(e.getX()), this.yaxis.invTransform(e.getY()));
        return this.de;
    }

    public void mousePointSelected(MousePointSelectionEvent e) {
        this.fireDataPointSelectionListenerDataPointSelected(this.getDataPointSelectionEvent(e));
    }

    public synchronized void addDataPointSelectionListener(DataPointSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener = CrossHairMouseModule.class$("edu.uiowa.physics.pw.das.event.DataPointSelectionListener")) : class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener, listener);
    }

    public synchronized void removeDataPointSelectionListener(DataPointSelectionListener listener) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener = CrossHairMouseModule.class$("edu.uiowa.physics.pw.das.event.DataPointSelectionListener")) : class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener, listener);
    }

    protected void fireDataPointSelectionListenerDataPointSelected(DataPointSelectionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener == null ? CrossHairMouseModule.class$("edu.uiowa.physics.pw.das.event.DataPointSelectionListener") : class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener)) continue;
            ((DataPointSelectionListener)listeners[i + 1]).DataPointSelected(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

