/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum.format;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.text.DecimalFormat;

public class ExponentialDatumFormatter
extends DatumFormatter {
    private DecimalFormat format;
    int digits;
    int exponent;
    DecimalFormat mantFormat;
    String mantFormatString;

    public ExponentialDatumFormatter(int digits, int exponent) {
        this.digits = digits;
        this.exponent = exponent;
        StringBuffer buff = new StringBuffer(digits + 2).append("0");
        if (digits > 1) {
            buff.append('.');
        }
        for (int i = 1; i < digits; ++i) {
            buff.append('0');
        }
        this.mantFormatString = buff.toString();
        this.mantFormat = new DecimalFormat(buff.toString());
    }

    public String format(Datum datum) {
        double x = datum.doubleValue(datum.getUnits());
        if (x == 0.0) {
            return "0.";
        }
        double exp = DasMath.exp10(this.exponent);
        double mant = x / exp;
        double tenToN = DasMath.exp10(this.digits);
        mant = (double)Math.round(mant * tenToN) / tenToN;
        return this.mantFormat.format(mant) + "E" + this.exponent;
    }

    public String grannyFormat(Datum datum) {
        String format = this.format(datum);
        if (format.indexOf("E") != -1) {
            int iE = format.indexOf("E");
            StringBuffer granny = new StringBuffer(format.length() + 4);
            String mant = format.substring(0, iE);
            granny.append(mant).append("\u00d7");
            granny.append("10").append("!A").append(format.substring(iE + 1)).append("!N");
            format = granny.toString();
        }
        return format;
    }

    public String toString() {
        return this.mantFormatString + "E" + this.exponent;
    }
}

