/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum.format;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import java.text.DecimalFormat;
import java.text.ParseException;

public class DefaultDatumFormatter
extends DatumFormatter {
    private String formatString;
    private DecimalFormat format;

    protected DefaultDatumFormatter() {
    }

    public DefaultDatumFormatter(String formatString) throws ParseException {
        if (formatString.equals("")) {
            this.formatString = "";
            this.format = null;
        } else {
            this.formatString = formatString;
            this.format = new DecimalFormat(formatString);
        }
    }

    public String format(Datum datum) {
        if (this.format == null) {
            return Double.toString(datum.doubleValue(datum.getUnits()));
        }
        return this.format.format(datum.doubleValue(datum.getUnits()));
    }

    public String grannyFormat(Datum datum) {
        String format = this.format(datum);
        if (format.indexOf("E") != -1) {
            int iE = format.indexOf("E");
            StringBuffer granny = new StringBuffer(format.length() + 4);
            String mant = format.substring(0, iE);
            if (Double.parseDouble(mant) != 1.0) {
                granny.append(mant).append("\u00d7");
            }
            granny.append("10").append("!A").append(format.substring(iE + 1)).append("!N");
            format = granny.toString();
        }
        return format;
    }

    public String toString() {
        return this.formatString;
    }
}

