/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.EnumerationUnits;
import edu.uiowa.physics.pw.das.datum.NumberUnits;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatterFactory;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public abstract class Units {
    public static final Units dimensionless = new NumberUnits("");
    public static final Units dB = new NumberUnits("dB");
    public static final Units radians = new NumberUnits("radian");
    public static final Units degrees = new NumberUnits("degrees");
    public static final Units celcius;
    public static final Units fahrenheit;
    public static final Units seconds;
    public static final Units microseconds;
    public static final Units nanoseconds;
    public static final Units days;
    public static final Units hertz;
    public static final Units kiloHertz;
    public static final Units megaHertz;
    public static final TimeLocationUnits us2000;
    public static final TimeLocationUnits t2000;
    public static final TimeLocationUnits t1970;
    public static final TimeLocationUnits mj1958;
    public static final EnumerationUnits spacecraft;
    public static final Units percent;
    private static Map unitsMap;
    private String id;
    private String description;
    private Map conversionMap = new IdentityHashMap();
    private static double FILL_DOUBLE;
    private static float FILL_FLOAT;
    private static int FILL_INT;
    private static long FILL_LONG;

    protected Units(String id) {
        this(id, "");
    }

    protected Units(String id, String description) {
        this.id = id;
        this.description = description;
    }

    private void registerConverter(Units toUnits, UnitsConverter converter) {
        this.conversionMap.put(toUnits, converter);
        UnitsConverter inverse = (UnitsConverter)toUnits.conversionMap.get(this);
        if (inverse == null || inverse.getInverse() != converter) {
            toUnits.registerConverter(this, converter.getInverse());
        }
    }

    public Units[] getConvertableUnits() {
        HashSet<Units> result = new HashSet<Units>();
        LinkedList<Units> queue = new LinkedList<Units>();
        queue.add(this);
        while (!queue.isEmpty()) {
            Units current = (Units)queue.removeFirst();
            Iterator i = current.conversionMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Units next = (Units)entry.getKey();
                if (result.contains(next)) continue;
                queue.add(next);
                result.add(next);
            }
        }
        return result.toArray(new Units[result.size()]);
    }

    public static UnitsConverter getConverter(Units fromUnits, Units toUnits) {
        if (fromUnits == toUnits) {
            return UnitsConverter.IDENTITY;
        }
        if (fromUnits.conversionMap.get(toUnits) != null) {
            return (UnitsConverter)fromUnits.conversionMap.get(toUnits);
        }
        HashMap<Units, Units> visited = new HashMap<Units, Units>();
        visited.put(fromUnits, null);
        LinkedList<Units> queue = new LinkedList<Units>();
        queue.add(fromUnits);
        while (!queue.isEmpty()) {
            Units current = (Units)queue.removeFirst();
            Iterator i = current.conversionMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Units next = (Units)entry.getKey();
                if (visited.containsKey(next)) continue;
                visited.put(next, current);
                queue.add(next);
                if (next != toUnits) continue;
                return Units.buildConversion(fromUnits, toUnits, visited);
            }
        }
        String sfrom = fromUnits == dimensionless ? "(dimensionless)" : fromUnits.toString();
        String sto = toUnits == dimensionless ? "(dimensionless)" : toUnits.toString();
        throw new IllegalArgumentException("Inconvertible units: " + sfrom + " -> " + sto);
    }

    private static UnitsConverter buildConversion(Units fromUnits, Units toUnits, Map parentMap) {
        ArrayList<Units> list = new ArrayList<Units>();
        Units current = toUnits;
        while (current != null) {
            list.add(current);
            current = (Units)parentMap.get(current);
        }
        UnitsConverter converter = UnitsConverter.IDENTITY;
        for (int i = list.size() - 1; i > 0; --i) {
            Units a = (Units)list.get(i);
            Units b = (Units)list.get(i - 1);
            UnitsConverter c = (UnitsConverter)a.conversionMap.get(b);
            converter = converter.append(c);
        }
        fromUnits.registerConverter(toUnits, converter);
        return converter;
    }

    public UnitsConverter getConverter(Units toUnits) {
        return Units.getConverter(this, toUnits);
    }

    public double convertDoubleTo(Units toUnits, double value) {
        if (this == toUnits) {
            return value;
        }
        return Units.getConverter(this, toUnits).convert(value);
    }

    public String toString() {
        return this.id;
    }

    public Units getOffsetUnits() {
        return this;
    }

    public abstract Datum createDatum(double var1);

    public abstract Datum createDatum(int var1);

    public abstract Datum createDatum(long var1);

    public abstract Datum createDatum(Number var1);

    public double getFillDouble() {
        return FILL_DOUBLE;
    }

    public float getFillFloat() {
        return FILL_FLOAT;
    }

    public int getFillInt() {
        return FILL_INT;
    }

    public long getFillLong() {
        return FILL_LONG;
    }

    public boolean isFill(double value) {
        return Math.abs((value - FILL_DOUBLE) / value) < 1.0E-5;
    }

    public boolean isFill(float value) {
        return (double)Math.abs((value - FILL_FLOAT) / value) < 1.0E-5;
    }

    public boolean isFill(long value) {
        return value == FILL_LONG;
    }

    public boolean isFill(int value) {
        return value == FILL_INT;
    }

    public boolean isFill(Number value) {
        if (value instanceof Double) {
            return this.isFill(value.doubleValue());
        }
        if (value instanceof Float) {
            return this.isFill(value.floatValue());
        }
        if (value instanceof Integer) {
            return this.isFill(value.intValue());
        }
        if (value instanceof Long) {
            return this.isFill(value.longValue());
        }
        throw new IllegalArgumentException("Unknown Number class: " + value.getClass().toString());
    }

    public abstract DatumFormatterFactory getDatumFormatterFactory();

    public abstract Datum parse(String var1) throws ParseException;

    public String format(Datum datum) {
        return this.getDatumFormatterFactory().defaultFormatter().format(datum);
    }

    public String grannyFormat(Datum datum) {
        return this.getDatumFormatterFactory().defaultFormatter().grannyFormat(datum);
    }

    public abstract Datum add(Number var1, Number var2, Units var3);

    public abstract Datum subtract(Number var1, Number var2, Units var3);

    public abstract Datum multiply(Number var1, Number var2, Units var3);

    public abstract Datum divide(Number var1, Number var2, Units var3);

    public static Units getByName(String s) {
        Units units = (Units)unitsMap.get(s);
        if (units == null) {
            throw new IllegalArgumentException("Unrecognized units");
        }
        return units;
    }

    public static void main(String[] args) throws ParseException {
        Datum ratio = Datum.create(100);
        Datum db = ratio.convertTo(dB);
        System.out.println("ratio: " + ratio);
        System.out.println("dB: " + db);
        Datum Hz = Datum.create(1000000.0, hertz);
        Datum kHz = Hz.convertTo(kiloHertz);
        Datum MHz = kHz.convertTo(megaHertz);
        System.out.println("Hz: " + Hz);
        System.out.println("kHz: " + kHz);
        System.out.println("MHz: " + MHz);
    }

    static {
        dimensionless.registerConverter(dB, new dBConverter());
        celcius = new NumberUnits("deg C");
        fahrenheit = new NumberUnits("deg F");
        celcius.registerConverter(fahrenheit, new UnitsConverter.ScaleOffset(1.8, 32.0));
        seconds = new NumberUnits("s");
        microseconds = new NumberUnits("microseconds");
        nanoseconds = new NumberUnits("nanoseconds");
        days = new NumberUnits("days");
        seconds.registerConverter(microseconds, UnitsConverter.MICRO);
        seconds.registerConverter(nanoseconds, UnitsConverter.NANO);
        days.registerConverter(seconds, new UnitsConverter.ScaleOffset(86400.0, 0.0));
        hertz = new NumberUnits("Hz");
        kiloHertz = new NumberUnits("kHz");
        megaHertz = new NumberUnits("MHz");
        hertz.registerConverter(kiloHertz, UnitsConverter.KILO);
        hertz.registerConverter(megaHertz, UnitsConverter.MEGA);
        us2000 = new TimeLocationUnits("us2000", "Microseconds since midnight Jan 1, 2000.", microseconds);
        t2000 = new TimeLocationUnits("t2000", "Seconds since midnight Jan 1, 2000.", seconds);
        t1970 = new TimeLocationUnits("t1970", "Seconds since midnight Jan 1, 1970", seconds);
        mj1958 = new TimeLocationUnits("mj1958", "Julian - 2436204.5", days);
        super.registerConverter(us2000, UnitsConverter.MICRO);
        super.registerConverter(t1970, new UnitsConverter.ScaleOffset(1.0, 9.466848E8));
        super.registerConverter(mj1958, new UnitsConverter.ScaleOffset(1.1574074074074073E-5, 15340.0));
        spacecraft = new EnumerationUnits("spacecraft", "Enumeration of various spacecraft");
        spacecraft.createDatum("Voyager1");
        spacecraft.createDatum("Voyager2");
        spacecraft.createDatum("Cluster Rumba");
        spacecraft.createDatum("Cluster Salsa");
        spacecraft.createDatum("Cluster Samba");
        spacecraft.createDatum("Cluster Tango");
        percent = new NumberUnits("%", "Special dimensionless number, possibly useful for specifying Tag relevance on logarithmic scale");
        unitsMap = new HashMap();
        unitsMap.put("mj1958", mj1958);
        unitsMap.put("t1970", t1970);
        unitsMap.put("t2000", t2000);
        unitsMap.put("us2000", us2000);
        unitsMap.put("seconds", seconds);
        unitsMap.put("s", seconds);
        unitsMap.put("days", days);
        unitsMap.put("microseconds", microseconds);
        unitsMap.put("", dimensionless);
        unitsMap.put("dB", dB);
        unitsMap.put("Hz", hertz);
        unitsMap.put("kHz", kiloHertz);
        unitsMap.put("MHz", megaHertz);
        FILL_DOUBLE = -1.0E31;
        FILL_FLOAT = -1.0E31f;
        FILL_INT = Integer.MAX_VALUE;
        FILL_LONG = Long.MAX_VALUE;
    }

    private static final class dBConverter
    extends UnitsConverter {
        private dBConverter() {
        }

        public double convert(double value) {
            return 10.0 * DasMath.log10(value);
        }

        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                this.inverse = new UnitsConverter(){

                    public double convert(double value) {
                        return Math.pow(10.0, value / 10.0);
                    }

                    public UnitsConverter getInverse() {
                        return this;
                    }
                };
            }
            return this.inverse;
        }
    }
}

