/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import edu.uiowa.physics.pw.das.util.DasDie;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class TimeUtil {
    private static final int[][] daysInMonth = new int[][]{{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 0}, {0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 0}};
    private static final int[][] dayOffset = new int[][]{{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365}, {0, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366}};
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DAY = 3;
    public static final int HOUR = 4;
    public static final int MINUTE = 5;
    public static final int SECOND = 6;
    public static final int NANO = 7;
    public static final int WEEK = 97;
    public static final int QUARTER = 98;

    private TimeUtil() {
    }

    public static int daysInMonth(int month, int year) {
        return daysInMonth[TimeUtil.isLeapYear(year) ? 1 : 0][month];
    }

    public static int julday(int month, int day, int year) {
        int jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029;
        return jd;
    }

    public static int dayOfYear(int month, int day, int year) {
        return day + dayOffset[TimeUtil.isLeapYear(year) ? 1 : 0][month];
    }

    public static double getSecondsSinceMidnight(Datum datum) {
        double xx = datum.doubleValue(Units.t2000);
        if (xx < 0.0) {
            if ((xx %= 86400.0) == 0.0) {
                return 0.0;
            }
            return 86400.0 + xx;
        }
        return xx % 86400.0;
    }

    public static int getJulianDay(Datum datum) {
        double xx = datum.doubleValue(Units.mj1958);
        return (int)Math.floor(xx) + 2436205;
    }

    public static Datum toDatum(TimeStruct d) {
        int year = d.year;
        int month = d.month;
        int day = d.day;
        int jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029;
        int hour = d.hour;
        int minute = d.minute;
        double seconds = d.seconds + (double)((float)hour * 3600.0f) + (double)((float)minute * 60.0f);
        double us2000 = UnitsConverter.getConverter(Units.mj1958, Units.us2000).convert((double)(jd - 2436205) + seconds / 86400.0);
        return Datum.create(us2000, (Units)Units.us2000);
    }

    public static TimeStruct toTimeStruct(Datum datum) {
        int jd = TimeUtil.getJulianDay(datum);
        double seconds = TimeUtil.getSecondsSinceMidnight(datum);
        int jalpha = (int)(((double)(jd - 1867216) - 0.25) / 36524.25);
        int j1 = jd + 1 + jalpha - jalpha / 4;
        int j2 = j1 + 1524;
        int j3 = 6680 + (int)(((double)(j2 - 2439870) - 122.1) / 365.25);
        int j4 = 365 * j3 + j3 / 4;
        int j5 = (int)((double)(j2 - j4) / 30.6001);
        int day = j2 - j4 - (int)(30.6001 * (double)j5);
        int month = j5 - 1;
        month = (month - 1) % 12 + 1;
        int year = j3 - 4715;
        int hour = (int)(seconds / 3600.0);
        int minute = (int)((seconds - (double)hour * 3600.0) / 60.0);
        double justSeconds = seconds - (double)hour * 3600.0 - (double)minute * 60.0;
        TimeStruct result = new TimeStruct();
        result.year = year -= (year -= month > 2 ? 1 : 0) <= 0 ? 1 : 0;
        result.month = month;
        result.day = day;
        result.doy = TimeUtil.dayOfYear(month, day, year);
        result.hour = hour;
        result.minute = minute;
        result.seconds = justSeconds;
        return result;
    }

    public static int[] toTimeArray(Datum time) {
        TimeStruct ts = TimeUtil.toTimeStruct(time);
        int seconds = (int)(ts.seconds + 5.0E-7);
        int micros = (int)((ts.seconds + 5.0E-7 - (double)seconds) * 1000000.0);
        int millis = micros / 1000;
        return new int[]{ts.year, ts.month, ts.minute, ts.hour, ts.minute, seconds, millis, micros -= millis * 1000};
    }

    public static Datum toDatum(int[] timeArray) {
        int year = timeArray[0];
        int month = timeArray[1];
        int day = timeArray[2];
        if (timeArray[2] < 1) {
            throw new IllegalArgumentException("");
        }
        int jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029;
        int hour = timeArray[3];
        int minute = timeArray[4];
        double seconds = (double)((float)timeArray[5] + (float)hour * 3600.0f + (float)minute * 60.0f) + (double)timeArray[6] / 1.0E9;
        double us2000 = UnitsConverter.getConverter(Units.mj1958, Units.us2000).convert((double)(jd - 2436205) + seconds / 86400.0);
        return Datum.create(us2000, (Units)Units.us2000);
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0;
    }

    public static TimeStruct carry(TimeStruct t) {
        int daysThisMonth;
        TimeStruct result = t;
        if (result.seconds >= 60.0) {
            result.seconds -= 60.0;
            ++result.minute;
        }
        if (result.minute >= 60) {
            result.minute -= 60;
            ++result.hour;
        }
        if (result.hour >= 24) {
            result.hour -= 24;
            ++result.day;
        }
        if (result.day > (daysThisMonth = TimeUtil.daysInMonth(result.month, result.year))) {
            result.day -= daysThisMonth;
            ++result.month;
        }
        if (result.month > 12) {
            result.month -= 12;
            ++result.year;
        }
        return result;
    }

    public static TimeStruct borrow(TimeStruct t) {
        TimeStruct result = t;
        if (result.seconds < 0.0) {
            result.seconds += 60.0;
            --result.minute;
        }
        if (result.minute < 0) {
            result.minute += 60;
            --result.hour;
        }
        if (result.hour < 0) {
            result.hour += 24;
            --result.day;
        }
        if (result.day < 0 || result.month < 1) {
            DasDie.die("Borrow operation not defined for months<1 or days<0");
        }
        if (result.day == 0) {
            int daysLastMonth = result.month > 1 ? TimeUtil.daysInMonth(result.year, result.month - 1) : 31;
            result.day += daysLastMonth;
            --result.month;
        }
        if (result.month == 0) {
            result.month += 12;
            --result.year;
        }
        return result;
    }

    public static TimeStruct normalize(TimeStruct t) {
        return TimeUtil.carry(TimeUtil.borrow(t));
    }

    public static Datum next(int step, Datum datum) {
        TimeStruct array = TimeUtil.toTimeStruct(datum);
        switch (step) {
            case 3: {
                ++array.day;
                break;
            }
            case 2: {
                ++array.month;
                array.day = 1;
                break;
            }
            case 98: {
                array.month = (array.month - 1 + 3) / 3 * 3 + 1;
                array.day = 1;
                break;
            }
            case 1: {
                ++array.year;
                array.month = 1;
                array.day = 1;
                break;
            }
        }
        if (step < 4) {
            array.hour = 0;
            array.minute = 0;
            array.seconds = 0.0;
        }
        if (array.month > 12) {
            ++array.year;
            array.month -= 12;
        }
        Datum result = TimeUtil.toDatum(array);
        return result;
    }

    public static Datum nextMonth(Datum datum) {
        return TimeUtil.next(2, datum);
    }

    public static Datum prev(int step, Datum datum) {
        TimeStruct t = TimeUtil.toTimeStruct(datum);
        switch (step) {
            case 1: {
                t.month = 1;
            }
            case 98: {
                t.month = (t.month - 1) / 3 * 3 + 1;
            }
            case 2: {
                t.day = 1;
            }
            case 3: {
                t.hour = 0;
            }
            case 4: {
                t.minute = 0;
            }
            case 5: {
                t.seconds = 0.0;
            }
            case 6: {
                t.seconds = (int)t.seconds;
            }
        }
        Datum result = TimeUtil.toDatum(t);
        if (result.equals(datum)) {
            return TimeUtil.prev(step, datum.subtract(500.0, Units.microseconds));
        }
        return result;
    }

    public static Datum now() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int year = cal.get(1);
        int doy = cal.get(6);
        DecimalFormat doyFormat = new DecimalFormat("000");
        try {
            return TimeUtil.create(year + "//" + doyFormat.format(doy) + " " + hour + ":" + minute + ":" + second);
        }
        catch (ParseException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public static double convert(int year, int month, int day, int hour, int minute, double second, TimeLocationUnits units) {
        int jd;
        if (month > 0) {
            jd = TimeUtil.julday(month, day, year);
        } else {
            int month1 = 1;
            int day1 = 1;
            jd = TimeUtil.julday(month1, day1, year);
            jd += day - 1;
        }
        double us2000 = (double)(jd - 2451545) * 8.64E10 + (second += (double)hour * 3600.0 + (double)minute * 60.0) * 1000000.0;
        if (units == Units.us2000) {
            return us2000;
        }
        return Units.us2000.convertDoubleTo(units, us2000);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final TimeStruct parseTime(String s) throws ParseException {
        int leap;
        int i;
        int len;
        int n;
        int end_of_date;
        boolean DATE = false;
        boolean YEAR = true;
        int MONTH = 2;
        int DAY = 3;
        int HOUR = 4;
        int MINUTE = 5;
        int SECOND = 6;
        String DELIMITERS = " \t/-:,_;";
        String PDSDELIMITERS = " \t/-T:,_;";
        String[] months = new String[]{"january", "febuary", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};
        String[] mons = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        String[] tok = new String[10];
        boolean[] want = new boolean[7];
        Arrays.fill(want, false);
        String delimiters = " \t/-:,_;";
        int c = s.indexOf(90);
        if (c != -1) {
            s = s.substring(0, c);
        }
        if ((end_of_date = s.indexOf(84)) != -1) {
            c = end_of_date - 1;
            if (Character.isDigit(s.charAt(c))) {
                delimiters = " \t/-T:,_;";
            } else {
                end_of_date = -1;
            }
        }
        if (end_of_date == -1) {
            n = 0;
            len = s.length();
            for (i = 0; i < len; ++i) {
                c = delimiters.substring(2).indexOf(s.charAt(i));
                if (c != -1) {
                    ++n;
                }
                if (n != 3) continue;
                end_of_date = i;
                break;
            }
        }
        GregorianCalendar curdate = new GregorianCalendar();
        curdate.setTime(new Date());
        int year = curdate.get(1);
        int month = 0;
        int day_month = 0;
        int day_year = 0;
        int hour = 0;
        int minute = 0;
        double second = 0.0;
        StringTokenizer st = new StringTokenizer(s, delimiters);
        if (!st.hasMoreTokens()) {
            throw new ParseException("No tokens in '" + s + "'", 0);
        }
        for (n = 0; n < 10 && st.hasMoreTokens(); ++n) {
            tok[n] = st.nextToken();
        }
        want[3] = true;
        want[2] = true;
        want[1] = true;
        want[0] = true;
        int hold = 0;
        int tokIndex = -1;
        for (i = 0; i < n; ++i) {
            double value;
            tokIndex = s.indexOf(tok[i], tokIndex + 1);
            if (end_of_date != -1 && want[0] && tokIndex > end_of_date) {
                want[0] = false;
                want[6] = true;
                want[5] = true;
                want[4] = true;
            }
            len = tok[i].length();
            try {
                value = Double.parseDouble(tok[i]);
            }
            catch (NumberFormatException e) {
                if (len < 3 || !want[0]) {
                    throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
                }
                for (int j = 0; j < 12; ++j) {
                    if (!tok[i].equalsIgnoreCase(months[j]) && !tok[i].equalsIgnoreCase(mons[j])) continue;
                    month = j + 1;
                    want[2] = false;
                    if (hold <= 0) break;
                    if (day_month > 0) {
                        throw new ParseException("Ambiguous dates in token '" + tok[i] + "' in '" + s + "'", 0);
                    }
                    day_month = hold;
                    hold = 0;
                    want[3] = false;
                    break;
                }
                if (!want[2]) continue;
                throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
            }
            if (Math.IEEEremainder(value, 1.0) != 0.0) {
                if (!want[6]) throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
                second = value;
                break;
            }
            int number = (int)value;
            if (number < 0) {
                throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
            }
            if (want[0]) {
                if (number == 0) {
                    throw new ParseException("m,d, or y can't be 0 in '" + s + "'", 0);
                }
                if (number > 31) {
                    if (want[1]) {
                        year = number;
                        if (year < 1000) {
                            year += 1900;
                        }
                        want[1] = false;
                    } else {
                        if (!want[2]) throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
                        want[2] = false;
                        month = 0;
                        day_year = number;
                        want[3] = false;
                    }
                } else if (number > 12) {
                    if (!want[3]) throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
                    if (hold > 0) {
                        month = hold;
                        want[2] = false;
                    }
                    if (len == 3) {
                        if (month > 0) {
                            throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
                        }
                        day_year = number;
                        day_month = 0;
                        want[2] = false;
                    } else {
                        day_month = number;
                    }
                    want[3] = false;
                } else if (!want[2]) {
                    if (month > 0) {
                        day_month = number;
                        day_year = 0;
                    } else {
                        day_year = number;
                        day_month = 0;
                    }
                    want[3] = false;
                } else if (!want[3]) {
                    if (day_year > 0) {
                        throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
                    }
                    month = number;
                    want[2] = false;
                } else if (!want[1]) {
                    if (len == 3) {
                        if (month > 0) {
                            throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
                        }
                        day_year = number;
                        day_month = 0;
                        want[3] = false;
                    } else {
                        if (day_year > 0) {
                            throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
                        }
                        month = number;
                        if (hold > 0) {
                            day_month = hold;
                            want[3] = false;
                        }
                    }
                    want[2] = false;
                } else if (hold > 0) {
                    month = hold;
                    hold = 0;
                    want[2] = false;
                    day_month = number;
                    want[3] = false;
                } else {
                    hold = number;
                }
                if (want[1] || want[2] || want[3]) continue;
                want[0] = false;
                want[6] = true;
                want[5] = true;
                want[4] = true;
                continue;
            }
            if (want[4]) {
                if (len == 4) {
                    hold = number / 100;
                    if (hold > 23) {
                        throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
                    }
                    hour = hold;
                    hold = number % 100;
                    if (hold > 59) {
                        throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
                    }
                    minute = hold;
                    want[5] = false;
                } else {
                    if (number > 23) {
                        throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
                    }
                    hour = number;
                }
                want[4] = false;
                continue;
            }
            if (want[5]) {
                if (number > 59) {
                    throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
                }
                minute = number;
                want[5] = false;
                continue;
            }
            if (!want[6]) throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
            if (number > 61) {
                throw new ParseException("Error at token '" + tok[i] + "' in '" + s + "'", 0);
            }
            second = number;
            want[6] = false;
        }
        if (month > 12) {
            throw new ParseException("Month is greater than 12 in '" + s + "'", 0);
        }
        if (month > 0 && day_month <= 0) {
            day_month = 1;
        }
        int n2 = (year & 3) > 0 ? 0 : (year % 100 > 0 ? 1 : (leap = year % 400 > 0 ? 0 : 1));
        if (month > 0 && day_month > 0 && day_year == 0) {
            if (day_month > daysInMonth[leap][month]) {
                throw new ParseException("day of month too high in '" + s + "'", 0);
            }
            day_year = dayOffset[leap][month] + day_month;
        } else {
            if (day_year <= 0 || month != 0 || day_month != 0) throw new ParseException("Need month/day or doy in '" + s + "'", 0);
            if (day_year > 365 + leap) {
                throw new ParseException("day of year too high in '" + s + "'", 0);
            }
            for (i = 2; i < 14 && day_year > dayOffset[leap][i]; ++i) {
            }
            month = --i;
            day_month = day_year - dayOffset[leap][i];
        }
        TimeStruct result = new TimeStruct();
        result.year = year;
        result.month = month;
        result.day = day_month;
        result.doy = day_year;
        result.hour = hour;
        result.minute = minute;
        result.seconds = second;
        result.want = want;
        return result;
    }

    public static Datum create(String s) throws ParseException {
        TimeStruct ts = TimeUtil.parseTime(s);
        return TimeUtil.toDatum(ts);
    }

    public static Datum createValid(String validString) {
        try {
            return TimeUtil.create(validString);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isValidTime(String string) {
        try {
            TimeUtil.create(string);
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println(TimeUtil.now());
        System.out.println(Datum.create(TimeUtil.convert(2000, 1, 2, 0, 0, 0.0, Units.us2000), (Units)Units.us2000));
        Datum x = TimeUtil.create("2000-1-1 0:00:33.45");
        System.out.println(x);
        TimeStruct ts = TimeUtil.toTimeStruct(x);
        System.out.println(TimeUtil.toDatum(ts));
        TimeDatumFormatter tf = TimeDatumFormatter.DEFAULT;
        for (int i = 0; i < 44; ++i) {
            System.out.println(tf.format(x) + "\t" + (long)x.doubleValue(Units.us2000));
            x = TimeUtil.prev(6, x);
        }
    }

    public static Datum prevMidnight(Datum datum) {
        return datum.subtract(TimeUtil.getSecondsSinceMidnight(datum), Units.seconds);
    }

    public static Datum createTimeDatum(int year, int month, int day, int hour, int minute, int second, int nano) {
        if (year < 1960) {
            throw new IllegalArgumentException("year must be > 1960, and no 2 digit years (year=" + year + ")");
        }
        int jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029;
        double microseconds = (double)second * 1000000.0 + (double)hour * 3.6E9 + (double)minute * 6.0E7 + (double)nano / 1000.0;
        double us2000 = UnitsConverter.getConverter(Units.mj1958, Units.us2000).convert(jd - 2436205) + microseconds;
        return Datum.create(us2000, (Units)Units.us2000);
    }

    public static final class TimeStruct {
        public int year;
        public int month;
        public int day;
        public int doy;
        public int hour;
        public int minute;
        public double seconds;
        public boolean[] want;

        public String toString() {
            return this.year + "/" + this.month + "/" + this.day + " " + this.hour + ":" + this.minute + ":" + this.seconds;
        }
    }
}

