/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.NumberUnits;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;

public class LocationUnits
extends NumberUnits {
    Units offsetUnits;

    public LocationUnits(String id, String description, Units offsetUnits) {
        super(id, description);
        this.offsetUnits = offsetUnits;
    }

    public Units getOffsetUnits() {
        return this.offsetUnits;
    }

    public Datum add(Number a, Number b, Units bUnits) {
        if (bUnits instanceof LocationUnits) {
            throw new IllegalArgumentException("You can't add " + this + " to " + bUnits + ", they both identify a location in a space");
        }
        Units offsetUnits = this.getOffsetUnits();
        if (bUnits != offsetUnits) {
            UnitsConverter uc = Units.getConverter(bUnits, offsetUnits);
            b = uc.convert(b);
        }
        return this.createDatum(LocationUnits.add(a, b));
    }

    public Datum divide(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("multiplication of locationUnits");
    }

    public Datum multiply(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("division of locationUnits");
    }

    public Datum subtract(Number a, Number b, Units bUnits) {
        if (bUnits instanceof LocationUnits) {
            if (this != bUnits) {
                b = bUnits.getConverter(this).convert(b);
            }
            return this.getOffsetUnits().createDatum(LocationUnits.subtract(a, b));
        }
        if (bUnits != this.getOffsetUnits()) {
            b = bUnits.getConverter(this.getOffsetUnits()).convert(b);
        }
        return this.createDatum(LocationUnits.subtract(a, b));
    }
}

