/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatterFactory;
import edu.uiowa.physics.pw.das.datum.format.EnumerationDatumFormatterFactory;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;

public class EnumerationUnits
extends Units {
    private HashMap ordinals = new HashMap();
    private int highestOrdinal = 0;
    private HashMap objects = new HashMap();
    private HashMap invObjects = new HashMap();
    public static HashMap unitsInstances;

    public EnumerationUnits(String id) {
        this(id, "");
    }

    public EnumerationUnits(String id, String description) {
        super(id, description);
    }

    public static Datum createDatumAndUnits(Object object) {
        return EnumerationUnits.create(object).createDatum(object);
    }

    public DatumVector createDatumVector(Object[] objects) {
        double[] doubles = new double[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            doubles[i] = this.createDatum(objects[i]).doubleValue(this);
        }
        return DatumVector.newDatumVector(doubles, (Units)this);
    }

    public Datum createDatum(Object object) {
        if (this.objects.containsKey(object)) {
            return (Datum)this.objects.get(object);
        }
        ++this.highestOrdinal;
        Integer ordinal = new Integer(this.highestOrdinal);
        Datum.Double result = new Datum.Double(ordinal, (Units)this);
        this.ordinals.put(ordinal, result);
        this.invObjects.put(result, object);
        this.objects.put(object, result);
        return result;
    }

    public Datum createDatum(int value) {
        Integer key = new Integer(value);
        if (this.ordinals.containsKey(key)) {
            return (Datum)this.ordinals.get(key);
        }
        throw new IllegalArgumentException("No Datum exists for this ordinal");
    }

    public Datum createDatum(long value) {
        return this.createDatum((int)value);
    }

    public Datum createDatum(Number value) {
        return this.createDatum(value.intValue());
    }

    public Object getObject(Datum datum) {
        if (this.invObjects.containsKey(datum)) {
            return this.invObjects.get(datum);
        }
        throw new IllegalArgumentException("This Datum doesn't map back to an object!  This shouldn't happen!");
    }

    public static EnumerationUnits create(Object o) {
        Class<?> c;
        if (unitsInstances == null) {
            unitsInstances = new HashMap();
        }
        if (unitsInstances.containsKey(c = o.getClass())) {
            return (EnumerationUnits)unitsInstances.get(c);
        }
        EnumerationUnits result = new EnumerationUnits(c.toString() + "Unit");
        unitsInstances.put(c, result);
        return result;
    }

    public Datum createDatum(double d) {
        return this.createDatum((int)d);
    }

    public DatumFormatterFactory getDatumFormatterFactory() {
        return EnumerationDatumFormatterFactory.getInstance();
    }

    public Datum subtract(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("subtract on EnumerationUnit");
    }

    public Datum add(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("add on EnumerationUnit");
    }

    public Datum divide(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("divide on EnumerationUnit");
    }

    public Datum multiply(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("multiply on EnumerationUnit");
    }

    public Datum parse(String s) throws ParseException {
        Datum result = null;
        Iterator i = this.objects.keySet().iterator();
        while (i.hasNext()) {
            Object key = this.objects.get(i.next());
            if (!key.toString().equals(s)) continue;
            if (result == null) {
                result = (Datum)this.objects.get(key);
                continue;
            }
            throw new IllegalStateException("Multiple Objects' string representations match");
        }
        if (result == null) {
            throw new ParseException("no objects match \"" + s + "\"", 0);
        }
        return result;
    }
}

