/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset.test;

import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.test.FunctionTableDataSet;
import edu.uiowa.physics.pw.das.datum.Units;

public final class RipplesDataSet
extends FunctionTableDataSet
implements TableDataSet {
    double x1;
    double y1;
    double p1;
    double x2;
    double y2;
    double p2;

    public RipplesDataSet() {
        this(2.0, 3.0, 1.0, 13.0, 15.0, 2.0, 30, 30);
    }

    public RipplesDataSet(double x1, double y1, double p1, double x2, double y2, double p2, int xlength, int ylength) {
        super(xlength, ylength);
        this.x1 = x1;
        this.y1 = y1;
        this.p1 = p1;
        this.x2 = x2;
        this.y2 = y2;
        this.p2 = p2;
        this.fillCache();
    }

    public double getDoubleImpl(int i, int j, Units units) {
        double x = this.getXTagDouble(i, this.xUnits);
        double y = this.getYTagDouble(0, j, this.yUnits);
        if (12.0 < x && x < 14.0) {
            return units.getFillDouble();
        }
        double rad1 = Math.sqrt((x - this.x1) * (x - this.x1) + (y - this.y1) * (y - this.y1));
        double exp1 = Math.exp(-rad1 / this.p1) * Math.cos(Math.PI * rad1 / this.p1);
        double rad2 = Math.sqrt((x - this.x2) * (x - this.x2) + (y - this.y2) * (y - this.y2));
        double exp2 = Math.exp(-rad2 / this.p2) * Math.cos(Math.PI * rad2 / this.p2);
        double z = exp1 + exp2;
        return this.zUnits.convertDoubleTo(units, z);
    }
}

