/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset.test;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import javax.swing.JFrame;

public class PolynomialDataSetDescriptor
extends DataSetDescriptor {
    private Units xUnits;
    private Units yUnits;
    private double[] c;
    private double minDx;
    private double xOffset;

    public PolynomialDataSetDescriptor(double[] c, Units xUnits, Units yUnits, Datum resolution) {
        this.xUnits = xUnits;
        this.yUnits = yUnits;
        this.c = (double[])c.clone();
        this.minDx = resolution.doubleValue(xUnits.getOffsetUnits());
        this.xOffset = 0.0;
    }

    public PolynomialDataSetDescriptor(double[] c, Units xUnits, Units yUnits, Datum resolution, Datum xOffset) {
        this(c, xUnits, yUnits, resolution);
        this.xOffset = xOffset.doubleValue(xUnits);
    }

    protected DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, DasProgressMonitor dasProgressMonitor) throws DasException {
        double x0 = start.doubleValue(this.xUnits) - this.xOffset;
        double x1 = end.doubleValue(this.xUnits) - this.xOffset;
        double dx = resolution == null ? this.minDx : Math.max(this.minDx, resolution.doubleValue(this.xUnits.getOffsetUnits()));
        VectorDataSetBuilder builder = new VectorDataSetBuilder(this.xUnits, this.yUnits);
        double x = x0;
        int i = 0;
        while (x < x1) {
            builder.insertY(x, this.eval(x));
            x = x0 + (double)(++i) * dx;
        }
        builder.insertY(x1, this.eval(x1));
        return builder.toVectorDataSet();
    }

    private double eval(double x) {
        double y = 0.0;
        for (int ic = this.c.length - 1; ic >= 0; --ic) {
            y = this.c[ic] + x * y;
        }
        return y;
    }

    public Units getXUnits() {
        return this.xUnits;
    }

    public static void main(String[] args) {
        double[] c = new double[]{90.0, 3.0, -1.0};
        PolynomialDataSetDescriptor dsd = new PolynomialDataSetDescriptor(c, Units.dimensionless, Units.dimensionless, Datum.create(1.0));
        DasAxis xAxis = new DasAxis(Datum.create(-10.0), Datum.create(10.0), 2);
        DasAxis yAxis = new DasAxis(Datum.create(0.0), Datum.create(100.0), 3);
        DasPlot plot = new DasPlot(xAxis, yAxis);
        plot.addRenderer(new SymbolLineRenderer(dsd));
        DasCanvas canvas = new DasCanvas(400, 400);
        canvas.add(plot, new DasRow(canvas, 0.1, 0.9), new DasColumn(canvas, 0.1, 0.9));
        JFrame frame = new JFrame("Polynomial");
        frame.setContentPane(canvas);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }
}

