/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset.test;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;

public class MendelbrotDataSetDescriptor
extends DataSetDescriptor {
    DasAxis yAxis;

    public MendelbrotDataSetDescriptor(DasAxis yAxis) {
        this.yAxis = yAxis;
    }

    private float punktfarbe(double xwert, double ywert) {
        int j;
        double r = 0.0;
        double i = 0.0;
        double m = 0.0;
        int MAX = 256;
        for (j = 0; j < 256 && m < 4.0; ++j) {
            m = r * r - i * i;
            i = 2.0 * r * i + ywert;
            r = m + xwert;
        }
        if (j == 256) {
            j = 0;
        }
        return (float)j / 256.0f;
    }

    protected DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, DasProgressMonitor monitor) throws DasException {
        int ix;
        double xstart = start.doubleValue(Units.dimensionless);
        double xend = end.doubleValue(Units.dimensionless);
        double xresolution = resolution.doubleValue(Units.dimensionless);
        double ystart = this.yAxis.getDataMinimum(Units.dimensionless);
        double yend = this.yAxis.getDataMaximum(Units.dimensionless);
        int _ny = this.yAxis.getRow().getHeight();
        double yresolution = (yend - ystart) / (double)_ny;
        int ny = (int)(2.0 * ((yend - ystart) / yresolution));
        int nx = (int)(2.0 * ((xend - xstart) / xresolution));
        double[][] z = new double[nx][ny];
        monitor.setTaskSize(ny);
        monitor.started();
        for (int iy = 0; iy < ny && !monitor.isCancelled(); ++iy) {
            monitor.setTaskProgress(iy);
            for (ix = 0; ix < nx; ++ix) {
                z[ix][iy] = this.punktfarbe(xstart + (double)ix * xresolution, ystart + (double)iy * yresolution);
            }
        }
        monitor.finished();
        double[] xtags = new double[nx];
        for (ix = 0; ix < nx; ++ix) {
            xtags[ix] = xstart + (double)ix * xresolution;
        }
        double[] ytags = new double[ny];
        for (int iy = 0; iy < ny; ++iy) {
            ytags[iy] = ystart + (double)iy * yresolution;
        }
        return DefaultTableDataSet.createSimple(xtags, ytags, z);
    }

    public Units getXUnits() {
        return Units.dimensionless;
    }
}

