/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.LocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.DataTransferType;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamProducer;
import edu.uiowa.physics.pw.das.stream.StreamXDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.FixedWidthFormatter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Map;

public class TableUtil {
    public static double[] getYTagArrayDouble(TableDataSet table, int itable, Units units) {
        double[] yy = new double[table.getYLength(itable)];
        for (int j = 0; j < yy.length; ++j) {
            yy[j] = table.getYTagDouble(itable, j, units);
        }
        return yy;
    }

    public static Datum getLargestYTag(TableDataSet tds) {
        Datum result = tds.getYTagDatum(0, tds.getYLength(0) - 1);
        for (int itable = 1; itable < tds.tableCount(); ++itable) {
            Datum r = tds.getYTagDatum(itable, tds.getYLength(itable) - 1);
            if (!r.gt(result)) continue;
            result = r;
        }
        return result;
    }

    public static Datum getSmallestYTag(TableDataSet tds) {
        Datum result = tds.getYTagDatum(0, 0);
        for (int itable = 1; itable < tds.tableCount(); ++itable) {
            Datum r = tds.getYTagDatum(itable, 0);
            if (!r.lt(result)) continue;
            result = r;
        }
        return result;
    }

    public static int closestRow(TableDataSet table, int itable, Datum datum) {
        return TableUtil.closestRow(table, itable, datum.doubleValue(datum.getUnits()), datum.getUnits());
    }

    public static int closestRow(TableDataSet table, int itable, double x, Units units) {
        double[] xx = TableUtil.getYTagArrayDouble(table, itable, units);
        return DataSetUtil.closest(xx, x);
    }

    public static Datum closestDatum(TableDataSet table, Datum x, Datum y) {
        int i = DataSetUtil.closestColumn(table, x);
        int j = TableUtil.closestRow(table, table.tableOfIndex(i), y);
        return table.getDatum(i, j);
    }

    public static int tableIndexAt(TableDataSet table, int i) {
        int itable = 0;
        while (table.tableEnd(itable) <= i) {
            ++itable;
        }
        return itable;
    }

    public static Datum guessYTagWidth(TableDataSet table) {
        double y0 = table.getYTagDouble(0, 0, table.getYUnits());
        double y1 = table.getYTagDouble(0, 1, table.getYUnits());
        int n = table.getYLength(0) - 1;
        double yn = table.getYTagDouble(0, n, table.getYUnits());
        if ((yn - y0) / ((y1 - y0) * (double)n) > 10.0) {
            return Units.percent.createDatum((y1 / y0 - 1.0) * 100.0);
        }
        return table.getYUnits().createDatum(y1 - y0);
    }

    public static double tableMax(TableDataSet tds) {
        double result = Double.NEGATIVE_INFINITY;
        for (int itable = 0; itable < tds.tableCount(); ++itable) {
            int ny = tds.getYLength(itable);
            for (int i = tds.tableStart(itable); i < tds.tableEnd(itable); ++i) {
                for (int j = 0; j < ny; ++j) {
                    if (!(tds.getDouble(i, j, tds.getZUnits()) > result)) continue;
                    result = tds.getDouble(i, j, tds.getZUnits());
                }
            }
        }
        return result;
    }

    public static void checkForNaN(TableDataSet tds) {
        for (int i = 0; i < tds.getXLength(); ++i) {
            for (int j = 0; j < 16; ++j) {
                double zz = tds.getDouble(i, j, tds.getZUnits());
                if (!Double.isNaN(zz)) continue;
                System.out.println("found NaN at " + i + "," + j);
                if (tds.getPlanarView("weights") == null) continue;
                System.out.println("  weight: " + ((TableDataSet)tds.getPlanarView("weights")).getDouble(i, j, Units.dimensionless));
            }
        }
    }

    protected static void checkForNaN(double[][] t) {
        for (int i = 0; i < t.length; ++i) {
            for (int j = 0; j < t[0].length; ++j) {
                double zz = t[i][j];
                if (!Double.isNaN(zz)) continue;
                System.out.println("found NaN at " + i + "," + j);
            }
        }
    }

    public static String toString(TableDataSet tds) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(tds.getYLength(0));
        for (int i = 1; i < tds.tableCount(); ++i) {
            buffer.append(", " + tds.getYLength(i));
        }
        return "[" + tds.getXLength() + " xTags, " + buffer.toString() + " yTags]";
    }

    public static DatumVector getDatumVector(TableDataSet tds, int i) {
        Units zunits = tds.getZUnits();
        double[] array = new double[tds.getYLength(tds.tableOfIndex(i))];
        for (int j = 0; j < array.length; ++j) {
            array[j] = tds.getDouble(i, j, zunits);
        }
        return DatumVector.newDatumVector(array, zunits);
    }

    public static DatumVector getYTagsDatumVector(TableDataSet tds, int itable) {
        Units yunits = tds.getYUnits();
        DatumVector result = DatumVector.newDatumVector(TableUtil.getYTagArrayDouble(tds, itable, yunits), yunits);
        return result;
    }

    public static void dumpToAsciiStream(TableDataSet tds, Datum xmin, Datum xmax, OutputStream out) {
        PrintStream pout = new PrintStream(out);
        Datum base = null;
        Units offsetUnits = null;
        pout.print("This is not a das2 stream, even though it looks like it.");
        pout.print("[00]");
        pout.println("<stream start=\"" + xmin + "\" end=\"" + xmax + "\" >");
        pout.println("<comment>Stream creation date: " + TimeUtil.now().toString() + "</comment>");
        pout.print("</stream>");
        if (tds.getXUnits() instanceof LocationUnits && (offsetUnits = ((LocationUnits)(base = xmin).getUnits()).getOffsetUnits()) == Units.microseconds) {
            offsetUnits = Units.seconds;
        }
        pout.print("[01]<packet>\n");
        pout.print("<x type=\"asciiTab10\" ");
        if (base != null) {
            pout.print("base=\"" + base + "\" ");
            pout.print(" xUnits=\"" + offsetUnits + "\" ");
        } else {
            pout.print(" xUnits=\"" + tds.getXUnits());
        }
        pout.println(" />");
        String yTagsString = "" + tds.getYTagDatum(0, 0);
        for (int j = 1; j < tds.getYLength(0); ++j) {
            yTagsString = yTagsString + ", " + tds.getYTagDatum(0, j);
        }
        pout.println("<yscan type=\"asciiTab10\" zUnits=\"" + tds.getZUnits() + "\" yTags=\"" + yTagsString + "\"/>");
        pout.print("</packet>");
        DecimalFormat xnf = new DecimalFormat("00000.000");
        DecimalFormat ynf = new DecimalFormat("0.00E00");
        double dx = xmax.subtract(xmin).doubleValue(offsetUnits);
        for (int i = 0; i < tds.getXLength(); ++i) {
            double x = base != null ? tds.getXTagDatum(i).subtract(base).doubleValue(offsetUnits) : tds.getXTagDouble(i, tds.getXUnits());
            if (!(x >= 0.0) || !(x < dx)) continue;
            pout.print(":01:");
            pout.print(xnf.format(x) + " ");
            int itable = tds.tableOfIndex(i);
            for (int j = 0; j < tds.getYLength(itable); ++j) {
                String delim = j + 1 == tds.getYLength(itable) ? "\n" : " ";
                pout.print(FixedWidthFormatter.format(ynf.format(tds.getDouble(i, j, tds.getZUnits())), 9) + delim);
            }
        }
        pout.close();
    }

    public static void dumpToAsciiStream(TableDataSet tds, OutputStream out) {
        TableUtil.dumpToAsciiStream(tds, Channels.newChannel(out));
    }

    public static void dumpToAsciiStream(TableDataSet tds, WritableByteChannel out) {
        TableUtil.dumpToDas2Stream(tds, out, true);
    }

    public static void dumpToDas2Stream(TableDataSet tds, OutputStream out, boolean asciiTransferTypes) {
        TableUtil.dumpToDas2Stream(tds, Channels.newChannel(out), asciiTransferTypes);
    }

    public static void dumpToBinaryStream(TableDataSet tds, OutputStream out) {
        TableUtil.dumpToDas2Stream(tds, Channels.newChannel(out), false);
    }

    private static void dumpToDas2Stream(TableDataSet tds, WritableByteChannel out, boolean asciiTransferTypes) {
        try {
            DataTransferType xTransferType;
            DataTransferType zTransferType;
            StreamProducer producer = new StreamProducer(out);
            StreamDescriptor sd = new StreamDescriptor();
            sd.setProperty("start", tds.getXTagDatum(0).toString());
            sd.setProperty("end", tds.getXTagDatum(tds.getXLength() - 1));
            Map properties = tds.getProperties();
            Iterator i = properties.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                sd.setProperty(key, properties.get(key));
            }
            if (asciiTransferTypes) {
                zTransferType = DataTransferType.getByName("ascii10");
                xTransferType = DataTransferType.getByName("ascii24");
            } else {
                zTransferType = DataTransferType.getByName("sun_real4");
                xTransferType = DataTransferType.getByName("sun_real8");
            }
            producer.streamDescriptor(sd);
            DatumVector[] zValues = new DatumVector[1];
            for (int table = 0; table < tds.tableCount(); ++table) {
                StreamXDescriptor xDescriptor = new StreamXDescriptor();
                xDescriptor.setDataTransferType(xTransferType);
                xDescriptor.setUnits(tds.getXUnits());
                StreamYScanDescriptor yDescriptor = new StreamYScanDescriptor();
                yDescriptor.setDataTransferType(zTransferType);
                yDescriptor.setZUnits(tds.getZUnits());
                yDescriptor.setYCoordinates(tds.getYTags(table));
                PacketDescriptor pd = new PacketDescriptor();
                pd.setXDescriptor(xDescriptor);
                pd.addYDescriptor(yDescriptor);
                producer.packetDescriptor(pd);
                for (int i2 = tds.tableStart(table); i2 < tds.tableEnd(table); ++i2) {
                    Datum xTag = tds.getXTagDatum(i2);
                    zValues[0] = tds.getScan(i2);
                    producer.packet(pd, xTag, zValues);
                }
            }
            producer.streamClosed(sd);
        }
        catch (StreamException se) {
            throw new RuntimeException(se);
        }
    }

    public static int getPreviousRow(TableDataSet ds, int itable, Datum datum) {
        int i = TableUtil.closestRow(ds, itable, datum);
        if (i > 0 && ds.getYTagDatum(itable, i).gt(datum)) {
            return i - 1;
        }
        return i;
    }

    public static int getNextRow(TableDataSet ds, int itable, Datum datum) {
        int i = TableUtil.closestRow(ds, itable, datum);
        if (i < ds.getXLength() - 1 && ds.getYTagDatum(itable, i).lt(datum)) {
            return i + 1;
        }
        return i;
    }
}

