/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Map;

public class SyncUtil {
    private static int[] calculateImap(DataSet source, DataSet target) {
        int[] imap = new int[target.getXLength()];
        Units xunits = source.getXUnits();
        Datum xTagWidth = (Datum)source.getProperty("xTagWidth");
        if (xTagWidth == null) {
            xTagWidth = DataSetUtil.guessXTagWidth(source);
        }
        for (int i = 0; i < imap.length; ++i) {
            double xx = target.getXTagDouble(i, xunits);
            imap[i] = DataSetUtil.closestColumn(source, xx, xunits);
            Datum xclose = source.getXTagDatum(imap[i]);
            if (!(Math.abs(xclose.subtract(xx, xunits).doubleValue(xunits)) > xTagWidth.doubleValue(xunits) / 2.0)) continue;
            imap[i] = -1;
        }
        return imap;
    }

    private static int[] calculateImapForWidthTags(DataSet source, DataSet target) {
        int[] imap = new int[target.getXLength()];
        Units xunits = source.getXUnits();
        String widthsPlane = "xTagWidth";
        VectorDataSet widthsDs = (VectorDataSet)source.getPlanarView(widthsPlane);
        for (int i = 0; i < imap.length; ++i) {
            imap[i] = -1;
            Datum tt = target.getXTagDatum(i);
            Datum s1 = null;
            for (int k = 0; (s1 == null || s1.le(tt)) && k < source.getXLength(); ++k) {
                s1 = source.getXTagDatum(k);
                Datum s2 = s1.add(widthsDs.getDatum(k));
                if (!s1.le(tt) || !tt.lt(s2)) continue;
                imap[i] = k;
            }
        }
        return imap;
    }

    public static DataSet syncronizeNearestNeighbor(DataSet source, DataSet target) {
        if (source instanceof VectorDataSet) {
            return NearestNeighborVectorDataSet.create((VectorDataSet)source, target);
        }
        throw new IllegalArgumentException("Unsupported DataSet Type: " + source);
    }

    private static class NearestNeighborVectorDataSet
    implements VectorDataSet {
        VectorDataSet source;
        int[] imap;
        double[] xtags;

        NearestNeighborVectorDataSet(VectorDataSet source, int[] imap, double[] xtags) {
            this.source = source;
            this.imap = imap;
            this.xtags = xtags;
        }

        private static NearestNeighborVectorDataSet create(VectorDataSet source, DataSet target) {
            if (source.getPlanarView("xTagWidth") != null) {
                return new NearestNeighborVectorDataSet(source, SyncUtil.calculateImapForWidthTags(source, target), DataSetUtil.getXTagArrayDouble(target, source.getXUnits()));
            }
            return new NearestNeighborVectorDataSet(source, SyncUtil.calculateImap(source, target), DataSetUtil.getXTagArrayDouble(target, source.getXUnits()));
        }

        public Datum getDatum(int i) {
            if (this.imap[i] != -1) {
                return this.source.getDatum(this.imap[i]);
            }
            return this.source.getYUnits().createDatum(this.source.getYUnits().getFillDouble());
        }

        public double getDouble(int i, Units units) {
            if (this.imap[i] != -1) {
                return this.source.getDouble(this.imap[i], units);
            }
            return units.getFillDouble();
        }

        public int getInt(int i, Units units) {
            if (this.imap[i] != -1) {
                return this.source.getInt(this.imap[i], units);
            }
            return units.getFillInt();
        }

        public DataSet getPlanarView(String planeID) {
            return new NearestNeighborVectorDataSet((VectorDataSet)this.source.getPlanarView(planeID), this.imap, this.xtags);
        }

        public String[] getPlaneIds() {
            return this.source.getPlaneIds();
        }

        public Object getProperty(String name) {
            return this.source.getProperty(name);
        }

        public Map getProperties() {
            return this.source.getProperties();
        }

        public int getXLength() {
            return this.imap.length;
        }

        public Datum getXTagDatum(int i) {
            return this.getXUnits().createDatum(this.xtags[i]);
        }

        public double getXTagDouble(int i, Units units) {
            return this.getXUnits().convertDoubleTo(units, this.imap[i]);
        }

        public int getXTagInt(int i, Units units) {
            throw new IllegalArgumentException("not implemented");
        }

        public Units getXUnits() {
            return this.source.getXUnits();
        }

        public Units getYUnits() {
            return this.source.getYUnits();
        }
    }
}

