/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.util.DasDie;

public class DataSetCache {
    protected Tag[] buffer = new Tag[1];
    private boolean enabled = true;
    public int hits = 0;
    public int misses = 0;

    public void store(DataSetDescriptor dsd, Datum start, Datum end, Datum resolution, DataSet data) {
        if (!this.enabled) {
            return;
        }
        Tag tag = new Tag(dsd, start, end, resolution, data);
        int iMin = -1;
        for (int i = this.buffer.length - 1; i >= 0; --i) {
            if (this.buffer[i] != null) continue;
            iMin = i;
        }
        if (iMin == -1) {
            long oldestAccess = Long.MAX_VALUE;
            int oldest = -1;
            for (int i = this.buffer.length - 1; i >= 0; --i) {
                if (this.buffer[i].lastAccess >= oldestAccess) continue;
                oldest = i;
                oldestAccess = this.buffer[i].lastAccess;
            }
            iMin = oldest;
        }
        this.buffer[iMin] = tag;
    }

    int findStored(DataSetDescriptor dsd, Datum start, Datum end, Datum resolution) {
        Tag tag = new Tag(dsd, start, end, resolution, null);
        int iHit = -1;
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] == null || !this.buffer[i].isWithin(tag)) continue;
            iHit = i;
        }
        return iHit;
    }

    public boolean haveStored(DataSetDescriptor dsd, Datum start, Datum end, Datum resolution) {
        Tag tag = new Tag(dsd, start, end, resolution, null);
        DasDie.println(this.toString());
        DasDie.println("    need: " + tag.toString());
        int iHit = this.findStored(dsd, start, end, resolution);
        if (iHit != -1) {
            ++this.hits;
            return true;
        }
        ++this.misses;
        return false;
    }

    public DataSet retrieve(DataSetDescriptor dsd, Datum start, Datum end, Datum resolution) {
        int iHit = this.findStored(dsd, start, end, resolution);
        if (iHit != -1) {
            DasDie.println(" time offset= " + this.buffer[iHit].start.subtract(start));
            ++this.buffer[iHit].nhits;
            this.buffer[iHit].lastAccess = System.currentTimeMillis();
            return this.buffer[iHit].data;
        }
        throw new IllegalArgumentException("Data not found in buffer");
    }

    public void reset() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = null;
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.reset();
        }
    }

    public double calcHitRate() {
        return (double)this.hits * 100.0 / (double)(this.hits + this.misses);
    }

    public String toString() {
        String result = "\n---DataSetCache---\n";
        for (int i = 0; i < this.buffer.length; ++i) {
            result = result + "Buffer " + i + ": ";
            result = this.buffer[i] != null ? result + this.buffer[i].toString() : result + "";
            result = result + "\n";
        }
        result = result + "-------------------";
        return result;
    }

    protected class Tag {
        protected DataSetDescriptor dsd;
        protected Datum start;
        protected Datum end;
        protected Datum resolution;
        protected DataSet data;
        protected int nhits;
        protected long birthTime;
        protected long lastAccess;

        Tag() {
            this(null, null, null, null, null);
        }

        Tag(DataSetDescriptor dsd, Datum start, Datum end, Datum resolution, DataSet data) {
            this.dsd = dsd;
            this.start = start;
            this.end = end;
            this.resolution = resolution;
            this.data = data;
            this.nhits = 0;
            this.lastAccess = this.birthTime = System.currentTimeMillis();
        }

        public DataSet getData() {
            return this.data;
        }

        protected boolean isWithin(Tag tag) {
            boolean result = this.dsd != null && tag.dsd != null;
            result = result && tag.dsd.toString().equals(this.dsd.toString());
            result = result && tag.start.compareTo(this.start) >= 0 && tag.end.compareTo(this.end) <= 0;
            result = result && tag.resolution.ge(this.resolution);
            return result;
        }

        public String toString() {
            return this.dsd.toString() + " " + this.start.toString() + " - " + this.end.toString() + " @ " + this.resolution + "s  [" + this.nhits + " hits]";
        }
    }
}

