/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dasml.FormButton;
import edu.uiowa.physics.pw.das.dasml.FormCheckBox;
import edu.uiowa.physics.pw.das.dasml.FormChoice;
import edu.uiowa.physics.pw.das.dasml.FormComponent;
import edu.uiowa.physics.pw.das.dasml.FormContainer;
import edu.uiowa.physics.pw.das.dasml.FormList;
import edu.uiowa.physics.pw.das.dasml.FormPanel;
import edu.uiowa.physics.pw.das.dasml.FormRadioButtonGroup;
import edu.uiowa.physics.pw.das.dasml.FormText;
import edu.uiowa.physics.pw.das.dasml.FormTextField;
import edu.uiowa.physics.pw.das.dasml.Orientation;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.dasml.TransferableFormComponent;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableCanvas;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FormTab
extends FormContainer {
    private String label;
    private String dasName;

    public FormTab(String name, String label) {
        DataFlavor[] flavors = new DataFlavor[]{TransferableFormComponent.BUTTONGROUP_FLAVOR, TransferableFormComponent.BUTTON_FLAVOR, TransferableFormComponent.CHECKBOX_FLAVOR, TransferableFormComponent.CHOICE_FLAVOR, TransferableFormComponent.PANEL_FLAVOR, TransferableFormComponent.TEXTFIELD_FLAVOR, TransferableFormComponent.TEXT_FLAVOR, TransferableCanvas.CANVAS_FLAVOR};
        this.flavorList = Arrays.asList(flavors);
        this.setDirection(Orientation.VERTICAL);
        if (name == null) {
            name = "form_" + Integer.toHexString(System.identityHashCode(this));
        }
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle(dne);
        }
        this.label = label;
        this.dndSupport = new FormContainer.ContainerDnDSupport(null);
    }

    FormTab(Element element, FormBase form) throws DasException, ParsedExpressionException, SAXException {
        DataFlavor[] flavors = new DataFlavor[]{TransferableFormComponent.BUTTONGROUP_FLAVOR, TransferableFormComponent.BUTTON_FLAVOR, TransferableFormComponent.CHECKBOX_FLAVOR, TransferableFormComponent.CHOICE_FLAVOR, TransferableFormComponent.PANEL_FLAVOR, TransferableFormComponent.TEXTFIELD_FLAVOR, TransferableFormComponent.TEXT_FLAVOR, TransferableCanvas.CANVAS_FLAVOR};
        this.flavorList = Arrays.asList(flavors);
        String alignment = element.getAttribute("alignment");
        this.horizontalComponentAlignment = alignment.equals("left") ? 0.0f : (alignment.equals("right") ? 1.0f : 0.5f);
        String name = element.getAttribute("name");
        String label = element.getAttribute("label");
        this.setDirection(Orientation.VERTICAL);
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle(dne);
        }
        if (label.equals("")) {
            this.setLabel(name);
        } else {
            this.setLabel(label);
        }
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int index = 0; index < length; ++index) {
            Node node = children.item(index);
            if (!(node instanceof Element)) continue;
            String tagName = node.getNodeName();
            if (tagName.equals("panel")) {
                try {
                    FormPanel p = new FormPanel((Element)node, form);
                    this.add(p);
                }
                catch (ParseException ex) {
                    DasExceptionHandler.handle(ex);
                }
                continue;
            }
            if (tagName.equals("text") || tagName.equals("info")) {
                FormText text = new FormText((Element)node);
                this.add(text);
                continue;
            }
            if (tagName.equals("textfield")) {
                FormTextField textfield = new FormTextField((Element)node, form);
                this.add(textfield);
                continue;
            }
            if (tagName.equals("button")) {
                FormButton button = new FormButton((Element)node, form);
                this.add(button);
                continue;
            }
            if (tagName.equals("checkbox")) {
                FormCheckBox checkbox = new FormCheckBox((Element)node, form);
                this.add(checkbox);
                continue;
            }
            if (tagName.equals("list")) {
                FormList list = new FormList((Element)node, form);
                this.add(list);
                continue;
            }
            if (tagName.equals("choice")) {
                FormChoice choice = new FormChoice((Element)node, form);
                this.add(choice);
                continue;
            }
            if (tagName.equals("glue")) {
                this.add(form.processGlueElement((Element)node));
                continue;
            }
            if (tagName.equals("buttongroup")) {
                this.add(new FormRadioButtonGroup((Element)node, form));
                continue;
            }
            if (!tagName.equals("canvas")) continue;
            try {
                DasCanvas canvas = DasCanvas.processCanvasElement((Element)node, form);
                canvas.setAlignmentX(this.horizontalComponentAlignment);
                this.add(canvas);
                continue;
            }
            catch (DasException dne) {
                DasExceptionHandler.handle(dne);
                continue;
            }
            catch (ParseException ex) {
                DasExceptionHandler.handle(ex);
            }
        }
        this.dndSupport = new FormContainer.ContainerDnDSupport(null);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        FormBase form = this.getForm();
        if (form != null) {
            form.setTitleAt(this.getForm().indexOfComponent(this), label);
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("form");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("label", this.getLabel());
        for (int index = 0; index < this.getComponentCount(); ++index) {
            Element child;
            Component comp = this.getComponent(index);
            if (comp instanceof FormComponent) {
                FormComponent formComponent = (FormComponent)((Object)comp);
                child = formComponent.getDOMElement(document);
                element.appendChild(child);
                continue;
            }
            if (!(comp instanceof DasCanvas)) continue;
            DasCanvas canvas = (DasCanvas)comp;
            child = canvas.getDOMElement(document);
            element.appendChild(child);
        }
        return element;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String name) throws DasNameException {
        if (name.equals(this.dasName)) {
            return;
        }
        String oldName = this.dasName;
        this.dasName = name;
        DasApplication app = this.getDasApplication();
        if (app != null) {
            app.getNameContext().put(name, this);
            if (oldName != null) {
                app.getNameContext().remove(oldName);
            }
        }
        this.firePropertyChange("name", oldName, name);
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new FormContainer.ContainerDnDSupport(null);
        }
        return this.dndSupport;
    }

    public void deregisterComponent() {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            try {
                if (nc.get(this.getDasName()) == this) {
                    nc.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dpe) {
                IllegalStateException se = new IllegalStateException(dpe.toString());
                se.initCause(dpe);
                throw se;
            }
            catch (InvocationTargetException ite) {
                IllegalStateException se = new IllegalStateException(ite.toString());
                se.initCause(ite);
                throw se;
            }
        }
        super.deregisterComponent();
    }

    public final DasApplication getDasApplication() {
        Container p = this.getParent();
        if (p instanceof FormComponent) {
            return ((FormComponent)((Object)p)).getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            nc.put(this.getDasName(), this);
        }
        super.registerComponent();
    }
}

