/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.treetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    private JTable table;
    private int visibleRow;
    private Color unselectedBackground = Color.LIGHT_GRAY;
    private Color selectedBackground = Color.GRAY;

    public TreeTableCellRenderer(TreeModel model) {
        super(model);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, 0, w, this.table.getRowHeight() * this.table.getRowCount());
    }

    public void paint(Graphics g) {
        g.translate(0, -this.visibleRow * this.getHeight() / this.getRowCount());
        super.paint(g);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.table = table;
        this.visibleRow = row;
        this.setBackground(isSelected ? this.selectedBackground : this.unselectedBackground);
        return this;
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public Color getUnselectedBackground() {
        return this.unselectedBackground;
    }

    public void setSelectedBackground(Color c) {
        this.selectedBackground = c;
    }

    public void setUnselectedBackground(Color c) {
        this.unselectedBackground = c;
    }
}

