/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class PropertyCellRenderer
extends JLabel
implements TableCellRenderer,
TreeCellRenderer,
ListCellRenderer {
    private static DecimalFormat expFormat = new DecimalFormat("0.#######E0");
    JCheckBox booleanRenderer;

    public PropertyCellRenderer() {
        super("Label");
        this.setFont(this.getFont().deriveFont(0));
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.booleanRenderer = new JCheckBox();
        this.booleanRenderer.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        double doubleValue;
        if (value instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)value;
            this.setIcon(enumeration.getListIcon());
        } else {
            this.setIcon(null);
        }
        if (value instanceof Boolean) {
            this.booleanRenderer.setSelected((Boolean)value);
            this.booleanRenderer.setText(value.toString());
            this.booleanRenderer.setBackground(isSelected ? Color.gray : Color.lightGray);
            return this.booleanRenderer;
        }
        if ((value instanceof Double || value instanceof Float) && ((doubleValue = ((Number)value).doubleValue()) < 0.01 || doubleValue >= 100.0)) {
            value = expFormat.format(doubleValue);
        }
        this.setText(String.valueOf(value));
        this.setOpaque(true);
        this.setBackground(isSelected ? Color.gray : Color.lightGray);
        return this;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        this.setText(String.valueOf(value));
        this.setIcon(null);
        this.setOpaque(false);
        return this;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)value;
            this.setIcon(enumeration.getListIcon());
        } else {
            this.setIcon(null);
        }
        this.setText(String.valueOf(value));
        this.setOpaque(true);
        this.setBackground(isSelected ? Color.gray : Color.lightGray);
        return this;
    }
}

