/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyTreeNode;
import java.beans.IndexedPropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;

class IndexedPropertyItemTreeNode
extends PropertyTreeNode {
    private IndexedPropertyDescriptor indexedPropertyDescriptor;
    private int index;

    IndexedPropertyItemTreeNode(PropertyTreeNode parent, IndexedPropertyDescriptor indexedPropertyDescriptor, int index) {
        super(Array.get(parent.value, index));
        this.index = index;
        this.parent = parent;
        this.propertyDescriptor = indexedPropertyDescriptor;
        this.indexedPropertyDescriptor = indexedPropertyDescriptor;
    }

    public boolean getAllowsChildren() {
        return this.value instanceof Editable;
    }

    String getDisplayName() {
        return this.propertyDescriptor.getName() + "[" + this.index + "]";
    }

    void flush() throws InvocationTargetException {
        try {
            if (this.dirty) {
                Method writeMethod = this.indexedPropertyDescriptor.getIndexedWriteMethod();
                writeMethod.invoke(this.parent.parent.value, new Integer(this.index), this.value);
                this.dirty = false;
            }
            if (this.childDirty) {
                Iterator i = this.children.iterator();
                while (i.hasNext()) {
                    PropertyTreeNode child = (PropertyTreeNode)i.next();
                    child.flush();
                }
                this.childDirty = false;
            }
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }
}

