/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.dasml.FormButton;
import edu.uiowa.physics.pw.das.dasml.FormCheckBox;
import edu.uiowa.physics.pw.das.dasml.FormChoice;
import edu.uiowa.physics.pw.das.dasml.FormList;
import edu.uiowa.physics.pw.das.dasml.FormPanel;
import edu.uiowa.physics.pw.das.dasml.FormRadioButton;
import edu.uiowa.physics.pw.das.dasml.FormRadioButtonGroup;
import edu.uiowa.physics.pw.das.dasml.FormTab;
import edu.uiowa.physics.pw.das.dasml.FormText;
import edu.uiowa.physics.pw.das.dasml.FormTextField;
import edu.uiowa.physics.pw.das.dasml.FormWindow;
import edu.uiowa.physics.pw.das.dasml.TransferableFormComponent;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableCanvas;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableCanvasComponent;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;

public class Toolbox
extends JTabbedPane {
    private static Image pointerOverlay;
    private static Component dummy;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$components$Toolbox$ToolComponent;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$components$Toolbox;

    public Toolbox() {
        this.initializeFormToolComponent();
        this.initializeGraphToolComponent();
    }

    private void initializeFormToolComponent() {
        String[] ids = new String[]{"form tab", "window", "panel", "static text", "text field", "button", "check box", "button group", "radio button", "choice", "list"};
        Class c = class$edu$uiowa$physics$pw$das$components$Toolbox == null ? (class$edu$uiowa$physics$pw$das$components$Toolbox = Toolbox.class$("edu.uiowa.physics.pw.das.components.Toolbox")) : class$edu$uiowa$physics$pw$das$components$Toolbox;
        Icon[] icons = new Icon[]{new ImageIcon(c.getResource("/images/toolbox/tab.gif")), new ImageIcon(c.getResource("/images/toolbox/window.gif")), new ImageIcon(c.getResource("/images/toolbox/panel.gif")), new ImageIcon(c.getResource("/images/toolbox/text.gif")), new ImageIcon(c.getResource("/images/toolbox/textfield.gif")), new ImageIcon(c.getResource("/images/toolbox/button.gif")), new ImageIcon(c.getResource("/images/toolbox/checkbox.gif")), new ImageIcon(c.getResource("/images/toolbox/buttongroup.gif")), new ImageIcon(c.getResource("/images/toolbox/radiobutton.gif")), new ImageIcon(c.getResource("/images/toolbox/choice.gif"))};
        ToolComponent tc = new ToolComponent(ids, icons, 4);
        this.add("Form", tc);
    }

    private void initializeGraphToolComponent() {
        String[] ids = new String[]{"canvas", "plot", "axis", "time axis", "spectrogram renderer", "line plot renderer", "spectrogram plot"};
        Class c = class$edu$uiowa$physics$pw$das$components$Toolbox == null ? (class$edu$uiowa$physics$pw$das$components$Toolbox = Toolbox.class$("edu.uiowa.physics.pw.das.components.Toolbox")) : class$edu$uiowa$physics$pw$das$components$Toolbox;
        Icon[] icons = new Icon[]{new ImageIcon(c.getResource("/images/toolbox/canvas.gif")), new ImageIcon(c.getResource("/images/toolbox/plot.gif")), new ImageIcon(c.getResource("/images/toolbox/axis.gif")), new ImageIcon(c.getResource("/images/toolbox/taxis.gif")), new ImageIcon(c.getResource("/images/toolbox/spectrogram.gif")), new ImageIcon(c.getResource("/images/toolbox/line.gif")), new ImageIcon(c.getResource("/images/toolbox/spectrogram_plot.gif"))};
        ToolComponent tc = new ToolComponent(ids, icons, 4);
        this.add("Graph", tc);
    }

    private static Transferable createTransferable(String id) {
        if (id.equals("form tab")) {
            return new TransferableFormComponent(new FormTab(null, "label"));
        }
        if (id.equals("window")) {
            return new TransferableFormComponent(new FormWindow(null, "title", 640, 480));
        }
        if (id.equals("panel")) {
            return new TransferableFormComponent(new FormPanel());
        }
        if (id.equals("static text")) {
            return new TransferableFormComponent(new FormText());
        }
        if (id.equals("text field")) {
            return new TransferableFormComponent(new FormTextField(null));
        }
        if (id.equals("button")) {
            return new TransferableFormComponent(new FormButton(null, "label"));
        }
        if (id.equals("check box")) {
            return new TransferableFormComponent(new FormCheckBox(null, "label"));
        }
        if (id.equals("button group")) {
            return new TransferableFormComponent(new FormRadioButtonGroup());
        }
        if (id.equals("radio button")) {
            return new TransferableFormComponent(new FormRadioButton(null, "label"));
        }
        if (id.equals("choice")) {
            return new TransferableFormComponent(new FormChoice(null));
        }
        if (id.equals("list")) {
            return new TransferableFormComponent(new FormList(null));
        }
        if (id.equals("canvas")) {
            return new TransferableCanvas(DasCanvas.createFormCanvas(null, 640, 480));
        }
        if (id.equals("plot")) {
            return new TransferableCanvasComponent(DasPlot.createNamedPlot(null));
        }
        if (id.equals("axis")) {
            return new TransferableCanvasComponent(DasAxis.createNamedAxis(null));
        }
        if (id.equals("time axis")) {
            return new TransferableCanvasComponent(DasAxis.createNamedAxis(null));
        }
        if (id.equals("spectrogram renderer")) {
            DasColorBar cb = DasColorBar.createNamedColorBar(null);
            return new TransferableRenderer(new SpectrogramRenderer(null, cb));
        }
        if (id.equals("line plot renderer")) {
            return new TransferableRenderer(new SymbolLineRenderer((DataSetDescriptor)null));
        }
        if (id.equals("spectrogram plot")) {
            DasPlot plot = DasPlot.createNamedPlot(null);
            DasColorBar colorBar = DasColorBar.createNamedColorBar(plot.getDasName() + "_colorbar");
            SpectrogramRenderer renderer = new SpectrogramRenderer(null, colorBar);
            plot.addRenderer(renderer);
            return new TransferableCanvasComponent(plot);
        }
        throw new IllegalArgumentException(id);
    }

    private static Cursor[] getCursors(String[] ids, Icon[] icons) {
        Cursor[] cursors = new Cursor[icons.length];
        Point origin = new Point(0, 0);
        for (int i = 0; i < cursors.length; ++i) {
            int width = icons[i].getIconWidth();
            int height = icons[i].getIconHeight();
            BufferedImage cimage = new BufferedImage(32, 32, 2);
            Graphics g = cimage.getGraphics();
            icons[i].paintIcon(dummy, g, 8, 8);
            g.drawImage(pointerOverlay, 0, 0, dummy);
            cursors[i] = Toolkit.getDefaultToolkit().createCustomCursor(cimage, origin, ids[i]);
        }
        return cursors;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)new Toolbox(), "Center");
        frame.getContentPane().add((Component)new JTextArea(10, 10), "West");
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        dummy = new Component(){};
        Class cl = class$edu$uiowa$physics$pw$das$components$Toolbox$ToolComponent == null ? (class$edu$uiowa$physics$pw$das$components$Toolbox$ToolComponent = Toolbox.class$("edu.uiowa.physics.pw.das.components.Toolbox$ToolComponent")) : class$edu$uiowa$physics$pw$das$components$Toolbox$ToolComponent;
        URL pointerURL = cl.getResource("/images/toolbox/dragpointer.gif");
        Image image = Toolkit.getDefaultToolkit().getImage(pointerURL);
        MediaTracker tracker = new MediaTracker(dummy);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        pointerOverlay = image;
    }

    private static class InputListener
    extends MouseInputAdapter {
        private InputListener() {
        }

        public void mousePressed(MouseEvent e) {
            ToolComponent tc = (ToolComponent)e.getComponent();
            tc.selectedIndex = tc.positionToIndex(e.getX(), e.getY());
        }
    }

    private static class ToolComponent
    extends JComponent {
        private Icon[] icons;
        private String[] ids;
        private Cursor[] cursors;
        private int width;
        private int height;
        private int selectedIndex = -1;

        private ToolComponent(String[] ids, Icon[] icons, int w) {
            this.ids = ids;
            this.icons = icons;
            this.cursors = Toolbox.getCursors(ids, icons);
            this.width = w;
            this.height = (int)Math.ceil((double)icons.length / (double)w);
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            this.setTransferHandler(null);
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this, 1, new ToolboxDragGestureListener());
            this.addMouseListener(new InputListener());
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        protected void paintComponent(Graphics g) {
            Rectangle clip = g.getClipBounds();
            g.setColor(this.getBackground());
            if (clip == null) {
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                g.fillRect(clip.x, clip.y, clip.width, clip.height);
            }
            g.setColor(this.getForeground());
            for (int index = 0; index < this.icons.length; ++index) {
                int i = index % this.width;
                int j = index / this.width;
                int x = i * 32 + 7;
                int y = j * 32 + 7;
                this.icons[index].paintIcon(this, g, x, y);
                g.drawRect(x - 1, y - 1, 24, 24);
            }
        }

        public Dimension getPreferredSize() {
            int w = this.width * 32 + 6;
            int h = this.height * 32 + 6;
            return new Dimension(w, h);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        private int positionToIndex(int x, int y) {
            for (int index = 0; index < this.icons.length; ++index) {
                int i = index % this.width;
                int j = index / this.width;
                int xi = i * 32 + 7;
                int yi = j * 32 + 7;
                if (x < xi || x >= xi + 24 || y < yi || y >= yi + 24) continue;
                return index;
            }
            return -1;
        }

        public String getToolTipText(MouseEvent event) {
            int index = this.positionToIndex(event.getX(), event.getY());
            if (index == -1) {
                return null;
            }
            return this.ids[index];
        }
    }

    private static class ToolboxDragGestureListener
    implements DragGestureListener,
    DragSourceListener {
        private ToolboxDragGestureListener() {
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            ToolComponent tc = (ToolComponent)dge.getComponent();
            int index = tc.selectedIndex;
            if (index >= 0) {
                Cursor dragCursor = tc.cursors[index];
                Transferable t = Toolbox.createTransferable(tc.ids[index]);
                dge.startDrag(dragCursor, t, this);
            }
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        public void dragEnter(DragSourceDragEvent dsde) {
        }

        public void dragExit(DragSourceEvent dse) {
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }
}

