/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.DefaultVectorDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import edu.uiowa.physics.pw.das.event.DataPointSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionListener;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Psym;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class HistogramSlicer
extends DasPlot
implements DataPointSelectionListener {
    private JDialog popupWindow;
    private Datum xValue;
    private SpectrogramRenderer renderer;

    private HistogramSlicer(SpectrogramRenderer parentRenderer, DasAxis xAxis, DasAxis yAxis) {
        super(xAxis, yAxis);
        this.renderer = parentRenderer;
        SymbolLineRenderer symLineRenderer = new SymbolLineRenderer((DataSetDescriptor)null);
        symLineRenderer.setHistogram(true);
        symLineRenderer.setLineWidth(1.0f);
        symLineRenderer.setPsym(Psym.CROSS);
        this.addRenderer(symLineRenderer);
    }

    public static HistogramSlicer createSlicer(SpectrogramRenderer renderer) {
        DasColorBar sourceZAxis = renderer.getColorBar();
        DasAxis xAxis = new DasAxis(sourceZAxis.getDataMinimum(), sourceZAxis.getDataMaximum(), 2, sourceZAxis.isLog());
        DasAxis yAxis = new DasAxis(Datum.create(0.0), Datum.create(1.0), 3);
        return new HistogramSlicer(renderer, xAxis, yAxis);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    HistogramSlicer.this.showPopupImpl();
                }
            };
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    private void createPopup() {
        int width = this.renderer.getParent().getCanvas().getWidth() / 2;
        int height = this.renderer.getParent().getCanvas().getHeight() / 2;
        DasCanvas canvas = new DasCanvas(width, height);
        DasRow row = new DasRow(canvas, 0.1, 0.9);
        DasColumn column = new DasColumn(canvas, 0.1, 0.9);
        canvas.add(this, row, column);
        JPanel content = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        BoxLayout buttonLayout = new BoxLayout(buttonPanel, 0);
        JButton close = new JButton("Hide Window");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HistogramSlicer.this.popupWindow.setVisible(false);
            }
        });
        buttonPanel.setLayout(buttonLayout);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(close);
        content.add((Component)canvas, "Center");
        content.add((Component)buttonPanel, "South");
        Window parentWindow = SwingUtilities.getWindowAncestor(this.renderer.getParent());
        this.popupWindow = parentWindow instanceof Frame ? new JDialog((Frame)parentWindow) : (parentWindow instanceof Dialog ? new JDialog((Dialog)parentWindow) : new JDialog());
        this.popupWindow.setTitle("Histogram Slicer");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(content);
        this.popupWindow.pack();
        Point parentLocation = new Point();
        SwingUtilities.convertPointToScreen(parentLocation, this.renderer.getParent().getCanvas());
        this.popupWindow.setLocation(parentLocation.x + this.renderer.getParent().getCanvas().getWidth(), parentLocation.y + height);
    }

    public void DataPointSelected(DataPointSelectionEvent e) {
        DataSet ds = e.getDataSet();
        if (ds == null || !(ds instanceof TableDataSet)) {
            return;
        }
        Datum yValue = e.getY();
        this.xValue = e.getX();
        TableDataSet tds = (TableDataSet)ds;
        int itable = TableUtil.tableIndexAt(tds, DataSetUtil.closestColumn(tds, e.getX()));
        VectorDataSet sliceDataSet = tds.getYSlice(TableUtil.closestRow(tds, itable, e.getY()), itable);
        DasColorBar cb = this.renderer.getColorBar();
        DasAxis xAxis = this.getXAxis();
        if (!xAxis.getUnits().equals(cb.getUnits())) {
            xAxis.setUnits(cb.getUnits());
            xAxis.setDataRange(cb.getDataMinimum(), cb.getDataMaximum());
            xAxis.setLog(cb.isLog());
        }
        VectorDataSet hist = this.getHistogram(sliceDataSet);
        this.getRenderer(0).setDataSet(hist);
        if (this.xValue.getUnits() instanceof TimeLocationUnits) {
            TimeDatumFormatter formatter = TimeDatumFormatter.DEFAULT;
        } else {
            DatumFormatter formatter = this.xValue.getFormatter();
        }
        if (this.popupWindow != null && !this.popupWindow.isVisible() || this.getCanvas() == null) {
            this.showPopup();
        } else {
            this.repaint();
        }
    }

    public VectorDataSet getHistogram(VectorDataSet vds) {
        int BINS_PER_DECADE = 8;
        DasColorBar zAxis = this.renderer.getColorBar();
        Units yUnits = zAxis.getUnits();
        double min = this.getXAxis().getDataMinimum(yUnits);
        double max = this.getXAxis().getDataMaximum(yUnits);
        int sampleCount = vds.getXLength();
        if (zAxis.isLog()) {
            double minLog = Math.floor(DasMath.log10(min));
            double maxLog = Math.ceil(DasMath.log10(max));
            int binCount = (int)(maxLog - minLog) * 8;
            double[] bins = new double[binCount];
            for (int i = 0; i < vds.getXLength(); ++i) {
                double[] newBins;
                int binCountDelta;
                double y = vds.getDouble(i, yUnits);
                if (yUnits.isFill(y) || Double.isNaN(y)) {
                    --sampleCount;
                    continue;
                }
                double yLog = DasMath.log10(y);
                if (yLog < minLog) {
                    double newMinLog = Math.floor(yLog);
                    binCountDelta = (int)Math.floor(minLog - newMinLog) * 8;
                    newBins = new double[binCount += binCountDelta];
                    System.arraycopy(bins, 0, newBins, binCountDelta, bins.length);
                    minLog = newMinLog;
                    bins = newBins;
                } else if (yLog >= maxLog) {
                    double newMaxLog = Math.ceil(yLog + 0.001);
                    binCountDelta = (int)(newMaxLog - maxLog) * 8;
                    newBins = new double[binCount += binCountDelta];
                    System.arraycopy(bins, 0, newBins, 0, bins.length);
                    maxLog = newMaxLog;
                    bins = newBins;
                }
                int index = (int)Math.floor((yLog - minLog) * 8.0);
                if (index < 0 || index >= bins.length) continue;
                int n = index;
                bins[n] = bins[n] + 1.0;
            }
            double[] x = new double[binCount];
            for (int index = 0; index < binCount; ++index) {
                x[index] = DasMath.exp10(minLog + (double)index / 8.0);
                bins[index] = bins[index] / (double)sampleCount;
            }
            return new DefaultVectorDataSet(x, yUnits, bins, Units.dimensionless, Collections.EMPTY_MAP);
        }
        min = Math.floor(min);
        max = Math.ceil(max);
        int binCount = (int)(max - min);
        double[] bins = new double[binCount];
        for (int i = 0; i < vds.getXLength(); ++i) {
            double[] newBins;
            int binCountDelta;
            double y = vds.getDouble(i, yUnits);
            if (yUnits.isFill(y) || Double.isNaN(y)) {
                --sampleCount;
                continue;
            }
            if (y < min) {
                double newMin = Math.floor(y);
                binCountDelta = (int)(min - newMin);
                newBins = new double[binCount += binCountDelta];
                System.arraycopy(bins, 0, newBins, binCountDelta, bins.length);
                min = newMin;
                bins = newBins;
            } else if (y >= max) {
                double newMax = Math.ceil(y + 0.001);
                binCountDelta = (int)(newMax - max);
                newBins = new double[binCount += binCountDelta];
                System.arraycopy(bins, 0, newBins, 0, bins.length);
                max = newMax;
                bins = newBins;
            }
            int index = (int)Math.floor(y - min);
            if (index < 0 || index >= bins.length) continue;
            int n = index;
            bins[n] = bins[n] + 1.0;
        }
        double[] x = new double[binCount];
        for (int index = 0; index < binCount; ++index) {
            x[index] = min + (double)index + 0.5;
            bins[index] = bins[index] / (double)sampleCount;
        }
        return new DefaultVectorDataSet(x, yUnits, bins, Units.dimensionless, Collections.EMPTY_MAP);
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
    }

    protected void installComponent() {
        super.installComponent();
    }
}

