/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.client;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetBuilder;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamComment;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamHandler;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.util.HashMap;
import java.util.Map;

public class DataSetStreamHandler
implements StreamHandler {
    StreamHandlerDelegate delegate;
    StreamDescriptor sd;
    Map extraProperties;
    DasProgressMonitor monitor;
    int totalPacketCount = -1;
    int taskSize = -1;
    int packetCount = 0;

    public DataSetStreamHandler(Map extraProperties, DasProgressMonitor _monitor, Datum _start, Datum end) {
        this.extraProperties = new HashMap(extraProperties);
        this.monitor = _monitor == null ? DasProgressMonitor.NULL : _monitor;
    }

    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finest("got stream descriptor");
        this.sd = sd;
        Object o = sd.getProperty("taskSize");
        if (o != null) {
            this.taskSize = (Integer)o;
            this.monitor.setTaskSize(this.taskSize);
        } else {
            o = sd.getProperty("packetCount");
            if (o != null) {
                this.totalPacketCount = (Integer)o;
                this.monitor.setTaskSize(this.totalPacketCount);
            }
        }
    }

    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finest("got packet descriptor");
        if (this.delegate == null) {
            SkeletonDescriptor descriptor = pd.getYDescriptor(0);
            if (descriptor instanceof StreamMultiYDescriptor) {
                DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).fine("using VectorDS delegate");
                this.delegate = new VectorDataSetStreamHandler(pd);
            } else if (descriptor instanceof StreamYScanDescriptor) {
                DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).fine("using TableDS delegate");
                this.delegate = new TableDataSetStreamHandler(pd);
            }
        } else {
            this.delegate.packetDescriptor(pd);
        }
    }

    public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws StreamException {
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finest("got packet");
        this.ensureNotNullDelegate();
        this.delegate.packet(pd, xTag, vectors);
        ++this.packetCount;
        if (this.totalPacketCount != -1) {
            this.monitor.setTaskProgress(this.packetCount);
        }
    }

    public void streamClosed(StreamDescriptor sd) throws StreamException {
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finest("got streamClosed");
        if (this.delegate != null) {
            this.delegate.streamClosed(sd);
        }
    }

    public void streamException(StreamException se) throws StreamException {
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finest("got stream exception");
    }

    public void streamComment(StreamComment sc) throws StreamException {
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finest("got stream comment");
        if (sc.getType().equals(sc.TYPE_TASK_PROGRESS) && this.taskSize != -1) {
            this.monitor.setTaskProgress(Long.parseLong(sc.getValue()));
        }
    }

    public DataSet getDataSet() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getDataSet();
    }

    private void ensureNotNullDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Null delegate");
        }
    }

    private static double getXWithBase(Datum base, Datum x) {
        if (base == null) {
            return x.doubleValue(x.getUnits());
        }
        return base.doubleValue(base.getUnits()) + x.doubleValue(base.getUnits().getOffsetUnits());
    }

    private class TableDataSetStreamHandler
    implements StreamHandlerDelegate {
        private TableDataSetBuilder builder;

        private TableDataSetStreamHandler(PacketDescriptor pd) throws StreamException {
            StreamYScanDescriptor y = (StreamYScanDescriptor)pd.getYDescriptor(0);
            Datum base = pd.getXDescriptor().getBase();
            Units xUnits = base != null ? base.getUnits() : pd.getXDescriptor().getUnits();
            Units yUnits = y.getYUnits();
            Units zUnits = y.getZUnits();
            this.builder = new TableDataSetBuilder(xUnits, yUnits, zUnits);
            this.packetDescriptor(pd);
        }

        public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws StreamException {
            StreamYScanDescriptor yscan = (StreamYScanDescriptor)pd.getYDescriptor(0);
            Datum base = pd.getXDescriptor().getBase();
            Datum x = base == null ? xTag : base.add(xTag);
            DatumVector y = DatumVector.newDatumVector(yscan.getYTags(), yscan.getYUnits());
            String[] planeIDs = new String[pd.getYCount()];
            for (int i = 0; i < pd.getYCount(); ++i) {
                planeIDs[i] = ((StreamYScanDescriptor)pd.getYDescriptor(i)).getName();
            }
            this.builder.insertYScan(x, y, vectors, planeIDs);
        }

        public void packetDescriptor(PacketDescriptor pd) throws StreamException {
            StreamYScanDescriptor y = (StreamYScanDescriptor)pd.getYDescriptor(0);
            for (int i = 1; i < pd.getYCount(); ++i) {
                y = (StreamYScanDescriptor)pd.getYDescriptor(i);
                this.builder.addPlane(y.getName(), y.getZUnits());
            }
        }

        public void streamClosed(StreamDescriptor sd) throws StreamException {
        }

        public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        }

        public void streamException(StreamException se) throws StreamException {
        }

        public void streamComment(StreamComment sc) throws StreamException {
        }

        public DataSet getDataSet() {
            this.builder.addProperties(DataSetStreamHandler.this.sd.getProperties());
            this.builder.addProperties(DataSetStreamHandler.this.extraProperties);
            return this.builder.toTableDataSet();
        }
    }

    private class VectorDataSetStreamHandler
    implements StreamHandlerDelegate {
        private VectorDataSetBuilder builder;
        private double[] doubles = new double[1];

        private VectorDataSetStreamHandler(PacketDescriptor pd) throws StreamException {
            StreamMultiYDescriptor y = (StreamMultiYDescriptor)pd.getYDescriptor(0);
            Datum base = pd.getXDescriptor().getBase();
            Units xUnits = base == null ? pd.getXDescriptor().getUnits() : base.getUnits();
            Units yUnits = y.getUnits();
            this.builder = new VectorDataSetBuilder(xUnits, yUnits);
            this.packetDescriptor(pd);
        }

        public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws StreamException {
            Datum base = pd.getXDescriptor().getBase();
            double x = DataSetStreamHandler.getXWithBase(base, xTag);
            for (int i = 0; i < pd.getYCount(); ++i) {
                if (pd.getYDescriptor(i) instanceof StreamMultiYDescriptor) {
                    StreamMultiYDescriptor my = (StreamMultiYDescriptor)pd.getYDescriptor(i);
                    double y = vectors[i].doubleValue(0, my.getUnits());
                    if (i != 0) {
                        this.builder.insertY(x, y, my.getName());
                        continue;
                    }
                    this.builder.insertY(x, y);
                    continue;
                }
                throw new StreamException("Mixed data sets are not currently supported");
            }
        }

        public void packetDescriptor(PacketDescriptor pd) throws StreamException {
            DasApplication.getDefaultApplication().getDebugLogger().fine("got packet descriptor: " + pd);
            for (int i = 1; i < pd.getYCount(); ++i) {
                StreamMultiYDescriptor y = (StreamMultiYDescriptor)pd.getYDescriptor(i);
                this.builder.addPlane(y.getName(), y.getUnits());
            }
        }

        public void streamClosed(StreamDescriptor sd) throws StreamException {
        }

        public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        }

        public void streamException(StreamException se) throws StreamException {
        }

        public void streamComment(StreamComment sc) throws StreamException {
        }

        public DataSet getDataSet() {
            this.builder.addProperties(DataSetStreamHandler.this.sd.getProperties());
            this.builder.addProperties(DataSetStreamHandler.this.extraProperties);
            return this.builder.toVectorDataSet();
        }
    }

    private static interface StreamHandlerDelegate
    extends StreamHandler {
        public DataSet getDataSet();
    }
}

