/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das;

import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.NameContext;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Introspector;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

public class DasApplication {
    private static final DasApplication DEFAULT = new DasApplication();
    public static final LoggerId APPLICATION_LOG = new LoggerId("");
    public static final LoggerId SYSTEM_LOG = new LoggerId("system");
    public static final LoggerId GUI_LOG = new LoggerId("gui");
    public static final LoggerId GRAPHICS_LOG = new LoggerId("graphics");
    public static final LoggerId DATA_OPERATIONS_LOG = new LoggerId("data operations");
    public static final LoggerId DATA_TRANSFER_LOG = new LoggerId("data transfer");
    private NameContext nameContext = new NameContext();
    private Logger debugLogger;
    private boolean headless = false;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$DasApplication;

    private static Formatter getLoggerFormatter() {
        return new Formatter(){

            public String format(LogRecord rec) {
                StackTraceElement[] st = new Throwable().getStackTrace();
                return rec.getLoggerName() + "\n" + rec.getLevel().getLocalizedName() + ": " + rec.getMessage() + "\n\tat " + st[7] + "\n\tat " + st[8] + "\n";
            }
        };
    }

    private DasApplication() {
    }

    public NameContext getNameContext() {
        return this.nameContext;
    }

    public static DasApplication getDefaultApplication() {
        return DEFAULT;
    }

    private static boolean isApplet() {
        return false;
    }

    private static boolean isX11() {
        String osName = System.getProperty("os.name");
        return "SunOS".equals(osName) || "Linux".equals(osName);
    }

    public static boolean isHeadAvailable() {
        return true;
    }

    public boolean isHeadless() {
        return "true".equals(System.getProperty("java.awt.headless"));
    }

    public void setHeadless(boolean headless) {
        if (headless) {
            System.setProperty("java.awt.headless", "true");
        } else {
            if (!DasApplication.isHeadAvailable()) {
                throw new IllegalArgumentException("attempt to unset headless when environment is headless.");
            }
            System.setProperty("java.awt.headless", "false");
        }
    }

    public JFrame getMainFrame(Container canvas) {
        JFrame frame = this.getMainFrame();
        frame.setContentPane(canvas);
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public JFrame getMainFrame() {
        final JFrame result = new JFrame("Das2");
        final Preferences prefs = Preferences.userNodeForPackage(class$edu$uiowa$physics$pw$das$DasApplication == null ? (class$edu$uiowa$physics$pw$das$DasApplication = DasApplication.class$("edu.uiowa.physics.pw.das.DasApplication")) : class$edu$uiowa$physics$pw$das$DasApplication);
        int xlocation = prefs.getInt("xlocation", 20);
        int ylocation = prefs.getInt("ylocation", 20);
        result.setLocation(xlocation, ylocation);
        result.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                prefs.putInt("xlocation", result.getLocation().x);
                prefs.putInt("ylocation", result.getLocation().y);
                System.out.println("bye!" + result.getLocation());
            }
        });
        result.setDefaultCloseOperation(3);
        return result;
    }

    public Logger getLogger() {
        return DasProperties.getLogger();
    }

    public Logger getLogger(LoggerId loggerId) {
        return loggerId.getLogger();
    }

    public synchronized Logger getDebugLogger() {
        return Logger.getLogger("debug");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String[] beanInfoSearchPath = new String[]{"edu.uiowa.physics.pw.das.beans"};
        Introspector.setBeanInfoSearchPath(beanInfoSearchPath);
    }

    private static class LoggerId {
        String name;
        Logger logger;

        LoggerId(String name) {
            this.name = name;
            this.logger = Logger.getLogger(name);
            Level level = Level.WARNING;
            Handler[] handlers = this.logger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i].setFormatter(DasApplication.getLoggerFormatter());
                handlers[i].setLevel(level);
            }
            this.logger.setLevel(level);
            this.logger.log(this.logger.getLevel(), name + " logging at " + this.logger.getLevel());
        }

        public String toString() {
            return this.name;
        }

        public Logger getLogger() {
            return this.logger;
        }
    }
}

